.TH aconvert 1 "AF"
.SH NAME
aconvert - convert audio data
.SH SYNOPSIS
.B aconvert
[options] [inp] [out]
.SH DESCRIPTION
The \fIaconvert\fP program 
is used to convert between different audio file formats, sampling rates
and sample sizes.

.SH OPTIONS
\fIaconvert\fP accepts the following command line options:
.TP 8
.B \-a
Auto Gain Control (AGC) enable.
.TP 8
.B \-b
Byte swap input data.
.TP 8
.B \-c
Copy raw header information from \fIinput\fP to \fIoutput\fP when a header
is skipped using the \fI-j\fP option.
.TP 8
.BI \-f " order"
The specified
.I order
will be used for the FIR filter when converting between different sampling
rates (default is 10).
.TP 8
.BI \-g " gain"
The specified
.I gain
will be used between input and output files
(default is 1.0).
.TP 8
.BI \-j " bytes"
The specified number of
.I bytes
will be skipped from the input file for \fIraw\fP input data
(default is 0).
.TP 8
.BI \-m " units"
No more than the specified number of
.I units
will be input. A value of \fI0\fP implies no limit. This number is also
used to generate a specific number of samples for ``fake'' inputs
(\fIsweep\fP, \fItone\fP and \fIwhite\fP).
.TP 8
.B \-s
Output statistics on standard error.
.TP 8
.B \-v
Enable silence compression of input (vox). This will only work on single
channel input.

.SH INP/OUT
The \fIinp\fP and \fIout\fP arguments are of the form:
.TP 8
[name][,option...]
.PP
Where \fIname\fP may be the desired filename or \fI-\fP for stdin/stdout
(default is stdin/stdout if the \fIname\fP is left off).
\fIoption\fP may be any of:
.TP 16
.B b[its]=num
Specifies bit width of 1 sample. Default is 8.
.TP 16
.B c[hans]=num[:mix...]
Specifies input/output channels. \fInum\fP is the total number of channels
either feeding the input or feeding the output (after input mixing). Each
\fI:mix\fP entry specifies how the input channels are mixed into an output
channel.
.IP "" 16
For example:
.I
chans=4:12:34
specifies that there are 4 channels which will be mixed down to 2 channels.
The first will be mixed from channels 1 and 2, while the second will be
mixed from channels 3 and 4. If you only specify the \fInum\fP value on
input, all of the channels will be preserved (i.e. c=4 is the same as
c=4:1:2:3:4).
.IP "" 16
If you specify more channels on output than on input, channels will be
duplicated. For example:
.I
chans=2:1:2:12
will take a stero stream add a third channel which is the mixture of streams
1 and 2. Whenever possible, down-mix/drop any channels on input (rather
than on output)... this is MUCH more efficient.
.IP "" 16
If you do not specify the number of channels on output, all
channels will be mixed into a single output channel. The default is 1 channel
in and one channel out.
.TP 16
.B e[xpon]=num
FFT Peak enhancement factor. Default is 0.6
.TP 16
.B [f[ormat]=]fmt
File format. Legal values are:

.RS 8
.IP \fIascii\fP 8
data is read/written in ASCII.
8bit data is in hex, 16bit data is in
decimal and FFT vectors are in floating point.
.IP \fIhtk\fP
Hidden Markov Toolkit format.
.IP \fIraw\fP
no header (default).
.IP \fIsphere\fP
NIST standard format (e.g., Timit database).
.RE

.TP 16
.B i[incr]=samples
Specifies increment between FFT windows. Default is 160.
.TP 16
.B p[arams]=num
Specifies number of parameters (coefficients) per FFT vector. Default is
11. This number actually includes Energy + Peak-to-Peak + Zero-Crossings
+ Actual-Coeffs.
.TP 16
.B [r[ate]=]frequency
Sample frequency in kilohertz. Default is 8.0.
.TP 16
.B s[amples]=samples
Specifies number of samples in an FFT window. Default is 320.
.TP 16
.B [t[ype]=]type
Type of data as listed below:

.TS
lI cI lI
l c l.
Type	Inp/Out	Description
adpcm	I/O	2,3 or [4] bits
alaw	I/O	8 bit data
cepstrum	O	ener+ptp+zc+coeffs
ima	I/O	4 bits
linear	I/O	16 bit data
melcep	O	ener+ptp+zc+coeffs
plp	O	ener+ptp+zc+coeffs
rasta	O	ener+ptp+zc+coeffs
sweep	I	fake linear for -m samples
tone	I	fake linear for -m samples
ulaw	I/O	8 bit data
white	I	fake linear for -m samples
.TE

.SH EXAMPLES
.PP
Here are different ways to
read from an 8 bit, 8khz, raw ULAW file \fIinp.snd\fP and create a 16 bit,
44.1khz, linear SPHERE format stereo audio file \fIout.snd\fP:

.RS
.na
.nf
aconvert inp.snd,t=ulaw,r=8 out.au,t=linear,f=sphere,r=44.1,c=1:1:1
aconvert inp.snd,ulaw,8 out.au,linear,sphere,44.1,c=1:1:1
aconvert inp.snd out.au,linear,sphere,44.1,c=1:1:1
aconvert inp.snd -,linear,sphere,44.1,c=1:1:1 >out.au
aconvert - -,linear,sphere,44.1,c=1:1:1 <inp.snd >out.au
.fi
.RE

.SH "RETURN VALUE"
.PP
none specified.
.SH "SEE ALSO"
.PP
AF(1)
.SH BUGS
.I melcep
and
.I cepstrum
have not been implemented yet.
.SH COPYRIGHT
Copyright 1993-1994, Digital Equipment Corporation.
.br
See \fIAF(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Dave Wecker, Cambridge Research Lab, Digital Equipment Corporation.
