#include "bowl.h"
#include "globals.h"

long KonSystem::buildNumber = 10;
long KonSystem::major = 2;
long KonSystem::minor = 10;

int Settings::tabSize = 8;
int Settings::maxUndoSize = 5120000;
int Settings::rightMargin = 80;
int Settings::autosaveDelay = 60;
int Settings::leftMarginChars = 6;
ColorValue Settings::markFg = Color::BLACK;
ColorValue Settings::markBg = Color::LIGHTGRAY;
ColorValue Settings::hiliteFg = Color::WHITE;
ColorValue Settings::hiliteBg = Color::BLUE;
ColorValue Settings::hexCursorFg = Color::WHITE;
ColorValue Settings::hexCursorBg = Color::LIGHTGRAY;
ColorValue Settings::textFg = Color::BLACK;
ColorValue Settings::textBg = Color::WHITE;
ColorValue Settings::markerFg = Color::WHITE;
ColorValue Settings::markerBg = Color::RED;
ColorValue Settings::leftMarginBg = Color::GRAY;
ColorValue Settings::leftMarginFg = Color::LIGHTGRAY;
char *Settings::standardDelim = " \t,.;:+-*/\"'/(){}[]<>";
char *Settings::autosavePath = "";
BOOL Settings::columnBlock = FALSE;
BOOL Settings::CRLF = TRUE;
BOOL Settings::stripNameInNotebook = TRUE;
BOOL Settings::insertMode = TRUE;
BOOL Settings::backupFiles = TRUE;
BOOL Settings::persistentBlocks = FALSE;
BOOL Settings::showRightMargin = TRUE;
BOOL Settings::syntaxHighlight = TRUE;
BOOL Settings::autoSave = TRUE;
BOOL Settings::useTab = TRUE;
BOOL Settings::optimalFill = TRUE;
char *Settings::asciiFont = NULL;
char *Settings::hexFont = NULL;
int Settings::asciiFontSizeP = -1;
int Settings::hexFontSizeP = -1;
int Settings::asciiFontSizeX = -1;
int Settings::hexFontSizeX = -1;
int Settings::asciiFontSizeY = -1;
int Settings::hexFontSizeY = -1;
BOOL Settings::asciiFixedWidthOnly = TRUE;
BOOL Settings::asciiBitmappedOnly = TRUE;
BOOL Settings::hexBitmappedOnly = TRUE;
BOOL Settings::errorCollectorVisible = FALSE;
char *KonSystem::baseDir = NULL;
char *KonSystem::bmpDir = NULL;
char *KonSystem::kDir = NULL;
BOOL Settings::delimAllocated = FALSE;
BOOL Settings::useSystemFileDialog = TRUE;
BOOL Settings::showLeftMarginInfo = TRUE;
BOOL Settings::showLineNumbers = TRUE;
BOOL Settings::showSavedPos = TRUE;
BOOL Settings::autoCloseFrameWindow = FALSE;
BOOL Settings::showCommandBar = FALSE;
BOOL Settings::virtualSpace = TRUE;
BOOL Settings::showBytesInfo = TRUE;
BOOL Settings::reuseExistingBuffer = TRUE;
BOOL Settings::queryIfUnicode = FALSE;
BOOL Settings::linesInHex = TRUE;
BOOL Settings::showSectionBrowser = TRUE;
BOOL Settings::autogenerateSections = TRUE;
BOOL Settings::autoClearMessages = TRUE;
int Settings::pulldownSize = 15;
BOOL Settings::showToolbar = TRUE;
BOOL Settings::hideAscii32 = FALSE;

BOOL KonSystem::registered = FALSE;
char KonSystem::regName[100] = "";
char KonSystem::regKey[MAXREGCODELEN*2] = "";
time_t KonSystem::startupTime;
char *KonSystem::kClipboard = NULL;

void Settings::saveSettings( FILE * f )
{
	long pos, foo;
	if( !ClassProperties::savePropertyName( f, "GLOBALS002", &pos ) ) return;
	fwrite( &tabSize, sizeof( int ), 1, f );
	fwrite( &maxUndoSize, sizeof( int ), 1, f );
	fwrite( &rightMargin, sizeof( int ), 1, f );
	fwrite( &markFg, sizeof( ColorValue ), 1, f );
	fwrite( &markBg, sizeof( ColorValue ), 1, f );
	fwrite( &hiliteFg, sizeof( ColorValue ), 1, f );
	fwrite( &hiliteBg, sizeof( ColorValue ), 1, f );
	fwrite( &hexCursorFg, sizeof( ColorValue ), 1, f );
	fwrite( &hexCursorBg, sizeof( ColorValue ), 1, f );
	fwrite( &textFg, sizeof( ColorValue ), 1, f );
	fwrite( &textBg, sizeof( ColorValue ), 1, f );
	foo = strlen( standardDelim );
	fwrite( &foo, sizeof( long ), 1, f );
	fwrite( standardDelim, foo+1, 1, f );
	fwrite( &columnBlock, sizeof( BOOL ), 1, f );
	fwrite( &CRLF, sizeof( BOOL ), 1, f );
	fwrite( &stripNameInNotebook, sizeof( BOOL ), 1, f );
	fwrite( &insertMode, sizeof( BOOL ), 1, f );
	fwrite( &backupFiles, sizeof( BOOL ), 1, f );
	fwrite( &persistentBlocks, sizeof( BOOL ), 1, f );
	fwrite( &showRightMargin, sizeof( BOOL ), 1, f );
	foo = strlen( asciiFont );
	fwrite( &foo, sizeof( long ), 1, f );
	fwrite( asciiFont, foo+1, 1, f );
	foo = strlen( hexFont );
	fwrite( &foo, sizeof( long ), 1, f );
	fwrite( hexFont, foo+1, 1, f );
	fwrite( &asciiFontSizeP, sizeof( int ), 1, f );
	fwrite( &asciiFontSizeX, sizeof( int ), 1, f );
	fwrite( &asciiFontSizeY, sizeof( int ), 1, f );
	fwrite( &hexFontSizeP, sizeof( int ), 1, f );
	fwrite( &hexFontSizeX, sizeof( int ), 1, f );
	fwrite( &hexFontSizeY, sizeof( int ), 1, f );
	fwrite( &asciiFixedWidthOnly, sizeof( BOOL ), 1, f );
	fwrite( &asciiBitmappedOnly, sizeof( BOOL ), 1, f );
	fwrite( &hexBitmappedOnly, sizeof( BOOL ), 1, f );
	fwrite( &errorCollectorVisible, sizeof( BOOL ), 1, f );
	fwrite( &syntaxHighlight, sizeof( BOOL ), 1, f );
	fwrite( &autoSave, sizeof( BOOL ), 1, f );
	fwrite( &autosaveDelay, sizeof( BOOL ), 1, f );
	fwrite( &useTab, sizeof( BOOL ), 1, f );
	fwrite( &optimalFill, sizeof( BOOL ), 1, f );
	foo = strlen( autosavePath );
	fwrite( &foo, sizeof( long ), 1, f );
	fwrite( autosavePath, foo+1, 1, f );
	fwrite( &useSystemFileDialog, sizeof( BOOL ), 1, f );
	fwrite( &AGraphics::useBigFont, sizeof( BOOL ), 1, f );
	fwrite( &markerFg, sizeof( ColorValue ), 1, f );
	fwrite( &markerBg, sizeof( ColorValue ), 1, f );
	fwrite( &leftMarginFg, sizeof( ColorValue ), 1, f );
	fwrite( &leftMarginBg, sizeof( ColorValue ), 1, f );
	fwrite( &showLeftMarginInfo, sizeof( BOOL ), 1, f );
	fwrite( &showLineNumbers, sizeof( BOOL ), 1, f );
	fwrite( &showSavedPos, sizeof( BOOL ), 1, f );
	ClassProperties::savePropertySize( f, pos );
	fwrite( &leftMarginChars, sizeof( int ), 1, f );
	fwrite( &autoCloseFrameWindow, sizeof( int ), 1, f );
	fwrite( &showCommandBar, sizeof( BOOL ), 1, f );
	fwrite( &virtualSpace, sizeof( BOOL ), 1, f );
	fwrite( &queryIfUnicode, sizeof( BOOL ), 1, f );
	fwrite( &linesInHex, sizeof( BOOL ), 1, f );
	fwrite( &showSectionBrowser, sizeof( BOOL ), 1, f );
	fwrite( &autogenerateSections, sizeof( BOOL ), 1, f );
	fwrite( &pulldownSize, sizeof( int ), 1, f );
	fwrite( &Settings::autoClearMessages, sizeof( BOOL ), 1, f );
	fwrite( &Settings::showToolbar, sizeof( BOOL ), 1, f );
	fwrite( &Settings::hideAscii32, sizeof( BOOL ), 1, f );
}

void Settings::restoreSettings( FILE * f )
{
	long foo;
	if( !ClassProperties::checkPropertyExists( f, "GLOBALS002" ) ) return;
	fread( &tabSize, sizeof( int ), 1, f );
	fread( &maxUndoSize, sizeof( int ), 1, f );
	fread( &rightMargin, sizeof( int ), 1, f );
	fread( &markFg, sizeof( ColorValue ), 1, f );
	fread( &markBg, sizeof( ColorValue ), 1, f );
	fread( &hiliteFg, sizeof( ColorValue ), 1, f );
	fread( &hiliteBg, sizeof( ColorValue ), 1, f );
	fread( &hexCursorFg, sizeof( ColorValue ), 1, f );
	fread( &hexCursorBg, sizeof( ColorValue ), 1, f );
	fread( &textFg, sizeof( ColorValue ), 1, f );
	fread( &textBg, sizeof( ColorValue ), 1, f );
	fread( &foo, sizeof( long ), 1, f );
	standardDelim = new char[foo+1];
	fread( standardDelim, foo+1, 1, f );
	delimAllocated = TRUE;
	fread( &columnBlock, sizeof( BOOL ), 1, f );
	fread( &CRLF, sizeof( BOOL ), 1, f );
	fread( &stripNameInNotebook, sizeof( BOOL ), 1, f );
	fread( &insertMode, sizeof( BOOL ), 1, f );
	fread( &backupFiles, sizeof( BOOL ), 1, f );
	fread( &persistentBlocks, sizeof( BOOL ), 1, f );
	fread( &showRightMargin, sizeof( BOOL ), 1, f );
	fread( &foo, sizeof( long ), 1, f );
	delete asciiFont;
	asciiFont = new char[foo+1];
	fread( asciiFont, foo+1, 1, f );
	fread( &foo, sizeof( long ), 1, f );
	delete hexFont;
	hexFont = new char[foo+1];
	fread( hexFont, foo+1, 1, f );
	fread( &asciiFontSizeP, sizeof( int ), 1, f );
	fread( &asciiFontSizeX, sizeof( int ), 1, f );
	fread( &asciiFontSizeY, sizeof( int ), 1, f );
	fread( &hexFontSizeP, sizeof( int ), 1, f );
	fread( &hexFontSizeX, sizeof( int ), 1, f );
	fread( &hexFontSizeY, sizeof( int ), 1, f );
	fread( &asciiFixedWidthOnly, sizeof( BOOL ), 1, f );
	fread( &asciiBitmappedOnly, sizeof( BOOL ), 1, f );
	fread( &hexBitmappedOnly, sizeof( BOOL ), 1, f );
	fread( &errorCollectorVisible, sizeof( BOOL ), 1, f );
	fread( &syntaxHighlight, sizeof( BOOL ), 1, f );
	fread( &autoSave, sizeof( BOOL ), 1, f );
	fread( &autosaveDelay, sizeof( BOOL ), 1, f );
	fread( &useTab, sizeof( BOOL ), 1, f );
	fread( &optimalFill, sizeof( BOOL ), 1, f );
	fread( &foo, sizeof( long ), 1, f );
	autosavePath = new char[foo+1];
	fread( autosavePath, foo+1, 1, f );
	fread( &useSystemFileDialog, sizeof( BOOL ), 1, f );
	fread( &AGraphics::useBigFont, sizeof( BOOL ), 1, f );
	fread( &markerFg, sizeof( ColorValue ), 1, f );
	fread( &markerBg, sizeof( ColorValue ), 1, f );
	fread( &leftMarginFg, sizeof( ColorValue ), 1, f );
	fread( &leftMarginBg, sizeof( ColorValue ), 1, f );
	fread( &showLeftMarginInfo, sizeof( BOOL ), 1, f );
	fread( &showLineNumbers, sizeof( BOOL ), 1, f );
	fread( &showSavedPos, sizeof( BOOL ), 1, f );
	fread( &leftMarginChars, sizeof( int ), 1, f );
	fread( &autoCloseFrameWindow, sizeof( int ), 1, f );
	fread( &showCommandBar, sizeof( BOOL ), 1, f );
	fread( &virtualSpace, sizeof( BOOL ), 1, f );
	fread( &queryIfUnicode, sizeof( BOOL ), 1, f );
	fread( &linesInHex, sizeof( BOOL ), 1, f );
	fread( &showSectionBrowser, sizeof( BOOL ), 1, f );
	fread( &autogenerateSections, sizeof( BOOL ), 1, f );
	fread( &pulldownSize, sizeof( int ), 1, f );
	fread( &Settings::autoClearMessages, sizeof( BOOL ), 1, f );
	fread( &Settings::showToolbar, sizeof( BOOL ), 1, f );
	fread( &Settings::hideAscii32, sizeof( BOOL ), 1, f );
}

void Settings::initSettings()
{
	asciiFont = new char[strlen( Graphics::getEditorFontName())+1];
	strcpy( asciiFont, Graphics::getEditorFontName() );
	hexFont = new char[strlen( Graphics::getHexEditorFontName())+1];
	strcpy( hexFont, Graphics::getHexEditorFontName() );
	asciiFontSizeP = Graphics::getEditorFontSize();
	hexFontSizeP = Graphics::getHexEditorFontSize();
	autosavePath = new char[strlen(KonSystem::baseDir) + 6];
	strcpy( autosavePath, KonSystem::baseDir );
	strcat( autosavePath, "ASV\\" );
}
