/***************************************************************************\
 *
 * PROGRAMMNAME: AMOUDLL
 * -------------
 *
 * VERSION: 2.70
 * --------
 *
 * MODULNAME: AMOUINI
 * ----------
 *
 * BESCHREIBUNG:
 * -------------
 *   This DLL is registered at the OS/2 Presentation Manager. It starts
 *   the WheelThread after establishing the semaphores and shared memory
 *   necessary for communication with the WPS class
 *
 * FUNKTIONEN:
 * -----------
 *
 *  Ver.    Date      Comment
 *  ----    --------  -------
 *  1.00    20-02-00  First release
 *  2.00    06-16-01  WheelThread in separate process
 *  2.10    05-12-02  Handling of shift-keys
 *  2.20    10-03-02  USB support added
 *  2.40    02-01-03  support for 2 wheels; wildcards for process name
 *  2.50    04-20-03  application behaviour support added
 *  2.60    06-13-04  remove unused settings pages from mouse object
 *  2.70    10-23-04  support for 7 buttons added
 *
 *  Copyright (C) noller & breining software 2001...2004
 *
\******************************************************************************/
#define INCL_DOSMEMMGR
#define INCL_DOSSEMAPHORES
#define INCL_DOSPROCESS
#define INCL_WINSHELLDATA
#include <os2.h>
#include <string.h>
#include <stdlib.h>

#include <Log.h>
#include "AMouData.h"
#include "AMouIni.h"
#include "res.h"

/*******************************************************************\
  local data segment (process specific)
\*******************************************************************/

/*******************************************************************\
  global data segment
\*******************************************************************/
#pragma data_seg(GLOBAL_SEG)

VOID queryData (VOID)
    {
    ULONG ulc, ul, ulcProfile;
    PCHAR pc, pProfile, pApps;

    DosRequestMutexSem (hmtxWheelThread, (ULONG)SEM_INDEFINITE_WAIT);

    pShMemMouseData->ulScrollMode    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE,    SCROLL_MODE_STD);
    pShMemMouseData->ulScrollModeC   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE_C,  SCROLL_MODE_NONE);
    pShMemMouseData->ulScrollModeA   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLMODE_A,  SCROLL_MODE_NONE);
    pShMemMouseData->ulScrollNum     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM,     3);
    pShMemMouseData->ulScrollNumC    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM_C,   3);
    pShMemMouseData->ulScrollNumA    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_SCROLLNUM_A,   3);
    pShMemMouseData->ulWheelTarget   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET,   WHEEL_TARGET_POINTER);
    pShMemMouseData->ulWheelTargetC  = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET_C, WHEEL_TARGET_POINTER);
    pShMemMouseData->ulWheelTargetA  = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELTARGET_A, WHEEL_TARGET_POINTER);
    pShMemMouseData->ulStartupMode   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_STARTUPMODE,   SCROLL_DIR_VERT);
    pShMemMouseData->ulAccelDelay    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELDELAY,    SCROLL_DIR_VERT);
    pShMemMouseData->ulAccelValue    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELVALUE,    SCROLL_DIR_VERT);
    pShMemMouseData->ulBtn3Mode      = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_BTN3MODE,      IDR_DEFAULT_KEY3);
    pShMemMouseData->ulBtn4Mode      = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_BTN4MODE,      IDR_DEFAULT_KEY4);
    pShMemMouseData->ulBtn5Mode      = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_BTN5MODE,      IDR_DEFAULT_KEY5);
    pShMemMouseData->ulBtn6Mode      = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_BTN6MODE,      IDR_DEFAULT_KEY6);
    pShMemMouseData->ulBtn7Mode      = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_BTN7MODE,      IDR_DEFAULT_KEY7);
    pShMemMouseData->ulCBtn3Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_CBTN3MODE,     IDR_DEFAULT_KEYC3);
    pShMemMouseData->ulCBtn4Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_CBTN4MODE,     IDR_DEFAULT_KEYC4);
    pShMemMouseData->ulCBtn5Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_CBTN5MODE,     IDR_DEFAULT_KEYC5);
    pShMemMouseData->ulCBtn6Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_CBTN6MODE,     IDR_DEFAULT_KEYC6);
    pShMemMouseData->ulCBtn7Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_CBTN7MODE,     IDR_DEFAULT_KEYC7);
    pShMemMouseData->ulABtn3Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ABTN3MODE,     IDR_DEFAULT_KEYA3);
    pShMemMouseData->ulABtn4Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ABTN4MODE,     IDR_DEFAULT_KEYA4);
    pShMemMouseData->ulABtn5Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ABTN5MODE,     IDR_DEFAULT_KEYA5);
    pShMemMouseData->ulABtn6Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ABTN6MODE,     IDR_DEFAULT_KEYA6);
    pShMemMouseData->ulABtn7Mode     = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ABTN7MODE,     IDR_DEFAULT_KEYA7);
    pShMemMouseData->ulPollingRate   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_POLLINGRATE,   DEF_VALUE_POLLING_RATE);
    pShMemMouseData->ulAccelLevel1   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL1,   DEF_VALUE_ACCEL_LEVEL1);
    pShMemMouseData->ulAccelLvl1Mult = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL1MULT, DEF_VALUE_ACCEL_L1MULT);
    pShMemMouseData->ulAccelLevel2   = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLEVEL2,   DEF_VALUE_ACCEL_LEVEL2);
    pShMemMouseData->ulAccelLvl2Mult = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_ACCELLVL2MULT, DEF_VALUE_ACCEL_L2MULT);
    pShMemMouseData->ulWheelCount    = PrfQueryProfileInt (HINI_USERPROFILE, APP_AMOUSE, KEY_WHEELCOUNT,    DEF_VALUE_WHEELCOUNT);

    /* read and reformat application definition data */
    PrfQueryProfileSize (HINI_USERPROFILE, APP_AMOUSE, KEY_APPLICATIONS, &ulcProfile);
    pProfile = (PCHAR)malloc (ulcProfile);
    PrfQueryProfileData (HINI_USERPROFILE, APP_AMOUSE, KEY_APPLICATIONS, pProfile, &ulcProfile);
    pc = pProfile;

    pApps = pShMemMouseData->cApplications;
    pShMemMouseData->ulcApplications = 0;
    while (pc < pProfile + ulcProfile && pc[0] != '\0')
        {
        pc += strlen (pc) + 1;              // overread szDescription
        for (ulc = ul = 0; ul < 4; ul++)
            while (pc[ulc++] != '\0')
                {}
        ulc += sizeof (RESDATA);
        memcpy (pApps, pc, ulc);            // copy remaining strings + structure
        pApps += ulc;
        pc    += ulc;
        pShMemMouseData->ulcApplications += ulc;
        }

    free (pProfile);

    pShMemMouseData->ulCurrScrollDir = pShMemMouseData->ulStartupMode;
    DosReleaseMutexSem (hmtxWheelThread);

    DosPostEventSem (hevXWPWidgetUpdate);

    return;
    }

BOOL clsInitData (VOID)
    {
    /* Allocate / initialize shared memory */
    if (DosGetNamedSharedMem ((PPVOID)&pShMemMouseData, SHMEMNAME, PAG_READ | PAG_WRITE))
        {
        if (DosAllocSharedMem ((PPVOID)&pShMemMouseData, SHMEMNAME, sizeof (MOUSEDATA), PAG_COMMIT | PAG_WRITE | PAG_READ))
            {
            pShMemMouseData = NULL;                      // Fehler: Anlegen des Shared-Memory nicht mglich
            return FALSE;
            }
        else
            {
            memset (pShMemMouseData, '\0', sizeof (MOUSEDATA));
            }
        }

    /* open/create semaphore for synchronisation of strucMouseData */
    if (!hmtxWheelThread)
        if (DosOpenMutexSem (SEMNAMEMTX, &hmtxWheelThread))
            if (DosCreateMutexSem (SEMNAMEMTX, &hmtxWheelThread, 0L, FALSE))
                return FALSE;

    /* open/create semaphore for thread unblocking */
    if (hmtxWheelThread)
        {
        if (!hevWheelThreadUpdate)
            if (DosOpenEventSem (SEMNAMEEVT_UPDATE, &hevWheelThreadUpdate))
                if (DosCreateEventSem (SEMNAMEEVT_UPDATE, &hevWheelThreadUpdate, DC_SEM_SHARED, TRUE))
                    return FALSE;

        if (!hevXWPWidgetUpdate)
            if (DosOpenEventSem (SEMNAMEEVT_WIDGET, &hevXWPWidgetUpdate))
                if (DosCreateEventSem (SEMNAMEEVT_WIDGET, &hevXWPWidgetUpdate, DC_SEM_SHARED, TRUE))
                    return FALSE;
        }
    else
        return FALSE;

    /* Klassendaten aus INI-Datei lesen */
    queryData ();

    return TRUE;
    }

