/******************************************************/
/** Anonymous ** Tao Te Ching Text Reader ** 7/01/93 **/
/******************************************************/
/**           Works with Turbo C++ v.3.0             **/
/******************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>

int main(int argc, char *argv[])
{
	int place, num, count, chapters, random_flag, pause_flag, screen_lines;
	char numtxt[4], outline[80];
	FILE *infile, *inoutfile;

	if((infile=fopen("tao.txt", "rt"))==NULL)
	{
		printf("Cannot open tao.txt.\n");
		return 1;
	}
	if((inoutfile=fopen("tao.ini", "rt"))==NULL)
	{
		printf("Cannot open tao.ini.\n");
		fclose(infile);
		return 2;
	}
	if(argc==1) /* no arguments */
		/* get chapters, place, random_flag and pause_flag from ini file */
		fscanf(inoutfile, " %d\n %d\n %d\n %d\n %d", &chapters, &place, &random_flag, &pause_flag, &screen_lines);
	else  /* use cmd line arg and check for error */
	{
		fscanf(inoutfile, " %d\n %d\n %d\n %d\n %d", &chapters, &place, &random_flag, &pause_flag, &screen_lines);
		place=atoi(argv[argc-1]);
		random_flag=0;
	}
	if(random_flag)
	{
		randomize();
		place=(rand()%chapters)+1;
	}
	else if(place<1 || place>chapters) place=1;
	if(screen_lines <=0) screen_lines=25;
	fclose(inoutfile); /* closes the read-only version */
	while(fgets(numtxt, 4, infile), num=atoi(numtxt), num != place)
	{
		if(feof(infile))
		{
			printf("Reached end-of-file in tao.txt.\n");
			printf("You have an invalid tao.ini file.\n");
			fclose(infile);
			return 3;
		}
	}
	clrscr();
	printf("------------%d------------\n", place);
	count=0;
	while(fgets(outline, 80, infile), count++, outline[0]!='*')
	{
		printf("%s", outline);
		if(count==(screen_lines-2)) /* allows for >screen_lines line passages */
		{
			getch();
			printf("------------%d------------\n", place);
		}
	}
	if(pause_flag) getch();
	fclose(infile);
	if(random_flag==0 && argc==1)
	{
		place++;
		if(place==chapters+1) place=1;
		if((inoutfile=fopen("tao.ini", "wt"))==NULL) /* opens for write */
		{
			printf("Cannot update tao.ini.\n");
			fclose(infile);
			return 4;
		}
		fprintf(inoutfile, "%d\n%d\n%d\n%d\n%d", chapters, place, random_flag, pause_flag, screen_lines);
		fclose(inoutfile);
	}
	return 0;
}


