/*
 * rtdisk.h
 *
 * RT-11 diskette class.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#ifndef _RTDISK
#define _RTDISK

#include "diskette.h"
#include "rtdefs.h"
// #include "dosdisk.h"
#include "rtfile.h"
#include "dosfile.h"
#include "ercode.h"

enum {closed, open_for_read};
   
class RTdisk : public diskette {

   friend class DOSdisk;

   RTfile srcfile;
   RTfile destfile;
   
   char volid[13];
   char volown[13];
   char volsysid[13];
   
   void RTGetHomeBlock(void);
   // effects: Reads the home block from the diskette and updates the
   // volid, volown, and volsys RTdisk member variables.
   // Must be the initial operation on an RTdisk.
   // Used internally by the object's member functions.
   
   void extract_RTinfo();
   // effects: Gets the file info from the current RTdisk directory entry
   // and puts into respective member variables.
   // Used by RTFindFirst and RTFindNext only (common code).
   
   // Directory segment buffer
   dirblok dblok;
   
   // Wildcard processing state
   int segment;          // Current directory segment number
   int entryno;          // Current entry in directory segment
   RTfile curfile;       // Current file in wildcard processing
   short int status;     // Current file status flags
   short int date;       // Current file date
   short int leng;       // Current file length
   int start_blok;       // Starting block number for current file
   
   // Open file state (the open file is curfile above).
   int open_stat;        // Open status 0 = closed, 1 = open_for_read
   boolean eof_stat;     // EOF status false = not eof, true = eof
   int cur_blok;         // Current absolute block number
   char * blok_buffer;   // Address of current block's buffer
   
   // Directory processing state.
   int filecnt;
   int bloks_used;
   int bloks_free;
   
public:
   RTdisk();
   // effects: Constructs an RTdisk object with default destination.
   
   void print_directory();
   // effects: Prints the directory for the diskette,
   // constrained by srcfile, to cout.
   // If the source file and extension are both '*' a full
   // directory is printed with <Unused> areas included.
   
   void setsrc(char *);
   // effects: Sets the source file specification for this diskette.

   void setdest(char *);
   // effects: Sets the destination file specification for this diskette.

   char getdestdrive();
   // effects: Gets the destination drive.
   // returns: The letter 'A'-'Z' of the destination drive.
   
   ercode RTFindFirst();
   // effects: Sets the current file to the first file name on this
   // diskette which matches the source file specification.
   // returns: Error code NOERROR or FILENOTFOUND.
   
   ercode RTFindNext();
   // assumes: Current file has been set by previous call(s) to
   // RTFindFirst() or RTFindNext().
   // effects: Sets the current file to the next file name on this
   //          diskette which matches the source file specification.
   // returns: Error code NOERROR or FILENOTFOUND.
   
   ercode RTopen(int filmode);
   // effects: Opens the current file with the file mode given.
   // Establishes a buffer.
   // Sets cur_blok to the first block of the file.
   // returns: Error code.
   
   void RTclose();
   // effects: Closes the current open file.
   // Discards the buffer.
   
   ercode RTreads(char **);
   // effects: Checks to see if cur_blok is beyond the end of the file.
   // If so, returns eof error code.
   // Otherwise. Reads the current block from the disk into the buffer
   // and advances cur_blok.
   // returns: Error code, pointer to the buffer.
   
   boolean RTeof();
   // effects: Returns whether not cur_blok is beyond the end of the file.
   
   // ercode copy(RTdisk);
   // effects: Copies the RT11 file(s) from the argument to this diskette.
   // returns: Error code.
   
   // ercode copy(DOSdisk);
   // effects: Copies the DOS file(s) from the argument to this diskette.
   // returns: Error code.
};
#endif
