#ifndef __BOX_H__
 #define __BOX_H__

 /* functions to draw box and to print data in the box */

 #include "screen.h"
 /* lowlevel routines to write directly into the video ram */

 #define  SINGLE_BOX                    1
 #define  DOUBLE_BOX                    2
 #define  SINGLE_DOUBLE                 3
 #define  DOUBLE_SINGLE                 4
 #define  REMAPPED                      5
 #define  SOLID_BOX                     6

/* #define  DARKEN                        0x7800 */
  /* turn off intensity and make background black */

 #define  DEFAULT_TEXT_BACK             LIGHTBLUE
 #define  DEFAULT_TEXT_FORE             WHITE

 #define  REMAPPED_LEFT_TOP             192
 #define  REMAPPED_TOP_HOR              193
 #define  REMAPPED_RIGHT_TOP            194
 #define  REMAPPED_LEFT_VER             195
 #define  REMAPPED_RIGHT_VER            196
 #define  REMAPPED_LEFT_BOTTOM          197
 #define  REMAPPED_BOTTOM_HOR           198
 #define  REMAPPED_RIGHT_BOTTOM         199
 #define  REMAPPED_SEPARATOR            200
 #define  REMAPPED_SQUARE               201
 #define  REMAPPED_VERT_SEPARATOR       202
 #define  REMAPPED_TOP_CONNECTOR        203
 #define  REMAPPED_DOWN_CONNECTOR       204


/*----------------------------------------------------------------------*/
/* bitmap definition for the text fonts */
#ifdef USE_REMAPPING
extern char remapped_text[4096]= "\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x7e\x81\xa5\x81\x81\xbd\x99\x81\x81\x7e\x00\x00\x00\x00\
\x00\x00\x7e\xff\xdb\xff\xff\xc3\xe7\xff\xff\x7e\x00\x00\x00\x00\
\x00\x00\x00\x00\x6c\xfe\xfe\xfe\xfe\x7c\x38\x10\x00\x00\x00\x00\
\x00\x00\x00\x00\x10\x38\x7c\xfe\x7c\x38\x10\x00\x00\x00\x00\x00\
\x00\x00\x00\x18\x3c\x3c\xe7\xe7\xe7\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\x00\x18\x3c\x7e\xff\xff\x7e\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x18\x3c\x3c\x18\x00\x00\x00\x00\x00\x00\
\xff\xff\xff\xff\xff\xff\xe7\xc3\xc3\xe7\xff\xff\xff\xff\xff\xff\
\x00\x00\x00\x00\x00\x3c\x66\x42\x42\x66\x3c\x00\x00\x00\x00\x00\
\xff\xff\xff\xff\xff\xc3\x99\xbd\xbd\x99\xc3\xff\xff\xff\xff\xff\
\x00\x00\x1e\x0e\x1a\x32\x78\xcc\xcc\xcc\xcc\x78\x00\x00\x00\x00\
\x00\x00\x3c\x66\x66\x66\x66\x3c\x18\x7e\x18\x18\x00\x00\x00\x00\
\x00\x00\x3f\x33\x3f\x30\x30\x30\x30\x70\xf0\xe0\x00\x00\x00\x00\
\x00\x00\x7f\x63\x7f\x63\x63\x63\x63\x67\xe7\xe6\xc0\x00\x00\x00\
\x00\x00\x00\x18\x18\xdb\x3c\xe7\x3c\xdb\x18\x18\x00\x00\x00\x00\
\x00\x80\xc0\xe0\xf0\xf8\xfe\xf8\xf0\xe0\xc0\x80\x00\x00\x00\x00\
\x00\x02\x06\x0e\x1e\x3e\xfe\x3e\x1e\x0e\x06\x02\x00\x00\x00\x00\
\x00\x00\x18\x3c\x7e\x18\x18\x18\x7e\x3c\x18\x00\x00\x00\x00\x00\
\x00\x00\x66\x66\x66\x66\x66\x66\x66\x00\x66\x66\x00\x00\x00\x00\
\x00\x00\x7f\xdb\xdb\xdb\x7b\x1b\x1b\x1b\x1b\x1b\x00\x00\x00\x00\
\x00\x7c\xc6\x60\x38\x6c\xc6\xc6\x6c\x38\x0c\xc6\x7c\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\xfe\xfe\xfe\xfe\x00\x00\x00\x00\
\x00\x00\x18\x3c\x7e\x18\x18\x18\x7e\x3c\x18\x7e\x00\x00\x00\x00\
\x00\x00\x18\x3c\x7e\x18\x18\x18\x18\x18\x18\x18\x00\x00\x00\x00\
\x00\x00\x18\x18\x18\x18\x18\x18\x18\x7e\x3c\x18\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x18\x0c\xfe\x0c\x18\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x30\x60\xfe\x60\x30\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\xc0\xc0\xc0\xfe\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x24\x66\xff\x66\x24\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x10\x38\x38\x7c\x7c\xfe\xfe\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\xfe\xfe\x7c\x7c\x38\x38\x10\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x18\x3c\x3c\x3c\x18\x18\x18\x00\x18\x18\x00\x00\x00\x00\
\x00\x66\x66\x66\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x6c\x6c\xfe\x6c\x6c\x6c\xfe\x6c\x6c\x00\x00\x00\x00\
\x18\x18\x7c\xc6\xc2\xc0\x7c\x06\x06\x86\xc6\x7c\x18\x18\x00\x00\
\x00\x00\x00\x00\xc2\xc6\x0c\x18\x30\x60\xc6\x86\x00\x00\x00\x00\
\x00\x00\x38\x6c\x6c\x38\x76\xdc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x30\x30\x30\x60\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x0c\x18\x30\x30\x30\x30\x30\x30\x18\x0c\x00\x00\x00\x00\
\x00\x00\x30\x18\x0c\x0c\x0c\x0c\x0c\x0c\x18\x30\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x66\x3c\xff\x3c\x66\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x18\x18\x7e\x18\x18\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x18\x18\x30\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x18\x00\x00\x00\x00\
\x00\x00\x00\x00\x02\x06\x0c\x18\x30\x60\xc0\x80\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xce\xde\xf6\xe6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x18\x38\x78\x18\x18\x18\x18\x18\x18\x7e\x00\x00\x00\x00\
\x00\x00\x7c\xc6\x06\x0c\x18\x30\x60\xc0\xc6\xfe\x00\x00\x00\x00\
\x00\x00\x7c\xc6\x06\x06\x3c\x06\x06\x06\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x0c\x1c\x3c\x6c\xcc\xfe\x0c\x0c\x0c\x1e\x00\x00\x00\x00\
\x00\x00\xfe\xc0\xc0\xc0\xfc\x06\x06\x06\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x38\x60\xc0\xc0\xfc\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xfe\xc6\x06\x06\x0c\x18\x30\x30\x30\x30\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xc6\x7c\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xc6\x7e\x06\x06\x06\x0c\x78\x00\x00\x00\x00\
\x00\x00\x00\x00\x18\x18\x00\x00\x00\x18\x18\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x18\x18\x00\x00\x00\x18\x18\x30\x00\x00\x00\x00\
\x00\x00\x00\x06\x0c\x18\x30\x60\x30\x18\x0c\x06\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7e\x00\x00\x7e\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x60\x30\x18\x0c\x06\x0c\x18\x30\x60\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\x0c\x18\x18\x18\x00\x18\x18\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xc6\xde\xde\xde\xdc\xc0\x7c\x00\x00\x00\x00\
\x00\x00\x10\x38\x6c\xc6\xc6\xfe\xc6\xc6\xc6\xc6\x00\x00\x00\x00\
\x00\x00\xfc\x66\x66\x66\x7c\x66\x66\x66\x66\xfc\x00\x00\x00\x00\
\x00\x00\x3c\x66\xc2\xc0\xc0\xc0\xc0\xc2\x66\x3c\x00\x00\x00\x00\
\x00\x00\xf8\x6c\x66\x66\x66\x66\x66\x66\x6c\xf8\x00\x00\x00\x00\
\x00\x00\xfe\x66\x62\x68\x78\x68\x60\x62\x66\xfe\x00\x00\x00\x00\
\x00\x00\xfe\x66\x62\x68\x78\x68\x60\x60\x60\xf0\x00\x00\x00\x00\
\x00\x00\x3c\x66\xc2\xc0\xc0\xde\xc6\xc6\x66\x3a\x00\x00\x00\x00\
\x00\x00\xc6\xc6\xc6\xc6\xfe\xc6\xc6\xc6\xc6\xc6\x00\x00\x00\x00\
\x00\x00\x3c\x18\x18\x18\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\x1e\x0c\x0c\x0c\x0c\x0c\xcc\xcc\xcc\x78\x00\x00\x00\x00\
\x00\x00\xe6\x66\x66\x6c\x78\x78\x6c\x66\x66\xe6\x00\x00\x00\x00\
\x00\x00\xf0\x60\x60\x60\x60\x60\x60\x62\x66\xfe\x00\x00\x00\x00\
\x00\x00\xc3\xe7\xff\xff\xdb\xc3\xc3\xc3\xc3\xc3\x00\x00\x00\x00\
\x00\x00\xc6\xe6\xf6\xfe\xde\xce\xc6\xc6\xc6\xc6\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xfc\x66\x66\x66\x7c\x60\x60\x60\x60\xf0\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\xc6\xc6\xc6\xc6\xd6\xde\x7c\x0c\x0e\x00\x00\
\x00\x00\xfc\x66\x66\x66\x7c\x6c\x66\x66\x66\xe6\x00\x00\x00\x00\
\x00\x00\x7c\xc6\xc6\x60\x38\x0c\x06\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xff\xdb\x99\x18\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xc3\xc3\xc3\xc3\xc3\xc3\xc3\x66\x3c\x18\x00\x00\x00\x00\
\x00\x00\xc3\xc3\xc3\xc3\xc3\xdb\xdb\xff\x66\x66\x00\x00\x00\x00\
\x00\x00\xc3\xc3\x66\x3c\x18\x18\x3c\x66\xc3\xc3\x00\x00\x00\x00\
\x00\x00\xc3\xc3\xc3\x66\x3c\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\xff\xc3\x86\x0c\x18\x30\x60\xc1\xc3\xff\x00\x00\x00\x00\
\x00\x00\x3c\x30\x30\x30\x30\x30\x30\x30\x30\x3c\x00\x00\x00\x00\
\x00\x00\x00\x80\xc0\xe0\x70\x38\x1c\x0e\x06\x02\x00\x00\x00\x00\
\x00\x00\x3c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x0c\x3c\x00\x00\x00\x00\
\x10\x38\x6c\xc6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x00\x00\
\x30\x30\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\xe0\x60\x60\x78\x6c\x66\x66\x66\x66\x7c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7c\xc6\xc0\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x1c\x0c\x0c\x3c\x6c\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7c\xc6\xfe\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x38\x6c\x64\x60\xf0\x60\x60\x60\x60\xf0\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x76\xcc\xcc\xcc\xcc\xcc\x7c\x0c\xcc\x78\x00\
\x00\x00\xe0\x60\x60\x6c\x76\x66\x66\x66\x66\xe6\x00\x00\x00\x00\
\x00\x00\x18\x18\x00\x38\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\x06\x06\x00\x0e\x06\x06\x06\x06\x06\x06\x66\x66\x3c\x00\
\x00\x00\xe0\x60\x60\x66\x6c\x78\x78\x6c\x66\xe6\x00\x00\x00\x00\
\x00\x00\x38\x18\x18\x18\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xe6\xff\xdb\xdb\xdb\xdb\xdb\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xdc\x66\x66\x66\x66\x66\x66\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7c\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xdc\x66\x66\x66\x66\x66\x7c\x60\x60\xf0\x00\
\x00\x00\x00\x00\x00\x76\xcc\xcc\xcc\xcc\xcc\x7c\x0c\x0c\x1e\x00\
\x00\x00\x00\x00\x00\xdc\x76\x66\x60\x60\x60\xf0\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7c\xc6\x60\x38\x0c\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x10\x30\x30\xfc\x30\x30\x30\x30\x36\x1c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xcc\xcc\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xc3\xc3\xc3\xc3\x66\x3c\x18\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xc3\xc3\xc3\xdb\xdb\xff\x66\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xc3\x66\x3c\x18\x3c\x66\xc3\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xc6\xc6\xc6\xc6\xc6\xc6\x7e\x06\x0c\xf8\x00\
\x00\x00\x00\x00\x00\xfe\xcc\x18\x30\x60\xc6\xfe\x00\x00\x00\x00\
\x00\x00\x0e\x18\x18\x18\x70\x18\x18\x18\x18\x0e\x00\x00\x00\x00\
\x00\x00\x18\x18\x18\x18\x00\x18\x18\x18\x18\x18\x00\x00\x00\x00\
\x00\x00\x70\x18\x18\x18\x0e\x18\x18\x18\x18\x70\x00\x00\x00\x00\
\x00\x00\x76\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x10\x38\x6c\xc6\xc6\xc6\xfe\x00\x00\x00\x00\x00\
\x00\x00\x3c\x66\xc2\xc0\xc0\xc0\xc2\x66\x3c\x0c\x06\x7c\x00\x00\
\x00\x00\xcc\x00\x00\xcc\xcc\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x0c\x18\x30\x00\x7c\xc6\xfe\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x10\x38\x6c\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\xcc\x00\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x60\x30\x18\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x38\x6c\x38\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\x00\x00\x3c\x66\x60\x60\x66\x3c\x0c\x06\x3c\x00\x00\x00\
\x00\x10\x38\x6c\x00\x7c\xc6\xfe\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xc6\x00\x00\x7c\xc6\xfe\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x60\x30\x18\x00\x7c\xc6\xfe\xc0\xc0\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x66\x00\x00\x38\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x18\x3c\x66\x00\x38\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x60\x30\x18\x00\x38\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\xc6\x00\x10\x38\x6c\xc6\xc6\xfe\xc6\xc6\xc6\x00\x00\x00\x00\
\x38\x6c\x38\x00\x38\x6c\xc6\xc6\xfe\xc6\xc6\xc6\x00\x00\x00\x00\
\x18\x30\x60\x00\xfe\x66\x60\x7c\x60\x60\x66\xfe\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x6e\x3b\x1b\x7e\xd8\xdc\x77\x00\x00\x00\x00\
\x00\x00\x3e\x6c\xcc\xcc\xfe\xcc\xcc\xcc\xcc\xce\x00\x00\x00\x00\
\x00\x10\x38\x6c\x00\x7c\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\xc6\x00\x00\x7c\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x60\x30\x18\x00\x7c\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x30\x78\xcc\x00\xcc\xcc\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x60\x30\x18\x00\xcc\xcc\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\xc6\x00\x00\xc6\xc6\xc6\xc6\xc6\xc6\x7e\x06\x0c\x78\x00\
\x00\xc6\x00\x7c\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\xc6\x00\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x18\x18\x7e\xc3\xc0\xc0\xc0\xc3\x7e\x18\x18\x00\x00\x00\x00\
\x00\x38\x6c\x64\x60\xf0\x60\x60\x60\x60\xe6\xfc\x00\x00\x00\x00\
\x00\x00\xc3\x66\x3c\x18\xff\x18\xff\x18\x18\x18\x00\x00\x00\x00\
\x00\xfc\x66\x66\x7c\x62\x66\x6f\x66\x66\x66\xf3\x00\x00\x00\x00\
\x00\x0e\x1b\x18\x18\x18\x7e\x18\x18\x18\x18\x18\xd8\x70\x00\x00\
\x00\x18\x30\x60\x00\x78\x0c\x7c\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x0c\x18\x30\x00\x38\x18\x18\x18\x18\x18\x3c\x00\x00\x00\x00\
\x00\x18\x30\x60\x00\x7c\xc6\xc6\xc6\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x18\x30\x60\x00\xcc\xcc\xcc\xcc\xcc\xcc\x76\x00\x00\x00\x00\
\x00\x00\x76\xdc\x00\xdc\x66\x66\x66\x66\x66\x66\x00\x00\x00\x00\
\x76\xdc\x00\xc6\xe6\xf6\xfe\xde\xce\xc6\xc6\xc6\x00\x00\x00\x00\
\x00\x3c\x6c\x6c\x3e\x00\x7e\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x38\x6c\x6c\x38\x00\x7c\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x30\x30\x00\x30\x30\x60\xc0\xc6\xc6\x7c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\xfe\xc0\xc0\xc0\xc0\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\xfe\x06\x06\x06\x06\x00\x00\x00\x00\x00\
\x00\xc0\xc0\xc2\xc6\xcc\x18\x30\x60\xce\x9b\x06\x0c\x1f\x00\x00\
\x00\xc0\xc0\xc2\xc6\xcc\x18\x30\x66\xce\x96\x3e\x06\x06\x00\x00\
\x00\x00\x18\x18\x00\x18\x18\x18\x3c\x3c\x3c\x18\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x36\x6c\xd8\x6c\x36\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xd8\x6c\x36\x6c\xd8\x00\x00\x00\x00\x00\x00\
\x11\x44\x11\x44\x11\x44\x11\x44\x11\x44\x11\x44\x11\x44\x11\x44\
\x55\xaa\x55\xaa\x55\xaa\x55\xaa\x55\xaa\x55\xaa\x55\xaa\x55\xaa\
\xdd\x77\xdd\x77\xdd\x77\xdd\x77\xdd\x77\xdd\x77\xdd\x77\xdd\x77\
\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x18\x18\xf8\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\xf8\x18\xf8\x18\x18\x18\x18\x18\x18\x18\x18\
\x36\x36\x36\x36\x36\x36\x36\xf6\x36\x36\x36\x36\x36\x36\x36\x36\
\x00\x00\x00\x00\x00\x00\x00\xfe\x36\x36\x36\x36\x36\x36\x36\x36\
\x00\x00\x00\x00\x00\xf8\x18\xf8\x18\x18\x18\x18\x18\x18\x18\x18\
\x36\x36\x36\x36\x36\xf6\x06\xf6\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\x36\
\x00\x00\x00\x00\x00\xfe\x06\xf6\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\xf6\x06\xfe\x00\x00\x00\x00\x00\x00\x00\x00\
\x36\x36\x36\x36\x36\x36\x36\xfe\x00\x00\x00\x00\x00\x00\x00\x00\
\x18\x18\x18\x18\x18\xf8\x18\xf8\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\xf8\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x18\x18\x1f\x00\x00\x00\x00\x00\x00\x00\x00\
\x18\x18\x18\x18\x18\x18\x18\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\xff\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x18\x18\x1f\x18\x18\x18\x18\x18\x18\x18\x18\
\x00\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x18\x18\x18\x18\x18\x18\x18\xff\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x1f\x18\x1f\x18\x18\x18\x18\x18\x18\x18\x18\
\x36\x36\x36\x36\x36\x36\x36\x37\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\x37\x30\x3f\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x3f\x30\x37\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\xf7\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xff\x00\xf7\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\x37\x30\x37\x36\x36\x36\x36\x36\x36\x36\x36\
\x00\x00\x00\x00\x00\xff\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x36\x36\x36\x36\x36\xf7\x00\xf7\x36\x36\x36\x36\x36\x36\x36\x36\
\x18\x18\x18\x18\x18\xff\x00\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x36\x36\x36\x36\x36\x36\x36\xff\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\xff\x00\xff\x18\x18\x18\x18\x18\x18\x18\x18\
\x00\x00\x00\x00\x00\x00\x00\xff\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\x36\x36\x3f\x00\x00\x00\x00\x00\x00\x00\x00\
\x18\x18\x18\x18\x18\x1f\x18\x1f\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x1f\x18\x1f\x18\x18\x18\x18\x18\x18\x18\x18\
\x00\x00\x00\x00\x00\x00\x00\x3f\x36\x36\x36\x36\x36\x36\x36\x36\
\x36\x36\x36\x36\x36\x36\x36\xff\x36\x36\x36\x36\x36\x36\x36\x36\
\x18\x18\x18\x18\x18\xff\x18\xff\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x18\x18\xf8\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x1f\x18\x18\x18\x18\x18\x18\x18\x18\
\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\
\x00\x00\x00\x00\x00\x00\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\
\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\xf0\
\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\x0f\
\xff\xff\xff\xff\xff\xff\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x76\xdc\xd8\xd8\xd8\xdc\x76\x00\x00\x00\x00\
\x00\x00\x78\xcc\xcc\xcc\xd8\xcc\xc6\xc6\xc6\xcc\x00\x00\x00\x00\
\x00\x00\xfe\xc6\xc6\xc0\xc0\xc0\xc0\xc0\xc0\xc0\x00\x00\x00\x00\
\x00\x00\x00\x00\xfe\x6c\x6c\x6c\x6c\x6c\x6c\x6c\x00\x00\x00\x00\
\x00\x00\x00\xfe\xc6\x60\x30\x18\x30\x60\xc6\xfe\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7e\xd8\xd8\xd8\xd8\xd8\x70\x00\x00\x00\x00\
\x00\x00\x00\x00\x66\x66\x66\x66\x66\x7c\x60\x60\xc0\x00\x00\x00\
\x00\x00\x00\x00\x76\xdc\x18\x18\x18\x18\x18\x18\x00\x00\x00\x00\
\x00\x00\x00\x7e\x18\x3c\x66\x66\x66\x3c\x18\x7e\x00\x00\x00\x00\
\x00\x00\x00\x38\x6c\xc6\xc6\xfe\xc6\xc6\x6c\x38\x00\x00\x00\x00\
\x00\x00\x38\x6c\xc6\xc6\xc6\x6c\x6c\x6c\x6c\xee\x00\x00\x00\x00\
\x00\x00\x1e\x30\x18\x0c\x3e\x66\x66\x66\x66\x3c\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x7e\xdb\xdb\xdb\x7e\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x03\x06\x7e\xdb\xdb\xf3\x7e\x60\xc0\x00\x00\x00\x00\
\x00\x00\x1c\x30\x60\x60\x7c\x60\x60\x60\x30\x1c\x00\x00\x00\x00\
\x00\x00\x00\x7c\xc6\xc6\xc6\xc6\xc6\xc6\xc6\xc6\x00\x00\x00\x00\
\x00\x00\x00\x00\xfe\x00\x00\xfe\x00\x00\xfe\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x18\x18\x7e\x18\x18\x00\x00\xff\x00\x00\x00\x00\
\x00\x00\x00\x30\x18\x0c\x06\x0c\x18\x30\x00\x7e\x00\x00\x00\x00\
\x00\x00\x00\x0c\x18\x30\x60\x30\x18\x0c\x00\x7e\x00\x00\x00\x00\
\x00\x00\x0e\x1b\x1b\x1b\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\
\x18\x18\x18\x18\x18\x18\x18\x18\xd8\xd8\xd8\x70\x00\x00\x00\x00\
\x00\x00\x00\x00\x18\x18\x00\x7e\x00\x18\x18\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x76\xdc\x00\x76\xdc\x00\x00\x00\x00\x00\x00\
\x00\x38\x6c\x6c\x38\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x18\x18\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\
\x00\x0f\x0c\x0c\x0c\x0c\x0c\xec\x6c\x6c\x3c\x1c\x00\x00\x00\x00\
\x00\xd8\x6c\x6c\x6c\x6c\x6c\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x70\xd8\x30\x60\xc8\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x7c\x7c\x7c\x7c\x7c\x7c\x7c\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\
";
#endif
/*----------------------------------------------------------------------*/
 void RemapTheCharacters(char *buf)
 {
   int i,k;

   k = REMAPPED_LEFT_TOP;                  /* left top  192 */
   buf[k*16] = 0xff;
   for(i=1; i<16 ; i++)
     buf[k*16+i] = 0x80;

   k = REMAPPED_TOP_HOR;                    /* top horizontal  193 */
   buf[k*16] =  0xff;
   for(i=1; i<16 ; i++)
     buf[k*16+i] = 0;

   k = REMAPPED_RIGHT_TOP;                    /* rtop  194 */
   buf[k*16] =  0xff;
   for(i=1; i<16 ; i++)
     buf[k*16+i] = 1;

   k = REMAPPED_LEFT_VER;                    /* left vertical 195 */
   for(i=0; i<16 ; i++)
    buf[k*16+i] = 0x80;

   k = REMAPPED_RIGHT_VER;                    /* right vertical 196 */
   for(i=0; i<16 ; i++)
    buf[k*16+i] = 1;

   k = REMAPPED_LEFT_BOTTOM;                    /* left bottom 197 */
   for(i=0; i<15 ; i++)
     buf[k*16+i] = 0x80;
   buf[k*16+15] = 0xff;

   k = REMAPPED_BOTTOM_HOR;                    /* bottom horizontal 198 */
   for(i=0; i<15 ; i++)
     buf[k*16+i] = 0;
   buf[k*16+15] = 0xff;

   k = REMAPPED_RIGHT_BOTTOM;                    /* right bottom 199 */
   for(i=0; i<15 ; i++)
     buf[k*16+i] = 1;
   buf[k*16+i] = 0xff;

   k = REMAPPED_SEPARATOR;                 /* horizontal separator 200 */
   for(i=0; i<7 ; i++)
     buf[k*16+i] = 0;
   buf[k*16+i] = 0xff;
   for(i++; i<16 ; i++)
     buf[k*16+i] = 0;

   k = REMAPPED_SQUARE;                 /* a small square 201 */
   for(i=0; i<13; i++)
     buf[k*16+i] = 0xff;
   for( ; i<16; i++)
     buf[k*16+i] = 0;

   k = REMAPPED_VERT_SEPARATOR;            /* vertical separator 202 */
   buf[k*16]=0xff;
   for(i=0; i<16; i++)
     buf[k*16+i] = 0x10;

   k = REMAPPED_TOP_CONNECTOR;     /* connects two boxes on top 203 */
   buf[k*16]=0xff;
   for(i=1; i<16; i++)
     buf[k*16+i] = 0x10;

   k = REMAPPED_DOWN_CONNECTOR;    /* connects two boxes on bottom 204 */
   for(i=0; i<15; i++)
     buf[k*16+i] = 0x10;
   buf[k*16+i]=0xff;
 }
/*----------------------------------------------------------------------*/
 int RemapCharacter(void)
 {
   /* remap characters to draw Norton Style Box
      The characters then used are defined above
   */
   #ifdef USE_REMAPPING
    struct REGPACK r;
    void LowLevelRemap(char *);  /* prototype declaration */

    RemapTheCharacters(remapped_text);
   /* i had to introduce inline assemble because int 10h was buggy with
      Turbo C 1.5.
      But i am not able to compile this !!
      hence ......

    unsigned off,segg;

    off  = FP_OFF(remapped_text);
    segg = FP_SEG(remapped_text);

     asm mov ax,4352        ;
     asm mov bx,0           ;
     asm mov bx, 4096       ;
     asm mov cx, 256        ;
     asm mov dx, 0          ;
     asm push es
     asm push bp
     asm mov es, segg       ;
     asm mov bp, off        ;
     asm int 16
     asm pop bp
     asm pop es

   */

   LowLevelRemap(remapped_text);
   /*
     r.r_ax = 0x1100;
     r.r_bx = 0;
     r.r_bx = 16<<8;
     r.r_cx = 256;
     r.r_dx = 0;
     r.r_es = FP_SEG(remapped_text);
     r.r_bp = FP_OFF(remapped_text);
     intr(0x10,&r);
   */
   #endif
   return 1;
 }
/*----------------------------------------------------------------------*/
 void Restore8x16Font(void)		/* Restore default font		*/
 {
   struct REGPACK r;
    r.r_ax = 0x1104;
    r.r_bx = 0;
    intr(0x10,&r);
 }
/*----------------------------------------------------------------------*/
 SetCharactersForBox(box *b, int type)
 {
   switch(type)
   {
     case   SINGLE_BOX      :  b->top_hor=196,
                               b->left_ver =179,
                               b->ltop=218,
                               b->right_ver=179,
                               b->bottom_hor=196,
                               b->rtop=191,
                               b->lbot=192,
                               b->rbot=217;
                               break;
     case   DOUBLE_SINGLE   :  b->top_hor=205,
                               b->left_ver=179,
                               b->ltop=213,
                               b->right_ver=179,
                               b->bottom_hor=205,
                               b->rtop=184,
                               b->lbot=212,
                               b->rbot=190;
                               break;
     case   SINGLE_DOUBLE   :  b->top_hor=196,
                               b->left_ver=186,
                               b->ltop=214,
                               b->right_ver=186,
                               b->bottom_hor=196,
                               b->rtop=183,
                               b->lbot=211,
                               b->rbot=189;
                               break;
     case REMAPPED          :  b->top_hor    = REMAPPED_TOP_HOR;
                               b->left_ver   = REMAPPED_LEFT_VER;
                               b->ltop       = REMAPPED_LEFT_TOP;
                               b->right_ver  = REMAPPED_RIGHT_VER;
                               b->bottom_hor = REMAPPED_BOTTOM_HOR;
                               b->rtop       = REMAPPED_RIGHT_TOP;
                               b->lbot       = REMAPPED_LEFT_BOTTOM;
                               b->rbot       = REMAPPED_RIGHT_BOTTOM;
                               break;
     case SOLID_BOX         :  b->top_hor    = 223;
                               b->left_ver   = 219;
                               b->ltop       = 219;
                               b->right_ver  = 219;
                               b->bottom_hor = 220;
                               b->rtop       = 219;
                               b->lbot       = 219;
                               b->rbot       = 219;
                               break;
     default                :  b->top_hor=205,
                               b->left_ver=186,
                               b->ltop=201,
                               b->right_ver=186,
                               b->bottom_hor=205,
                               b->rtop=187,
                               b->lbot=200,
                               b->rbot=188;
                               break;
   }
   return 1;
 }

/*----------------------------------------------------------------------*/
 int SetBoxTopLine(box b,unsigned char *s)
 {
   int i;

    s[0] = b.ltop;
    for(i=1; i<b.width-1 ; i++)
     s[i] = b.top_hor;
    s[i++] = b.rtop;
    s[i] = 0;
    return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxBottomLine(box b,unsigned char *s)
 {
   int i;

    s[0] = b.lbot;
    for(i=1; i<b.width-1 ; i++)
     s[i] = b.bottom_hor;
    s[i++] = b.rbot;
    s[i] = 0;
    return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxHorizontalLine(box b,unsigned char *s)
 {
   int i;

    s[0] = b.left_ver;
    for(i=1; i<b.width-1 ; i++)
     s[i] = ' ';
    s[i++] = b.right_ver;
    s[i] = 0;
    return 1;
 }
/*----------------------------------------------------------------------*/
 void DrawBoxShadow(box b)
 {
  int x,y;
  int num;
  unsigned val;

   x = b.x+b.width-1;
   y = b.y;
   num = b.height+1;
   for (  ; (num--) && (x<80); y++)
   {
     val = *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x));
     *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x)) = val & 0x07ff;
     /* reset the background bit */
     val = *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x+1));
     *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x+1)) = val & 0x07ff;
     /* reset the background bit */
   }
   x = b.x;
   y = b.y+b.height;
   num = b.width;
   for ( x++; (num--) && (x<80); x++)
   {
     val = *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x));
     *(VIDEO[PAGE]+(y*SCREEN_WIDTH +x)) = val & 0x07ff;
     /* reset the background bit */
   }
 }
/*----------------------------------------------------------------------*/
 int DrawBox(box b)
 {
  unsigned char str[81];
  int i;

   if(b.x<1 || b.y<1 || b.height<1 || b.width<1) return 0;
   if(b.x>SCREEN_WIDTH || b.y>SCREEN_HEIGHT) return 0;
   if((b.width - b.x)>SCREEN_WIDTH || (b.height - b.y)>SCREEN_HEIGHT)
     return 0;
   SetBoxTopLine(b,str);    /* set the top most line */
   WriteToScreen(b.x,b.y,str,b.attr);   /* and print it */

   SetBoxHorizontalLine(b,str);     /* set horizontal line */
   for(i=0; i<(b.height-1) ;i++)
    WriteToScreen(b.x,b.y+i+1,str,b.attr);

   SetBoxBottomLine(b,str);                     /* set bottom most line */
   WriteToScreen(b.x,b.height+b.y,str,b.attr);   /* print it */
   DrawBoxShadow(b);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxCoords(box *b,int x,int y,int width,int height)
 {
   b->x        =   x;
   b->y        =   y;
   b->width    =   width;
   b->height   =   height;
   return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxAttr(box *b,int fore, int back)
 {
   /* set the box attributes */
   b->attr = ((back<<4) + fore)<<8;
   return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxAnotherAttr(box *b,int fore, int back)
 {
   /* set the 'another_attr'  attribute */
   b->another_attr = ((back<<4) + fore)<<8;
   return 1;
 }
/*----------------------------------------------------------------------*/
 int SetBoxType(box *b,int type)
 {
   SetCharactersForBox(b,type);
   b->type = type;
   return type;
 }
/*----------------------------------------------------------------------*/
 void SetBoxTextAttr(box *b,int fore,int back)
 {
   /* set the box attributes */
   b->text_attr = ((back<<4)+fore)<<8;
 }
/*----------------------------------------------------------------------*/
 void SetBoxHighlightAttr(box *b,int fore,int back)
 {
   /* set the box attributes */
   b->highlight = ((back<<4)+fore)<<8;
 }
/*----------------------------------------------------------------------*/
 void SetBoxNormalAttr(box *b,int fore,int back)
 {
   /* set the box attributes */
   b->normal = ((back<<4)+fore)<<8;
 }
/*----------------------------------------------------------------------*/
 int InitBox(box *b,int x,int y,int width,int height,int type,
                 int fore,int back)
 {
   SetBoxCoords(b,x,y,width, height);
   SetBoxAttr(b,fore,back);
   SetBoxType(b,type);
   SetBoxTextAttr(b,LIGHTGRAY,back);
   SetBoxHighlightAttr(b,BLACK,WHITE);
   SetBoxNormalAttr(b,BLACK,LIGHTGRAY);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int StringInBox(box b,int x,int y,unsigned char *s)
 {
   if(x<0 || y<0) return 0;
   if(y>=b.height || x>=b.width) return 0;
   PrintToScreen(b.x+x,b.y+y,s,b.text_attr,b.width-1);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int BlankStringInBox(box b,int x,int y,int num,unsigned attr)
 {
   if(x<0 || y<0) return 0;
   if(y>=b.height || x>=b.width) return 0;
   PrintToScreenN(b.x+x,b.y+y,' ',attr,num);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int StringAndBlankInBox(box b,int x,int y,unsigned char *s)
 {
   int len=strlen((char *)s);
   if(x<0 || y<0) return 0;
   if(y>=b.height || x>=b.width) return 0;
   PrintToScreen(b.x+x,b.y+y,s,b.text_attr,b.width-2);
   BlankStringInBox(b,x+strlen((char *)s),y,b.width-len-1-x,
                                     b.text_attr);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int HighlightAndBlankInBox(box b,int x,int y,unsigned char *s,unsigned attr)
 {
   if(x<0 || y<0) return 0;
   if(y>=b.height || x>=b.width) return 0;
   PrintToScreen(b.x+x,b.y+y,s,attr,b.width-2);
   BlankStringInBox(b,x+strlen((char *)s),y,b.width-strlen((char *)s)-1-x
   ,attr);
   return 1;
 }
/*----------------------------------------------------------------------*/
 int SetSeparatorChar(char *s,int x,int num)
 {
   /* fill the string s with the separator character
      In the remapped mode this the char is given by 'REMAPPED_SEPARATOR'
      otherwise it is the symbol '-'
   */
   memset(s,x==REMAPPED ? REMAPPED_SEPARATOR : '-',num);
    /* fill the string with separator character */
   return 1;
 }
/*----------------------------------------------------------------------*/
#endif