C       THIS EFFICIENCY PROGRAM WAS OBTAINED FROM
C       ROBERT CECIL AND BRYON ANDERSON
C          KENT STATE UNIVERSITY, KENT, OHIO
C          THE ORIGINAL NAME - NEUTNEWTST (PHYX30RC29/PHDHOPE)
C
C    HISTORY: (PORTING BY ALAN R. BALDWIN)
C
C    1980   PROGRAM WAS MODIFIED TO RUN ON ANY
C           PDP-11/LSI-11 PROCESSOR SUPPORTING VIRTUAL ARRAYS.
C           (FORTRAN 4 AND FORTRAN 77 UNDER RT-11)
C
C    1984   PROGRAM PORTED TO VAX VMS SYSTEM
C
C    2011   PROGRAM PORTED TO OPEN WATCOM F77
C
C
C---------------------------------------------------------------------
C
C     MONTE CARLO NEUTRON COUNTER EFFICIENCY PROGRAM
C     MAIN ROUTINE
C      IN THIS ROUTINE WE READ IN ALL INPUT DATA  NECESSARY TO
C      CALCULATE A NEUTRON EFFICIENCY FOR A PARTICULAR
C      SCINTILLATOR GEOMETRY
C
C      WE THEN CALL FOLNUT TO PROPAGATE A NEUTRON THROUGH THE
C      SCINT AND PRODUCE THE LIGHT DEPOSITED BY ANY CHARGED
C      PARTICLES PRODUCED IN THE PROPAGATION PROCESS
C
C      THE MAIN ROUTINE THEN BINS THE LIGHT OUTPUT OF FOLNUT
C      AS REQUESTED BY INPUT PARAMETERS PREVIOUSELY READ
C
C -------------------------------------------------------------------
C
C    FOR BACKGROUND INFORMATION ABOUT THE 'CODE' AND THE
C    ACCURACY OF THE MONTE CARLO CALCULATIONS REFER TO
C    THE FOLLOWING PAPER:
C
C       IMPROVED PREDICTIONS OF NEUTRON DETECTION EFFICIENCY
C       FOR HYDROCARBON SCINTILLATORS FROM 1 MeV TO ABOUT 300 MeV
C
C         NUCLEAR INSTRUMENTS AND METHODS 161 (1979) 439-447
C
C         R. A. CECIL, B. D. ANDERSON and R. MADEY
C           Department of Physics
C           Kent State University
C           Kent, Ohio 44242, U.S.A.
C
C -------------------------------------------------------------------
C
C    NOTES:
C       THE EQUIVALENT RECOIL ELECTRON ENERGY FOR PROTONS
C       AND ALPHA PARTICLES IS PARAMETERIZED AS
C
C          Te = A * (1.-EXP(B * Tx**C)) + D * Tx   (x = p or a)
C
C       WHERE THE PARAMETERIZATION VALUES A,B,C, AND D
C       ARE TAKEN FROM THE ABOVE REFERENCE:
C
C       PARTICLE AND                          COEFFICIENT
C       SCINTILLATOR                  A        B         C        D
C       ------------                -----    ------    -----    -----
C       P, NE-102                   -8.0     -0.1       0.90     0.95
C       P, NE-213                   -2.82    -0.25      0.93     0.83
C       P, NE-224                   -8.2     -0.1       0.88     1.0
C       P, NE-228, NE-228A          -8.4     -0.1       0.90     0.95
C       ALPHA, ALL SCINTILLATORS    -5.9     -0.065     1.01     0.41
C
C       THE SPECIFIC VALUES ARE INCLUDED IN THE INPUT DATA FILE
C       ACCORDING TO THE DETECTOR TYPE REQUIRED.
C
C -------------------------------------------------------------------
C
C    NOTES:
C       THE SCINTILLATOR DENSITY AND HYDROGEN CARBON RATIO IS
C       ALSO REQUIRED FOR PROPER CALCULATION.
C
C       SCINTILLATOR       DENSITY (g/cm3)      H/C RATIO
C       ------------       ---------------      ---------
C       NE-102                  1.032             1.104
C       NE-213                  0.874             1.213
C       NE-224                  0.877             1.33
C       NE-228, NE-228A         0.735             2.11
C
C -------------------------------------------------------------------
C
      DIMENSION X(3),C(3),EL(9),XI(3),CI(3),COMMNT(19)
      DIMENSION LCON(9),LHI(9),ELOPE(3)
      DIMENSION LT(1000,9),EFF(1000)
      INTEGER*4 LT,IN,NEV
      INTEGER*4 NDUMP,MDUMP
      REAL*4 EFF
C
      COMMON /SCINP/ PA,PB,PC,PR,PS,PT
      COMMON /SCINA/ AG,AH,AO,AP,AQ,AU
      COMMON /CRBANG/ ED(32),AD(32,8)
      COMMON /SIGDAT/ EDAT(128),SDAT(128,9)
      COMMON /SWBLK/ NSW(6),NDUMP,MDUMP
      COMMON /FIRSC/ NFS(6,5,2)
      COMMON /SCIN/ DHYD,DCARB,IGEO,XB,YB,ZB
      COMMON /TIMING/ TBIAS, DTIM, DPOS, NTIM(100),NPOS(100)
C
C  TO ALLOW THE USE OF ANY RANDOM NUMBER GENERATOR
C  THE GENERIC FORTRAN FUNCTION 'FNCRAN()' IS USED
C  FOR ALL CALLS TO A RNDOM NUMBER FUNCTION.  THE
C  SYSTEM SPECIFIC RANDOM NUMBER FUNCTION CALL IS
C  MADE IN 'FNCRAN()'.  THE FOLLOWING TWO SEEDS
C  ALLOW LATTITUDE IN FUNCTION REQUIREMENTS.
C
      COMMON /RANGEN/ KS1,KS2
C
C  INPUT SENSE SWITCH SETTINGS, AND MAXIMUM NUMBER OF EVENTS TO DUMP
C  NSW(I), THE "SENSE SWITCHES" CONTROL HOW MUCH OUTPUT IS DUMPED
C
      READ(5,55) COMMNT
      WRITE(6,56) COMMNT
      READ(5,9001) NSW,MDUMP
      WRITE(6,9002) NSW,MDUMP
   55 FORMAT (19A4)
   56 FORMAT (' ',19A4)
 9001 FORMAT (6I1,I4)
 9002 FORMAT (' ',6I1,I4)
C
C  READ IN BIAS AND BIN WIDTH INFORMATION FOR TIMING AND POSITION STUDY
C
      READ(5,55) COMMNT
      READ(5,4) TBIAS, DTIM, DPOS
      READ(5,55) COMMNT
      READ(5,5) (ELOPE(I),I=2,3)
      ELOPE(1)=0.
C
C  READ IN CROSS SECTION DATA
C  EDAT(I) CONTAINS THE ENERGY (IN MEV) FOR THE ITH DATA POINT
C  SDAT(I,J) CONTAINS TOTAL CROSS-SECTION (IN BARNS) FOR REACTION
C  CHANNEL J FOR ITH DATA POINT
C     J=1 NP ELASTIC SCATTERING
C     J=2 NC NONDIFFRACTIVE ELASTIC SCATTERING
C     J=3 N+C+N+C+GAMMA
C     J=4 N+C=ALPHA+9BE
C     J=5 N+C=N+3ALPHAS
C     J=6 N+C=(N+P+11B) AND (2N+11C) OR (P+12B) AND (2N+11C)
C     J=7 NC DIFFRACTIVE ELASTIC SCATTERING
C     J=8 N2N CHANNEL (PREVIOUSLY INCLUDED IN CHANNEL 6)
C
      DO 2 I=1,128
    2 EDAT(I)=1.0E7
      READ(5,55) COMMNT
      READ(5,1) N
    1 FORMAT (I3)
      READ(5,55) COMMNT
C
C  (N CROSS-SECTION CARDS FOLLOW)
C
      DO 1331 I=1,N
 1331 READ(5,3) EDAT(I), (SDAT(I,J),J=1,9)
    3 FORMAT (10F5.3)
C
C  READ IN COEFFICIENT ARRAY FOR NC NON DIFFRACTIVE ELASTIC SCATTERING
C  ED(I) CONTAINS ENERGY FOR ITH DATA POINT
C  AD(I,J),J=1 TO 5, CONTAINS JTH SHAPE PARAMETER FOR ITH DATA POINT
C
      READ(5,55) COMMNT
      READ(5,1) M
      READ(5,55) COMMNT
C
C  (M DATA CARDS FOLLOW)
C
      DO 1349 J=1,32
 1349 ED(J)=1.0E7
      DO 1350 I=1,M
      READ(5,4) ED(I),(AD(I,J),J=1,5)
C
C  AD(I,J),J=6 TO 8, CONTAINS JTH AREA PARAMETER FOR ITH DATA POINT
C
      AD(I,6)=2.*AD(I,1)
      AD(I,7)=(1.-AD(I,3))*(AD(I,2)-AD(I,1))*.5
      IF (AD(I,7) .LT. 0.) AD(I,7)=0.
      AD(I,8)=(1.+AD(I,5))*(AD(I,4)-AD(I,1))*.5
      IF (AD(I,8) .LT. 0.)  AD(I,8)=0.
 1350 CONTINUE
C
C  READ SCINTILLATOR BOUNDARIES AND 1 PHOTOELECTRON LEVELS
C
      READ(5,55) COMMNT
      WRITE(6,56) COMMNT
      READ(5,55) COMMNT
      WRITE(6,56)COMMNT
      READ(5,5006)KS1,KS2
 5006 FORMAT(2I5)
      WRITE(6,5007) KS1,KS2
 5007 FORMAT(' ',2I5)
C
      READ(5,55) COMMNT
      WRITE(6,56) COMMNT
      READ(5,4) RHO, COMP
      WRITE(6,7) RHO, COMP
      READ(5,55)COMMNT
      WRITE(6,56)COMMNT
C
C     READ COEFFICIENTS FOR LIGHT RESPONSE FUNCTIONS FOR PROTONS
C
      READ(5,104)PA,PB,PC,PR,PS,PT
      WRITE(6,107)PA,PB,PC,PR,PS,PT
      READ(5,55)COMMNT
      WRITE(6,56)COMMNT
C
C     READ COEFFICIENTS FOR LIGHT RESPONSE FUNCTIONS FOR ALPHA
C
      READ(5,104)AG,AH,AO,AP,AQ,AU
      WRITE(6,107)AG,AH,AO,AP,AQ,AU
 104  FORMAT(6F12.8)
 107  FORMAT(' ',6F12.8)
    4 FORMAT(10F8.3)
    7 FORMAT(' ',10F8.3)
      DCARB=.6025*2.54*RHO/(12.+COMP)
      DHYD=DCARB*COMP
      READ(5,55) COMMNT
      WRITE(6,56) COMMNT
C
C  READ INCIDENT DIRECTION COSINES ...
C     IGEO DEFINES SHAPE OF SCINTILLATOR
C          IGEO=0  GIVES RECTANGULAR
C          IGEO=1  CYLINDER NEUTRONS INCIDENT ON END
C          IGEO=2  CYLINDER NEUTRONS INCIDENT  ON A CURVED SIDE
C
      READ(5,5) XB,YB,ZB,IGEO,IRANP
      WRITE(6,5) XB,YB,ZB,IGEO,IRANP
    5 FORMAT(3F6.2,2I2)
      WRITE(6,6)
    6 FORMAT(' ')
C
C INITIALIZE HISTOGRAM ARRAYS AND COUNTERS
C
      READ(5,55) COMMNT
      READ(5,55) COMMNT
      READ(5,55) COMMNT
 1000 DO 10 I=1,9
      DO 9 J=1,1000
    9 LT(J,I)=0
      LCON(I)=0
   10 LHI(I)=0
      NDET=0
      NDUMP=0
      IN=0
C
C  ZERO TIMING AND POSITION ARRAYS
C
      DO 11 I=1,100
      NTIM(I)=0
   11 NPOS(I)=0
      DO 12 I=1,5
      DO 12 J=1,6
      NFS(J,I,1)=0
   12 NFS(J,I,2)=0
C
C  READ USER ENTRIES FOR CALCULATIONS
c
      READ(5,15,END=9999)(XI(I),I=1,3),(CI(I),I=1,3),E1,DE,NEV,BINW
   15 FORMAT(3F5.2,3F7.4,2F8.3,I8,F8.3)
C
C      GENERIC SYSTEM PROCESSOR CLOCK CALL
C
        PROST=ELTIME(0.)
C
C  DE IS THE DESIRED BINWIDTH CENTERED ABOUT E1
C
      IF(DE .LE. 0.) DE=0.
 2000 IN=IN+1
      DO 30 I=1,3
      X(I)=XI(I)
   30 C(I)=CI(I)
      IF (IRANP .NE. 1) GO TO 2006
      IF (IGEO-1) 2002,2004,2005
 2002 X(2)=YB*(1.-2.*FNCRAN())
      X(1)=XB*(1.-2.*FNCRAN())
      GO TO 2006
C
C  IF CYLINDRICAL GEOMETRY, CHOOSE RANDOM RADIUS FROM LINEAR DISTRIBUTI
C
 2004 R=XB*SQRT(FNCRAN())
      PHI=6.2832*FNCRAN()
      X(1)=R*COS(PHI)
      X(2)=R*SIN(PHI)
      GOTO 2006
 2005 X(3)=ZB*FNCRAN()
      X(1)=XB*(1.-2.*FNCRAN())
      X(2)=SQRT(YB*YB-X(1)*X(1))
 2006 CONTINUE
      E=E1+DE*(.5-FNCRAN())
      DO 40 I=1,9
   40 EL(I)=0.
C
C  CALL SUBROUTINE FOLNUT, WHICH FOLLOWS THE NEUTRON UNTIL IT EITHER
C  ESCAPES FROM THE SCINTILLATOR OR DROPS BELOW 0.1 MEV IN ENERGY
C
      CALL FOLNUT(X,C,E,.1,EL,MS)
      IF(EL(7) .LE. 0.) GO TO 46
      DO 44 J=2,3
      K=J+6
      SIG=SQRT(EL(7)/ELOPE(J)+.5)*ELOPE(J)
C
C  GAUSS SUBROUTINE REPLACED BELOW
C  APPROXIMATION TO NORMAL DISTRIBUTION USING CENTRAL
C  LIMIT THEORM AND UNIFORM RANDOM NUMBER GENERATOR
C
      GAUSSB=-6.
      DO 9998 IGAUSS=1,12
 9998 GAUSSB=GAUSSB+FNCRAN()
   44 EL(K)=EL(7)+SIG*GAUSSB
C
C  GAUSS SUBROUTINE REPLACED ABOVE
C
   46 DO 50 I=1,9
      IF (EL(I) .LE. 0.) GO TO 50
      L=IFIX(EL(I)/BINW)+1
      IF(L .GE. 1000) L=1000
      LT(L,I)=LT(L,I)+1
      LCON(I)=LCON(I)+1
      LHI(I)=MAX0(LHI(I),L)
   50 CONTINUE
      IF (EL(7) .GT. 0.) NDET=NDET+1
      NSW(3)=NSW(3)+1
      IF(IN .GE. NEV) GO TO 3000
      GO TO 2000
 3000 CONTINUE
      XBB=2.*XB
      YBB=2.*YB
      PROST=ELTIME(PROST)/60.
      GOTO (3002,3004,3004),IGEO+1
 3002 WRITE(6,3003) ZB,XBB,YBB
      GO TO 3006
 3004 WRITE(6,3005) ZB,XB
 3003 FORMAT(/,' ','RECTANGULAR SCINTILLATOR  (INCHES)  ',
     1  F8.3,8H DEEP BY ,F8.3,4H BY  ,F8.3)
 3005 FORMAT(/,' ','CYLINDRICAL SCINTILLATOR  (INCHES)  ',
     1  F8.3,8H DEEP BY ,F8.3,10H IN RADIUS   )
 3006 CONTINUE
      WRITE(6,56) COMMNT
      WRITE(6,57) RHO, COMP
   57 FORMAT (' ','DENSITY = ',F7.3,' GM/CM**3',
     1 5X,'H/C RATIO = ',F7.3)
      WRITE(6,300) IN,E1,DE,(XI(I),I=1,3),(CI(I),I=1,3)
  300 FORMAT(' ',I8,' NEUTRONS OF ENERGY ',
     1 F6.2,' BINW ',F6.3,' MEV ',
     1 /,' INCIDENT AT X,Y,Z = ',3F7.2,' INCHES'
     1 /,' DIRECTION COSINES = ',3F7.4)
      IF (IRANP  .EQ. 1) WRITE(6,301)
  301 FORMAT (' ','** RANDOM INITIAL POSITION **')
      WRITE(6,3102)PROST
 3102 FORMAT(' ','PROCESSSOR TIME = ',F8.2,' MINUTES.')
      IF (NSW(1).EQ.1) GOTO 3360
      WRITE(6,3007)
      WRITE(6,3008)
 3007 FORMAT (' ','DIFFERENTIAL PULSE HEIGHT SPECTRA')
 3008 FORMAT (' ','LIGHT OUTPUT IN MEV ELECTRON EQUIVALENT')
      DO 350 I=1,6
      NC=LHI(I)
      WRITE(6,302) I,BINW,LCON(I)
      IF (LCON(I) .EQ. 0) GO TO 350
  302 FORMAT(' ','CHANNEL ',I3,' ONLY ',5X,'BIN WIDTH ',F5.3,
     1 6X,I8,' EVENTS')
      EN=LCON(I)
      DO 351 J=1,NC
      EFF(J)=EN/FLOAT(IN)
  351 EN=EN-FLOAT(LT(J,I))
      WRITE(6,304)(LT(L,I),L=1,NC)
  304 FORMAT (' ',10F5.0)
      WRITE(6,3009)
      WRITE(6,310)(EFF(J),J=1,NC)
  350 CONTINUE
      DO 360 I=1,3
      K=I+6
      WRITE(6,306) ELOPE(I),BINW,LCON(K)
  306 FORMAT (' ','LIGHT OUTPUT FROM ALL CHANNELS ',5X,
     1 'ONE PHOTOELECTRON LEVEL AT ',F7.3,' MEV ',
     1 /,'BIN WIDTH ',F5.3,' MEV ',6X,I7,' EVENTS ')
      NC=LHI(K)
  360 WRITE(6,304) (LT(L,K),L=1,NC)
      WRITE(6,3009)
 3009 FORMAT (' ',//,' ','INTEGRAL PULSE HEIGHT SPECTRA')
      WRITE(6,3008)
 3360 K=8
      NC=LHI(K)
      WRITE(6,308) ELOPE(2),BINW
  308 FORMAT (' ',/,' ','INTEGRAL EFFICIENCY:  ONE P.E. = ',F7.3,
     1 ' MEV ',3X,' BIN WIDTH ',F5.3,' MEV')
      WRITE(6,309)
  309 FORMAT (' ','NOTE:  FIRST BIN CORRESPONDS TO ZERO BIAS.')
      EN=LCON(K)
      DO 370 J=1,NC
      EFF(J)=EN/FLOAT(IN)
  370 EN=EN-FLOAT(LT(J,K))
      WRITE (6,3333) E1,BINW,NC
 3333 FORMAT (' ',F7.2,F7.3,I7)
      WRITE(6,310) (EFF(J),J=1,NC )
  310 FORMAT ((' ',10(2PF7.3)))
      WRITE(6,311)
  311 FORMAT(' ')
      IF (NSW(1).EQ.1) GOTO 1000
      WRITE(6,400)
  400 FORMAT (/,'FIRST SCATTER DATA')
      WRITE(6,3010)
 3010 FORMAT(/,' BIAS ',6X,'CH.1  CH.2  CH.3  CH.4  CH.5  CH.6')
  420 FORMAT (/,F6.2,6X,6I6)
      BIAS=.125
      DO 410 I=1,5
      BIAS=BIAS*2.
  410 WRITE(6,420) BIAS,(NFS(J,I,1),J=1,6)
C
C  OUTPUT SECOND SCATTER INFORAMATION
C
      WRITE(6,500)
  500 FORMAT (/,'SECOND SCATTER DATA')
      WRITE(6,3010)
      BIAS=.125
      DO 510 I=1,5
      BIAS=BIAS*2.
  510 WRITE(6,420) BIAS,(NFS(J,I,2),J=1,6)
C
C  OUTPUT TIMING AND POSITION INFORMATION
C
      WRITE(6,520) TBIAS
  520 FORMAT (/,'HISTOGRAMS OF TIME DELAY AND X-COORD.',
     1  ' DRIFT BEFORE BIAS OF ',F5.3,'MEV ATTAINED')
      WRITE(6,521) DTIM
  521 FORMAT (/,'TIMING ',F5.3,' NSEC/BIN')
      WRITE(6,522) NTIM
  522 FORMAT (2(10I5,5X))
      WRITE(6,523) DPOS
  523 FORMAT (/,'POSITION ',F5.3,' INCH/BIN')
      WRITE(6,522) NPOS
      GO TO 1000
 9999 STOP
      END

