/*
    Z150BIOS.H - This file defines information for and about the
		 Z150 BIOS.
*/

/*
		RESTRICTED RIGHTS LEGEND
		------------------------
	
	    "Use, duplication, or disclosure by the
	Government is subject to restrictions as set forth
	in paragraph (b) (3) (B) of the Rights in Technical
	Data and Computer Software clause in DAR
	7-104.9(a).  Contractor/manufacturer is Zenith
	Data Systems Corporation of Hilltop Road, St.
	Joseph, Michigan 49085.
*/



#define BIOS2_SEG 0x70		/* Segment the 2.0 BIOS resides at */
#define BIOS1_SEG 0x60		/* Segment the 1.25 BIOS resides at */
#define BIOS2_CVER 21		/* Version of the 2.0 BIOS (must be >= 20) */
#define BIOS1_CVER 0		/* Version of the 1.25 BIOS (must be < 20) */

#define CONFIG_PTR	0	/* Offset of config. info. pointer in 1.25 and 2.0 BIOS */

/* Define the structure of a parallel device configuration table */
struct pct
{
    char pct_remap;
#define pct_spo (1 << 4)
#define pct_mlo (1 << 6)
    char pct_padchar;
    char pct_numpad;
    char pct_time_out;
};

/* Define the structure of a serial device configuration table */
struct sct
{
    char sct_handshake;
#define sct_default   (1 << 0)
#define sct_protocol  (1 << 1)
#define sct_dtr       (1 << 2)
#define sct_dtr_polar (1 << 3)
#define sct_rts       (1 << 4)
#define sct_rts_polar (1 << 5)
#define sct_etx_dc1   (1 << 2)
    char sct_attr;
#define sct_spi (1 << 0)
#define sct_spo (1 << 1)
#define sct_mli (1 << 2)
#define sct_mlo (1 << 3)
    char sct_padchar;
    char sct_numpad;
    char sct_flag;
    char sct_count;
    char sct_init;
    char sct_time_out;
};


/* Define a bios parameter block */
struct bpb
{
    unsigned sector_size;	/* Sector size			*/
    char spau;			/* sectors per allocation unit	*/
    unsigned reserved;		/* Reserved sectors		*/
    char nfats;			/* Number of FAT's		*/
    unsigned dirents;		/* Number of directory entries	*/
    unsigned secs;		/* Number of sectors		*/
    char mbyte;			/* Media byte			*/
    unsigned fatsecs;		/* Number of sectors per FAT	*/
    unsigned spt;		/* Sectors per track		*/
    unsigned heads;		/* Number of heads		*/
    unsigned hidden;		/* Number of hidden sectors	*/
    char unit;			/* Unit number of device	*/
};


/* Define the BIOS device table */
struct io_table
{
    struct pct pct_tbl[3];
    struct sct sct_tbl[2];
};

/*
    Define the configuration table in the 1.25 BIOS, 
    pointer at offset CONFIG_PTR from start of the BIOS
*/
struct config1_vector
{
    char bios_version;
    struct io_table *io_address;
    char disk_map[4];
};

/*
    Define the configuration table in the 2.0 BIOS, 
    pointer at offset CONFIG_PTR from start of the BIOS
*/
struct config2_vector
{
    char bios_version;
    struct io_table *io_address;
    struct bpb *fixed_bpbs;
    char *assign_flags;
    char auto_flag;
};

