	PAGE	,132
;
;   SHIP.ASM - This program will prepare the winchester disk for shipping
;	It will first print out a message stating the effects of SHIP
;	and ask the user if he wants to continue. If the answer is yes
;	then the heads are moved to the shipping cylinder and the computer
;	locks up.
;
;	Author:	RJM
;
;	Date:	10/28/83
;
;	Version 1.76 - Modify for 8 winchesters
;
;	Version 1.90 - Update utility versions to same version number

;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

	.xlist
	include ..\commons\ascii.def
	include	..\commons\msdos.def
	include ..\commons\z150rom.def
	include ..\commons\macro.asm
	.list

false	=	0
true	=	not false

zenith	=	true
nbi	=	false
syntrex	=	false

code	segment	byte public
	assume	cs:code, ds:code, es:code, ss:code

	org	100h
ship:
	mov	sp,offset stack_top	; Set up stack

;	Greet the user

	sys	dosf_outstr,<offset signon>

;	Tell the user about SHIP

	sys	dosf_outstr,<offset help>

;	Ask the user if we should continue

	sys	dosf_outstr,<offset prompt>

;	Get the users response

	sys	dosf_conin
	push	ax

	sys	dosf_outstr,<offset crlf>
	sys	dosf_outstr,<offset crlf>

	pop	ax
	cmp	al,'Y'
	jz	ship1
	cmp	al,'y'
	jz	ship1

;	User does not want to continue

	int	dosi_term

;	Find out how many drives the user has

ship1:
	mov	ah,dio_getparms		; dio_getparms
	mov	dl,80h
	int	disk_io_intr

	jc	no_controller		; No winchester controller
	cmp	dl,0
	jz	no_disks		; No winchester drives attached

	mov	num_disks,dl		; Save number of drives
	mov	byte ptr drive,80h	; Set unit number of first drive

;	Get the shipping cylinder 

shipa:
	mov	ah,dio_getparms		; Get the drive parameters
	mov	dl,byte ptr drive
	int	disk_io_intr

	xchg	cl,ch			; Decode the last user cyl.
	and	ch,0c0h
	rol	ch,1
	rol	ch,1
	inc	cx			; Seek to cyl. after last user cyl.

;	Prepare for seek call to ROM

	xchg	cl,ch
	ror	cl,1
	ror	cl,1
	add	cl,1

	mov	ah,0ch			; dio_seek Seek command
	mov	dl,drive		; Get drive value
	mov	dh,0			; Head 0
	int	disk_io_intr

;	See if any more drives to ship

	inc	drive
	dec	num_disks
	jnz	shipa

;	Tell the user done and lock up the computer

	sys	dosf_outstr,<offset end_msg>
	cli
stall:
	jmp	stall

;	No controller error

no_controller:
	sys	dosf_outstr,<offset ctrlr_msg>
	int	dosi_term

;	No fixed disks attached error

no_disks:
	sys	dosf_outstr, <offset drive_msg>
	int	dosi_term

;	Local stack

	db	128 dup(0)
stack_top label	word


num_disks db	0		; Number of disk drives
drive	db	0		; Drive number of current drive


	if	zenith
signon	db	cc_cr, cc_lf
	db	'               SHIP Version 2.00', cc_cr, cc_lf
	db	'Copyright 1984(C), Zenith Data Systems Corporation.', cc_cr, cc_lf, '$'
	endif

	if	nbi
signon	db	cc_cr, cc_lf
	db	'     SHIP Version 2.00', cc_cr, cc_lf
	db	'(C) Copyright NBI, Inc. 1984', cc_cr, cc_lf, '$'
	endif

	if	syntrex
signon	db	cc_cr, cc_lf
	db	'       SHIP Version 2.00', cc_cr, cc_lf
	db	'(C) Copyright SYNTREX, Inc. 1986', cc_cr, cc_lf, '$'
	endif

help	db	cc_cr, cc_lf, 'The SHIP utility helps you to:', cc_cr, cc_lf, cc_lf
	db	'   * Position the read/write heads of the Winchester disk', cc_cr, cc_lf
	db	'     at a safe location for subsequent transportation', cc_cr, cc_lf
	db	'     of the disk unit.', cc_cr, cc_lf, cc_lf
	db	'After running SHIP, no further operation on your computer', cc_cr, cc_lf
	db	'will be possible. At that time, turn off the  power to the', cc_cr, cc_lf
	db	'computer and prepare it for shipping.', cc_cr, cc_lf, '$'



prompt	db	cc_cr, cc_lf, 'Do you wish to continue (Y/N):$'

crlf	db	cc_cr, cc_lf, '$'

ctrlr_msg db	'Can not communicate with winchester controller', cc_cr, cc_lf, '$'

drive_msg db	'No winchester drives are attached', cc_cr, cc_lf, '$'

end_msg	db	'Heads moved to shipping cylinder. Turn off your computer', cc_cr, cc_lf
	db	'and prepare it for shipping.', cc_cr, cc_lf, '$'

code	ends
	end	ship

