Page	60,132
Title	-Nmi Functions
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 21_Sept_85
;
%Out	MiscNmi.asm
page
;----------------------------------------------------------------------
; Equates (13_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	Io.lit
;	Video.lit
;	Icon.lit

	.xlist
	Include Rom.lit
	Include Intr.lit
	Include ..\Io\Io.lit
	Include ..\Video\Video.lit
	Include ..\Icon\Icon.lit
	.list

Time_On		equ	3		;time to display LoBatt msg
Time_Off	equ	10		;time to wait between LoBatt msgs


;======================================================================
Screen_Segment Segment Word At (0B800h)
;======================================
;
Screen_Segment EndS


;======================================================================
Rom_Data Segment Word At (40H)
;=============================
;
	extrn	Cursor_Position:Word
	extrn	Displayed_Page:Byte
	extrn	Video_Mode:Byte

Rom_Data EndS

page
;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing

	extrn	Change_State:Near
	extrn	Out_Morrow_6845:Near
;hf	extrn	Get_Time:Near
	extrn	Enable_Cursor_Ram:Near
	extrn	Disable_Cursor_Ram:Near

	extrn	DS_to_Rom_Data:Near
	extrn	Set_Cursor_Position:Near
	extrn	Disp_Char_Attr:Near

	extrn	SC_Task:Byte
	extrn	SC_State:Byte
	extrn	No_Task_Change:Byte
	extrn	Current_State:Byte

	extrn	Old_Video_Mode:Byte
	extrn	Old_Displayed_Page:Byte
	extrn	Current_Page:Byte
	extrn	Cursor_Ptr:Word
	extrn	Cursor_Flag:Byte

	extrn	LoBatt_On_Cnt:Byte
	extrn	LoBatt_Off_Cnt:Byte
	extrn	LoBatt_Disp:Byte

	extrn	Stk_LoBatt:Word
	extrn	Diag_Load_Addr:Near

;hf	extrn	Battery_Low:Word
;hf	extrn	Battery_Dead:Word
;hf	extrn	Battery_Flag:Byte

page
;----------------------------------------------------------------------
; Fixed Data Area (12_May_85)
;----------------------------
;
LowMsg		db	' Battery Low - Save Data Now! ',0
Dead_Msg	db	'Battery Dead - System Halted',0

page
;----------------------------------------------------------------------
Low_Battery_2_Function Proc Near; (21_Sept_85)
;---------------------------------------------
;	1) write dead battery message to screen.
;	2) disable interrupts and halt the processor.
;	3) ** Warning ** the 6845 registers cannot be referenced because
;			 the 80C39 has already shut itself off.
;
Assume	cs:Monitor_segment, ds:Monitor_Segment, es:Screen_Segment, ss:Nothing
Public	Low_Battery_2_Function

;hf	call	Get_Time
;hf	mov	Battery_Dead,cx		;Battery_Dead:= Current Hr/Min

	push	cs
	pop	ds

	mov	ax,Screen_Segment
	mov	es,ax			;ES:= Base of Screen Segment
	mov	di,(40 * 11 * 2)	;DI:= Starting Line Address (Line 11)
	mov	cx,(40 * 3)		;CX:= 3 Lines to Clear
	mov	ax,0f20h		;AX:= Space, Bright Attribute
	rep	stosW			;Clear the Center 3 Screen Lines

	mov	di,(40 * 12 * 2)	;DI:= Pointer to Screen Area for Msg
	mov	si,Offset Dead_Msg	;SI:= Pointer to Start of Message
Lb2Lp1:	lodsB				;Loop	AL:= Next Character of Message
	or	al,al			;	If (End of String)
	jz	Lb2Sk3			;		Break

	stosB				;	Write to the Screen
	inc	di			;	(move past attribute)
	jmp	short Lb2Lp1

Lb2Sk3:	cli				;Disable Interrupts
	hlt				;Stop the processor

Low_Battery_2_Function	EndP

page
;----------------------------------------------------------------------
Cursor_Updated_Function	Proc Near; (8_Jul_85)
;--------------------------------------------
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Cursor_Updated_Function

	push	es
	mov	bx,Screen_Segment
	mov	es,bx			;	ES:= video segment
	mov	bx,Cursor_Ptr
	mov	Byte Ptr es:[bx],0	;	Clear the old cursor

	mov	dx,Color_Card+1
	in	al,dx
	mov	bh,al			;	BH:= High Byte Cursor Location

	in	al,dx
	mov	bl,al			;	BL:= Low Byte Cursor Location

	cmp	bx,1999			; If out of Range, No Cursor to be turned on
	ja	CrSk1

	shl	bx,1

	mov	Cursor_Ptr,bx		;	Save the new cursor position
	mov	Byte Ptr es:[bx],0FFH	;	Place new cursor on the screen
CrSk1:	pop	es

	ret				;Return

Cursor_Updated_Function	EndP

page
;----------------------------------------------------------------------
LoBatt1_State0 Proc Near; (21_Sept_85)
;-------------------------------------
;	1) display LoBatt1 message on the screen.
;
Assume	cs:Monitor_segment, ds:Monitor_Segment, es:Nothing, ss:Nothing
Public	LoBatt1_State0

	push	ds
	push	si
	push	cs
	pop	ds			;DS:= Monitor Segment

;hf	cmp	Battery_Flag,0		;If (Lo_Batt Not Yet Logged)
;hf	jnz	Lb00
;hf
;hf	call	Get_Time
;hf	mov	Battery_Flag,0FFh	;	Battery_Flag:= Active
;hf	mov	Battery_Low,cx		;	Battery_Low:= Current Hr/Min
;hf Lb00:

	mov	bh,0			;BH:= Select Page 0
	mov	ah,3			;AH:= Get Cursor Position Function
	int	10h			;Set the Cursor Position
	push	dx			;Save the Entry Cursor Position

	mov	si,Offset LowMsg	;SI:= Pointer to Start of Message
	mov	dh,1			;DH:= Cursor Starting Row
	mov	dl,15			;DL:= Cursor Starting Column

Lb01Lp:	lodsb				;While (next byte of message ne 0)
	or	al,al
	jz	Lb01Sk

	mov	bh,0			;	BH:= Select Page 0
	call	Set_Cursor_Position	;	Set the Cursor Position

	mov	bh,0			;	BH:= Select Page 0
	mov	bl,0fh			;	BL:= Select Bright Screen Attr
	mov	cx,1			;	CX:= Repeat Count to 1
	mov	ah,9
	int	10h

	inc	dl			;	DL:= Next Character Position
	jmp	short Lb01Lp

Lb01Sk:	pop	dx			;DX:= Entry Value of Cursor Row/Column
	mov	bh,0			;BX:= Current Page to 0
	call	Set_Cursor_Position	;Set the Cursor Position

	mov	LoBatt_On_Cnt,Time_On	;Reset display time On count
	mov	LoBatt_Off_Cnt,Time_Off	;Reset display time Off count

	mov	LoBatt_Disp,True	;we are in display state
	or	No_Task_Change,Ntc_f1	;Stop Task Changes While Displaying

	mov	al,1			;AL:= Desired State
	mov	ah,LoBatt1 - 2		;AH:= Task Id
	call	Change_State		;Start Change to State 1
	pop	si
	pop	ds
	ret				;Return

LoBatt1_State0	EndP

page
;----------------------------------------------------------------------
LoBatt1_State1 Proc Near; (13_May_85)
;------------------------------------
;	1) down count the display time, when zero then change to
;	   the 'Exit'state to restore screen
;	2) Notice that the test is for equal to 0. This insures that only
;	   one Nmi Regeneration will occur.
;
Assume	cs:Monitor_segment, ds:Nothing, es:Nothing, ss:Nothing
Public	LoBatt1_State1

	dec	LoBatt_On_Cnt		;Decrement Display Hold Time
	ja	Lb11Sk			;If (Display Hold Time Count eq 0)

	mov	LoBatt_Disp,False	;	Clear the Status Flag
	and	No_Task_Change,NOT Ntc_f1 ;	ReEnable Task Changes

	mov	al,2			;	AL:= Desired State
	mov	ah,LoBatt1 - 2		;	AH:= Task Id
	call	Change_State		;	Start Change to State 2
Lb11Sk:	ret				;Return

LoBatt1_State1	Endp


;----------------------------------------------------------------------
LoBatt1_State2 Proc Near; (13_May_85)
;------------------------------------
;	1) this state counts down a delay counter, waiting for the next
;	   time to display a low battery message.
;	2) Notice that the test is for equal to 0. This insures that only
;	   one Nmi Regeneration will occur.
;
Assume cs:Monitor_segment, ds:Nothing, es:Nothing, ss:Nothing
Public	LoBatt1_State2

	dec	LoBatt_Off_Cnt		;Decrement the Off time Delay Count
	ja	Lb12Sk			;If (Off time count eq Done)

	mov	al,0			;	AL:= Desired State
	mov	ah,LoBatt1 - 2		;	AH:= Task Id
	call	Change_State		;	Start Change to State 0
Lb12Sk:	ret				;Return

LoBatt1_State2	Endp

page
;----------------------------------------------------------------------
Disk_Icon Proc Near; (12_May_85)
;-------------------------------
;	1) If the system hasn't been booted yet then control is passed to
;	   the boot routine; Otherwise, control is returned to the task
;	   handler.
;
Assume cs:Monitor_segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Disk_Icon

	mov	bl,(Icon_Disk - 2) / 2
	mov	bh,0			;AX:= Offset to Current State
	mov	cl,Current_State[bx]	;CL:= Disk Icon's State
	mov	Current_State[bx],1	;Force the State to 1
	cmp	cl,0			;If (current state is NOT 0)
	jz	DiSk1
	ret				;	Return

DiSk1:	mov	al,Default_Intr_Mask	;Else
	or	al,NOT Timer_Intr_Mask
	out	Interrupt_Mask,al	;	Install the Default Irq Mask
	int	Boot_Intr		;	Boot the system

Disk_Icon	EndP

page
;----------------------------------------------------------------------
Ac_Changed Proc Near; (27_Jun_85)
;--------------------------------
;	1) If the low battery message is NOT being displayed then do Nothing.
;	2) If the low battery message is being displayed then the ON Counter
;	   is reset to 1 and Lo_Batt1 Nmi is requested. When the Lo_Batt1
;	   Nmi occurs the time out counter will be decremented with a zero
;	   result. This will cause the Lo_Batt1 State_1 to do a State Change
;	   to State 2. In the process of changing from state 1 to state 2
;	   the original screen area will be restored.
;	3) Notice that the Off time is forced to a minimum value of 2 so
;	   that the next Lo_Batt1 Nmi will promptly enter its message
;	   displayed state. The minimum value of 2 is necessary to keep state
;	   2 from immediatly executing a state change (like state 1).
;
Assume cs:Monitor_segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Ac_Changed

	mov	LoBatt_On_Cnt,1		;Force On time to Minimum
	mov	LoBatt_Off_Cnt,2	;Force On time to Minimum

	cmp	LoBatt_Disp,True	;If (Lo_Batt message is Displayed)
	jnz	AcSk1

	mov	ah,LoBatt1		;	AH:= Task Number
	mov	al,Nmi_Regenerate	;	AL:= 6845 Reg (Regenerate Nmi)
	call	Out_Morrow_6845		;	Start Last Lo_Batt Nmi
AcSk1:	ret				;Return

Ac_Changed	EndP

page
;----------------------------------------------------------------------
Alt_Clock_Icon Proc Near; (7_Aug_85)
;-----------------------------------
;	1) This Task Starts up the Rom Resident Diagnostics which are saved
;	   in the 80c39's rom.
;	2) The 80c39's accessable memory is organized like the sectors on a
;	   disk. To retrieve a given sector you must Regenerate an Nmi with
;	   the sector value or'ed with the Rom_Sector flag.
;	3) Within the task handler there is a table of Rom_Sector destination
;	   addresses and byte counts.
;
Assume cs:Monitor_segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Alt_Clock_Icon

	mov	bh,0			;BX:= Current Rom Sector
	mov	cx,2			;CX:= Loop Counter

AaLp1:	mov	ah,Sector_Flag		;Repeat
	or	ah,bh			;	AH:= Current Rom Sector
	mov	al,Nmi_Regenerate	;	AL:= 6845 Reg (Regenerate Nmi)
	call	Out_Morrow_6845		;	Read the Next Sector

	push	cx
	mov	cx,50h
AaLp2:	loop	AaLp2			;	Wait for Sector to be read
	pop	cx
	
	inc	bh			;	Increment the Current Sector
	loop	AaLp1			;Until (All Sectors have been Read)

	mov	No_Task_Change,Ntc_f1	;Stop Task Changes
	jmp	Diag_Load_Addr		;Execute the diagnostics

Alt_Clock_Icon	EndP

page
;----------------------------------------------------------------------
Cursor_Off_Function Proc Near; (9_Jul_85)
;----------------------------------------
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Cursor_Off_Function

	call	Enable_Cursor_Ram
	push	es

	mov	bx,Screen_Segment
	mov	es,bx			;ES:= video segment
	mov	bx,Cursor_Ptr
	mov	Byte Ptr es:[bx],0	;Clear the old cursor

	pop	es
	call	Disable_Cursor_Ram
	ret				;Return

Cursor_Off_Function	EndP

page
;----------------------------------------------------------------------
Power_Off_Function Proc Near; (7_Aug_85)
;---------------------------------------
;
Assume	cs:Monitor_Segment, ds:Nothing, es:Nothing, ss:Nothing
Public	Power_Off_Function

	cli				;Disable Maskable Interrupts
	hlt				;Stop

Power_Off_Function EndP

Monitor_Segment	EndS
		End

