Page	60,132
Title	-Miscellaneous Functions

;**********************************************************************
;
;                   --------------------------------
;------------------- Miscellaneous Functions Module -------------------
;                   --------------------------------
;
;		Copyright (C) 1983, by Zenith Data Systems
;
;	Last update 19_June_85
;		- fixed Set_User_Stack, and Set_Monitor_Stack
;
;
;**********************************************************************

%Out	Misc.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	ROM.LIT
;	IO.LIT
;	SYS.EXT

	.xlist
	INCLUDE	ROM.LIT
	INCLUDE ..\IO\IO.LIT
	INCLUDE ..\ROM\SYS.EXT
	.list

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:INTERRUPT_SEGMENT

	EXTRN	SS_SAVE:WORD, SP_SAVE:WORD, IP_SAVE:WORD, STACK_LEVEL:BYTE
	EXTRN	LOCAL_STACK_TOP:BYTE

;**********************************************************************
; CASE: (CASE_NUMBER)
;
;	Case is an assembly language equivalent to the case/switch
; statements available in high-level languages.  It is called with
; the case number, and immediately following the 'CALL CASE' is
; a jump to the location where all of the case routines may 'RET'urn
; to, and then a list of pointers (NEAR type) to each case routine.
; It is very important that the 'JMP ENDCASE' be a NEAR jump  -
; NOT a short jump!
;	Note that Case does NOT check for bounds - it is the
; caller's responsibility to ensure that the Case_Number is valid.
;
; Input:
;	AH: Case number = routine to be called.
;
; Example:
;		CALL	CASE		;Call the case routine
;		JMP	ENDCASE		;All of the CASE routines return here
;		DW	CASE_0		;If AH=0, this is called
;		DW	CASE_1		;If AH=1, this is called
;		DW	CASE_2		;If AH=2, this is called
;		...
;	ENDCASE:...
;
; Registers:	Register BP is detroyed!
;**********************************************************************
CASE PROC NEAR
	PUBLIC	CASE
	POP	BP			;Get ret address (Ptr to JMP ENDCASE)
	PUSH	BP			;Save return addr for case routines
	ADD	BP,3			;Now point to the case table
	PUSH	AX			;Save AX
	MOV	AL,AH			;Get the case number
	MOV	AH,0			;...as a word
	SHL	AX,1
	ADD	BP,AX			;Point to the right case entry
	POP	AX			;Restore AX
	PUSH	WORD PTR CS: [BP]	;Place case routine address on stack
	RET				;'Return' to the right case routine
CASE ENDP



;**********************************************************************
; BEEP:
;
;	Beep 'tones' the speaker for approximately 1/6 second, to
; indicate an error condition.
;**********************************************************************
BEEP PROC NEAR
	PUBLIC	BEEP
	PUSHREG	<CX>			;Save registers
	MOV	CX,166			;Set count to 1/6 second
	CALL	TONE			;Perform the tone
	POPREG	<CX>			;Restore registers
	RET
BEEP ENDP



;**********************************************************************
; CLICK:
;
;	Click is used to generate a short click sound on the built-in
; speaker.  This is usually used to indicate that a lengthy process
; is still executing properly.
;**********************************************************************
CLICK PROC NEAR
	PUBLIC	CLICK
	PUSHREG	<CX>			;Save registers
	MOV	CX,20			;Set count to 20 milliseconds
	CALL	TONE			;Perform the click
	POPREG	<CX>			;Restore registers
	RET
CLICK ENDP



;**********************************************************************
; TONE:
;
;	Tone produces a tone for a user-supplied period.
;
; Input:
;	CX: Length of tone in milliseconds.
;**********************************************************************
TONE PROC NEAR
	PUBLIC	TONE
	PUSHREG	<AX,CX>
	MOV	AL,TONE_CONTROL		;Select the speaker port
	OUT	TIMER_CTRL,AL
	MOV	AL,LOW TONE_FREQ	;Send L.S. byte of tone count
	OUT	TIMER_2,AL
	MOV	AL,HIGH TONE_FREQ	;Send M.S. byte of tone count
	OUT	TIMER_2,AL
	IN	AL,SYS_CTRL_PORT	;Read the speaker control port
	PUSH	AX			;Save status
	OR	AL,SPEAKER_ON		;Enable the speaker
	OUT	SYS_CTRL_PORT,AL
	CALL	DELAY			;Wait a half second (or so)
	POP	AX			;Restore status of the system port
	OUT	SYS_CTRL_PORT,AL
	POPREG	<CX,AX>
	RET
TONE ENDP



;**********************************************************************
; DELAY: (COUNT)
;
;	Delay pauses for approximately COUNT milliseconds.
;
; Input:
;	CX: Delay count in milliseconds
;**********************************************************************
DELAY PROC NEAR
	PUBLIC	DELAY
	PUSHREG	<CX>
DLY1:	PUSH	CX			;Save delay count
	MOV	CX,DELAY_ONE_MS		;Approximate count for 1 msec delay
DLY2:	LOOP	DLY2			;Wait a millisecond
	POP	CX			;Restore count
	LOOP	DLY1			;Loop until proper delay finished
	POPREG	<CX>
	RET
DELAY ENDP



;**********************************************************************
; GET_INTR_PTR: (INTERRUPT_NUMBER)
;
;	Get_Intr_Ptr retrieves the contents of an interrupt pointer.
;
; Input:
;	AL: Interrupt number (0-0FFH)
;
; Output:
;    DS:SI: Contents of the selected interrupt vector.
;**********************************************************************
GET_INTR_PTR PROC NEAR
	PUBLIC	GET_INTR_PTR
	PUSHREG	<AX>
	MOV	AH,0			;Extend intr number to a word
	SHL	AX,1			;Multiply by size of an intr vector
	SHL	AX,1
	MOV	SI,INTERRUPT_SEGMENT	;Point DS to the interrupt segment
	MOV	DS,SI
	MOV	SI,AX			;Get the interrupt vector's offset
	LDS	SI,DWORD PTR [SI]	;Retrieve the interrupt pointer
	POPREG	<AX>
	RET
GET_INTR_PTR ENDP



;**********************************************************************
; SET_INTR_PTR: (INTERRUPT_NUMBER, INTR_POINTER)
;
;	Set_Intr_Ptr sets an interrupt vector to a user-supplied
; value.
;
; Input:
;	AL: Interrupt number (0-0FFH)
;    DS:SI: Pointer to be placed at the interrupt vector location.
;**********************************************************************
SET_INTR_PTR PROC NEAR
	PUBLIC	SET_INTR_PTR
	PUSHREG	<AX,DI,ES>
	MOV	AH,0			;Extend intr number to a word
	SHL	AX,1			;Multiply by size of an intr vector
	SHL	AX,1
	MOV	DI,INTERRUPT_SEGMENT	;Point ES:DI to the interrupt vector
	MOV	ES,DI
	MOV	DI,AX			;Get the interrupt vector's offset
	MOV	WORD PTR ES: [DI],SI	;Write offset part of pointer
	MOV	WORD PTR ES: [DI+2],DS	;Write segment, as well
	POPREG	<ES,DI,AX>
	RET
SET_INTR_PTR ENDP

page
;----------------------------------------------------------------------
Set_Monitor_Stack Proc Near; (18_Jun_85)
;---------------------------------------
;	Set_Monitor_Stack is called to set up a local stack, in order
; to minimize the RAM requirements of user stacks.  This routine
; checks to see if the local stack is already in use - if so, it
; will have no affect.
;
Public	Set_Monitor_Stack

	cli				;Protect this code!
	cmp	Stack_Level,0		;If (Monitor Stack ne Active)
	jne	Sms1

	pop	IP_Save			;	IP_Save:= Return Address
	mov	SS_Save,ss		;	Save current stack segment
	mov	SP_Save,sp		;	Save current stack pointer
	push	cs
	pop	ss			;	SS:= Current Code Segment

	mov	SP,Offset Local_Stack_Top ;	SP:= Offset to Local Stack
	push	IP_Save			;	Restore return address

SMS1:	inc	Stack_Level		;Stack_Level:= Stack_Level + 1
	ret				;Return

Set_Monitor_Stack EndP

;----------------------------------------------------------------------
Set_User_Stack Proc Near; (18_Jun_85)
;------------------------------------
;	Set_User_Stack is called to restore the user's local stack
; pointer, following a call to SET_MONITOR_STACK.
;
Public	Set_User_Stack

	cli				;Protect this code!
	dec	Stack_Level		;Stack_Level:= Stack_Level - 1
	jnz	Sus1			;If (Stack ready for release)

	pop	IP_Save			;	IP_Save:= Return Address
	mov	ss,SS_Save		;	SS:= User's stack segment
	mov	sp,SP_Save		;	SP:= User's stack pointer
	push	IP_Save			;	Restore return address

Sus1:	ret				;Return

Set_User_Stack	EndP

Monitor_Segment	EndS
		End
