Page	60,132
Title	-Miscellaneous Interrupt Service Routines
;
;
;	Copyright (c) 1983
;	Zenith Data Systems
;	St. Joseph, Michigan
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 1_Jul_85
;
;
%Out	Intr.asm
page
;----------------------------------------------------------------------
; Equates
;--------
;
; Include Files
;--------------
;	Rom.lit
;	Intr.lit
;	IO.lit

	.xlist
	Include Rom.lit
	Include Intr.lit
	Include ..\IO\IO.lit
	.list

;======================================================================
Rom_Data Segment Word At (40h)
;=============================
;
Rom_Data EndS

;======================================================================
Monitor_Segment Segment Word Public
;==================================
;
Assume	cs:Monitor_Segment, ds:Rom_Data, ss:Rom_Data, es:Nothing

	extrn	DS_to_Rom_Data:Near
	extrn	Disp_String:Near

	extrn	Div_Err_Msg:Byte
	extrn	Overflow_Msg:Byte
	extrn	Wild_Intr_Msg:Byte
	extrn	Wild_HW_Msg:Byte

page
;----------------------------------------------------------------------
Zero_Divide_Interrupt Proc Far; (1_Jul_85)
;-----------------------------------------
;	Zero_Divide_Interrupt is called when the CPU has executed
; a divide-by-zero, and no user trap has been installed.  This routine
; prints out a message to inform the user of the problem, and it then
; returns.
;
Public	Zero_Divide_Interrupt

	PushReg	<si,ds>			;Save registers
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	si,Offset Div_Err_Msg	;Print the divide-by-zero message
	call	Disp_String
	PopReg	<ds,si>			;Restore registers
	iret				;Return

Zero_Divide_Interrupt EndP


;----------------------------------------------------------------------
Overflow_Interrupt Proc Far; (1_Jul_85)
;--------------------------------------
;	Overflow_Interrupt is called when the CPU has overflowed during
; an arithmetic operation without a user interrupt service routine
; being installed.  An overflow message is printed, and control is
; returned to the routine which caused the interrupt.
;
Public	Overflow_Interrupt

	PushReg	<si,ds>			;Save registers
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	si,Offset Overflow_Msg	;Print the overflow message
	call	Disp_String
	PopReg	<ds,si>			;Restore registers
	iret				;Return

Overflow_Interrupt EndP

;----------------------------------------------------------------------
Do_Nothing Proc Far; (1_Jul_85)
;------------------------------
;	'Do_Nothing' is executed when an installable interrupt has not 
; been installed, but the interrupt has been executed (ie, the user 
; break interrupt, etc).
;
Public	Do_Nothing

	iret				;Do precisely nothing!

Do_Nothing	EndP

page
;----------------------------------------------------------------------
Reserved_Interrupt Proc Near; (1_Jul_85)
;---------------------------------------
;
;	Reserved_Interrupt is called when a user interrupt is executed
; which is not defined, or is reserved for future use.  It prints out
; an error message, and loops with interrupts enabled so the user can
; do CTRL-ALT-DEL to recover.
;
Public	Reserved_Interrupt

	PushReg	<si,ds>			;Save contents of registers
	call	DS_to_Rom_Data		;DS:= Rom Data
	mov	si,Offset Wild_Intr_Msg	;Point to the wild interrupt message
	call	Disp_String		;Display message
	PopReg	<ds,si>			;Restore registers
	sti
RI1:	jmp	RI1

Reserved_Interrupt EndP

;----------------------------------------------------------------------
Reserved_Hardware_Interrupt Proc Far; (1_Jul_85)
;-----------------------------------------------
;	Reserved_Hardware_Interrupt is called when a hardware interrupt
; is received for which no interrupt driver is present.   It returns
; to the monitor ROM once it sends an END_OF_INTERRUPT to the intr
; controller.
;
Public	Reserved_Hardware_Interrupt

	Push	ax			;Save contents of register AX
	mov	al,End_of_Intr		;Send end-of-interrupt to...
	out	Interrupt_Ctrl,al	;...interrupt controller chip
	pop	ax			;Restore register contents
	iret

Reserved_Hardware_Interrupt ENDP


Monitor_Segment	EndS
		End
