Page	60,132
Title	-Calculator Icon -- Math Module
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 12_May_85
;
;
%Out	CalcMath.asm
page
;--------------------------------------------------------------------
; Equates (12_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Calc.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include	Calc.lit
	.list

csgn	equ	6		;change sign constant

page
;======================================================================
monitor_segment segment word public
;==================================
;
assume	cs:monitor_segment,ds:monitor_segment,es:monitor_segment

	extrn	rg:byte		;working register

;----------------------------------------------------------------------
; Fixed Data Area
;-----------------
;
caltbl	dw	offset	addop
	dw	offset	subop
	dw	offset	mulop
	dw	offset	divop


page
;--------------------------------------------------------------------
math Proc Near
;-------------
;	1) math routines
;		cl = operation code
;			0 = addition
;			1 = subtraction
;			2 = multiplication
;			3 = division
;		bx = pointer to left argument
;		si = pointer to right argument
;		di = pointer to result
;		on exit:  c = 1  <->  overflow
;
assume	cs:monitor_segment,ds:monitor_segment,es:monitor_segment
public	math

	push	bp
	mov	ch,0			;set pointer
	sal	cx,1			; to selected
	mov	bp,cx			; operation
	push	di			;save di
	mov	di,offset rg		;zero the
	mov	al,0			; working
	mov	cl,2*l+4		; register
	rep	stosb			; bytes
	pop	di			;restore di
	call	word ptr caltbl[bp]	;perform the operation
	sar	bp,1			;c=1 <-> overflow
	pop	bp
	ret

math		EndP

page
;--------------------------------------------------------------------
addop Proc Near
;--------------
;	1) add operation
;
	push	bx			;save addend1 pointer
	push	si			;save addend2 pointer
	push	di			;save sum pointer
	mov	dl,[bx].exp		;compare addend1 and
	sub	dl,[si].exp		; addend2 exponents
	jno	addop0			;no overflow -> addop0

	jge	addop5			;copy addend1 to sum
	jl	addop6			;copy addend2 to sum

addop0:	jge	addop1			;addend1 magn larger -> addop1
	neg	dl			;negate exp diff
	xchg	bx,si			;switch addend1 and addend2

addop1:	cmp	dl,l			;if exponent difference > l places
	jg	addop5			; then copy addend1 to sum
	mov	al,[bx].sgn		;copy addend1 sign
	mov	[di].sgn,al		; to sum sign
	mov	al,[bx].exp		;copy addend1 exponent
	mov	[di].exp,al		; to sum exponent
	push	si			;move
	push	di			; the
	mov	si,bx			; larger
	mov	di,offset rg+l+3	; magnitude
	mov	cl,l			; mantissa

	rep	movsb			; to the
	pop	di			; working
	pop	si			; register
	mov	dh,0			;calculate argument
	mov	di,offset rg+l+3	; offset
	sub	di,dx			;set up arguments
	inc	dx			; for addition
	mov	cl,l			; or subtraction
	mov	al,[bx].sgn		;compare argument signs
	cmp	al,[si].sgn		; different -> addop2 (subtraction)
	jne	addop2			; same -> proceed with

	call	addreg			; addition
	jmp	short addop3

addop2:					; si = minuend pointer
					; di = difference pointer
	call	subreg			;subtract sutrahend from minuend
	jnc	addop3			;difference positive -> addop3

	mov	cl,l			;negate sum
	add	cl,dl			; mantissa in
	call	negreg			; working register
	pop	di			;restore sum pointer
	xor	[di].sgn,csgn		;toggle sum sign
	jmp	short addop4

addop3:	pop	di			;restore sum pointer
addop4:	pop	si			;restore addend2 pointer
	pop	bx			;restore addend1 pointer
	jmp	short mulop3		;do common end for operations

addop5:	mov	si,bx			;move larger magnitude
addop6:	mov	cl,l+2			; addend to
	rep	movsb			; the sum
	pop	di			;restore sum pointer
	pop	si			;restore addend2 pointer
	pop	bx			;restore addend1 pointer
	ret

addop		EndP

;--------------------------------------------------------------------
subop Proc Near
;--------------
;	1) subtract operation
;
	xor	[si].sgn,csgn		;toggle subtrahend sign
	call	addop			; and add
	xor	[si].sgn,csgn		;toggle subtrahend sign back again
	ret

subop	EndP

page
;--------------------------------------------------------------------
mulop Proc Near
;--------------
;	1) multiply operation
;
	mov	al,[bx].exp		;add exponents
	add	al,[si].exp		; and do common multiply and
	call	mdexsg			; divide initialization
	jnc	mulop0			;no over or under flow -> mulop0
	ret

mulop0:	push	si			;save arg 2 pointer
	push	di			;save result pointer
	mov	cl,l			;this
	mov	dl,2*l-1		; code
	mov	di,offset rg+3		; is

mulop1:	push	si			; composed
	push	di			; of
	push	cx			; two
	push	dx			; nested
	mov	cl,l			; iterations

mulop2:	push	si			;the
	push	di			; outer
	push	cx			; most

	mov	al,[bx]			; iteration
	mul	[si]			; indexes
	aam				; arg 1's
	mov	si,offset rg		; digits
	mov	[si],ax			;the
	mov	cl,2			; inner
	call	addreg			; most

	pop	cx			; iteration
	pop	di			; indexes
	pop	si			; arg 2's
	dec	dx			; digits
	inc	si			; and
	inc	di			; multiplies
	loop	mulop2			; the two

	pop	dx			; selected
	pop	cx			; digits
	pop	di			; and
	pop	si			; adds
	inc	bx			; their
	dec	dx			; product
	inc	di			; into the
	loop	mulop1			; result register

	pop	di			;restore result pointer
	pop	si			;restore arg2 pointer
mulop3:	jmp	short endop		;do common end for operations

mulop		EndP

page
;--------------------------------------------------------------------
divop Proc Near
;--------------
;	1) divide operation
;
	push	si			;save divisor pointer
	push	di			;save result pointer
	mov	di,offset rg+l+2	;move
	mov	si,bx			; dividend
	mov	cl,l			; to working
	rep	movsb			; register

	pop	di			;restore divisor pointer
	pop	si			;restore arg2 pointer
	mov	al,[bx].exp		;subtract exponents
	sub	al,[si].exp		; and do common multiply and
	call	mdexsg			; divide initialization
	jnc	divop0			;no over or under flow -> divop0
	ret

divop0:	push	di			;this
	mov	di,offset rg+l+2	; code
	mov	cl,l+2			; is
	mov	dl,1			; two

divop1:	push	cx			; iterations
	push	di			;the

divop2:	mov	cl,l			; inner most iteration
	call	subreg			; subtracts
	jc	divop3			; the shifted subtahend

	inc	byte ptr l+1[di]	; from
	cmp	byte ptr l+1[di],10	; the
	jne	divop2			; minuend

	pop	di			; and
	pop	cx			; counts
	pop	di			; the number
	jmp	short endop0		; of subtractions

divop3:	push	si			;this count is
	mov	cl,l			; used to
	call	addreg			; build up

	pop	si			; the difference
	pop	di			; digit by digit
	dec	di			;the outer most
	pop	cx			; iteration

	loop	divop1			; does the
	pop	di			; digit shifting

divop		EndP

page
;--------------------------------------------------------------------
endop Proc Near
;--------------
;	1) normal ending for all operations
;
	push	si			;save arg2 pointer
	push	di			;save result pointer
	call	norm			;find msd of result
	jcxz	endop1			;result = 0 -> endop1

	sub	di,l-2			;if 1st truncated
	mov	cl,l+1			; digit is >= 5
	cmp	byte ptr -1[di],5	; then round
	cmc				; up the result mantissa
	call	increg			;find msd of result
	sub	di,l-2			;if last
	mov	cl,l+1			; digit is = 9
	cmp	byte ptr [di],9		; then round
	cmc				; up the result mantissa
	call	increg			;find msd of rounded result
	mov	si,di			;save in source index
	sub	cl,2*l			;set up cx for exponent adjust
	pop	di			;restore result pointer
	add	[di].exp,cl		;adjust result exponent
	jno	endop3			;no over or under flow -> endop3
	jl	endop2			;underflow -> endop2
	pop	si			;restore arg2 pointer
endop0:	jmp	short setovf		;overflow to result
endop1:	pop	di			;restore result pointer
endop2:	pop	si			;restore arg2 pointer
	jmp	short setzer		;zero to result

endop3:	push	di			;save result pointer
	sub	si,l-2			;move mantissa from
	mov	cl,l			; the working register
	rep	movsb			; to the result register

	pop	di			;restore result pointer
	pop	si			;restore arg2 pointer
	mov	cl,lfx			;can
	cmp	[di].exp,cl		; the
	jg	endop0			; rounded
	jl	endop5			; result
	mov	al,9			; be
	push	di			; displayed
	add	di,l-1			; with
	std				; lfx
	rep	scasb			; digits

	cld				; without
	pop	di			; overflow?
	jcxz	endop4			; yes

	ret				;  -> return
endop4:	cmp	rg+2*l+3-lfx,5		; no

	jge	setovf			;  -> setovf
endop5:	ret

endop		EndP

page
;--------------------------------------------------------------------
mdexsg Proc Near
;---------------
;	1) calculate exponent and sign for mul and div operations
;		on exit:  c = 1 <-> overflow
;
	jo	mdexs1			;exp over or under flow -> mdexs1
	mov	[di].exp,al		;resultant exponent to destination
	mov	ah,'+'			;sign of
	mov	al,[si].sgn		; result is
	cmp	al,[bx].sgn		; plus if
	je	mdexs0			; both argument
	mov	ah,'-'			; signs are

mdexs0:	mov	[di].sgn,ah		; the same
	clc				; minus otherwise
	ret

mdexs1:	jle	setzer			;underflow -> setzer

mdexsg		EndP

; Fall thru to 'setovf' ...

page
;--------------------------------------------------------------------
setovf Proc Near
;---------------
;	1) set operation result to overflow
;		(NOTE: dropped into from 'mdexsg')
;
	inc	bp			;indicate overflow

setovf		EndP

; Fall thru to 'setzer' ...

;--------------------------------------------------------------------
setzer Proc Near
;---------------
;	1) set operation result to zero
;		on exit al = 0
;		(NOTE: dropped into from 'setovf')
;
	public	setzer

	push	di			;save result pointer
	mov	[di].sgn,'+'		;sign of zero is positive
	mov	[di].exp,-128		;most negitive exponent
	mov	cx,l			;set all
	mov	al,0			; mantissa
	rep	stosb			; bytes to zero

	pop	di			;restore result pointer
	stc
	ret

setzer		EndP

;--------------------------------------------------------------------
increg Proc Near
;---------------
;	1) increment register if carry = 1
;		di = pointer to lsb of reg
;		cx = length of reg
;	2) on exit:  c = 1 <-> overflow
;	3) then fall thru to normalize
;
	jnc	incrg0			;increment
	mov	al,[di]			; the destination
	inc	al			; register
	aaa				; if the carry

	stosb				; carry bit is set
	loop	increg			; on entry
incrg0:

increg		EndP

;Fall thru to normalize

;--------------------------------------------------------------------
norm Proc Near
;-------------
;	1) normalize (NOTE: dropped into from 'increg'
;		on exit cx = 0 <--> mantissa = 0
;
	mov	di,offset rg+2*l+3	; find
	mov	al,0			; offset
	mov	cl,2*l+2		; of the
	std				; leading

	rep	scasb			; non-zero
	cld				; digit
	ret

norm		EndP

page
;--------------------------------------------------------------------
addreg Proc Near
;---------------
;	1) add registers
;		si = pointer to lsb of source reg
;		di = pointer to lsb of destination reg
;		cx = source length
;		dl = destination length - source length
;	2) on exit:  c = 1 <-> overflow
;
	clc				;add
addrg0:	lodsb				; source
	adc	al,[di]			; register
	aaa				; to destination
	stosb				; register

	loop	addrg0			;place sum
	mov	cl,dl			; in destination
	jcxz	subrg3			; register
	jmp	short increg		; propagate any carry

addreg		EndP

page
;--------------------------------------------------------------------
subreg Proc Near
;---------------
;	1) subtract registers
;		si = pointer to lsb of source reg
;		di = pointer to lsb of destination reg
;		cx = source length
;		dl = destination length - source length
;	2) on exit:  c = 1 <-> negative result
;
	push	di			; save registers for caller
	push	si
	clc				;subtract
subrg0:	mov	al,[di]			; source
	sbb	al,[si]			; register from
	aas				; destination
	stosb				; register

	inc	si			;place
	loop	subrg0			; difference
	mov	cl,dl			; in
	jcxz	subrg2			; destination

subrg1:	jnc	subrg2			; register
	mov	al,[di]			;destination
	dec	al			; register is
	aas				; dx digits longer
	stosb				; than source

	loop	subrg1			; register

subrg2:	pop	si			; restore registers for caller
	pop	di

subrg3:	ret

subreg		EndP

;--------------------------------------------------------------------
negreg Proc Near
;---------------
;	1) negate register  ( 10's complement )
;		di = pointer to lsb of reg
;		cx = length of reg
;
	clc				;form the
negrg0:	mov	al,0			; ten's

	sbb	al,[di]			; complement of
	aas				; destination
	stosb				; register and
	loop	negrg0			; place it there
	ret

negreg		EndP

Monitor_Segment	EndS
		End
