Page	60,132
Title	-Calculator Icon -- Display Module
;
;	Copyright (c) 1985
;	Morrow Designs, Inc.
;	San Leandro, California
;
;	Last Update 31_Oct_85
;
;
%Out	CalcDsp.asm
page
;--------------------------------------------------------------------
; Equates (12_May_85)
;--------------------
;
; Include Files
;--------------
;	Rom.lit
;	Calc.lit
;
	.xlist
	Include	..\Rom\Rom.lit
	Include	Calc.lit
	.list

ldspl	equ	10*100h+19		;(11,19) left  display line
ldsop	equ	10*100h+21		;(11,21) left  display operation
ldspm	equ	10*100h+22		;(11,22) left  display memory flag
lmvln	equ	12*100h+19		;(13,19) left  memory value line
vbrd	equ	07ch			;vertical     border character code
hbrd	equ	02dh			;horizontal   border character code
ltee	equ	07ch			;left  tee    border character code
rtee	equ	07ch			;right tee    border character code
rcbrd	equ	07ch			;right corner border character code
lcbrd	equ	07ch			;left  corner border character code
normal	equ	007h			;video attribute for normal video
reverse	equ	70h			;video attribute for reverse video
eos	equ	000h			;end of string code

lbargl	equ	0a00h
lbargr	equ	0a13h

lupl	equ	0000h			;upper left  corner of left  tape
lbtr	equ	0a16h			;lower right corner of left  tape

page
;======================================================================
monitor_segment segment word public
;==================================
;
assume	cs:monitor_segment,ds:monitor_segment,es:monitor_segment

	extrn	dflags:byte		;iconio module
	extrn	winpos:byte
	extrn	dspim:byte
	extrn	put_string_imm:near

	extrn	DS_to_Rom_Data:Near	;Set DS to Rom Data
	extrn	Scroll_Up:Near		;Scroll Up one Line
	extrn	Put_Chr:near

page
;--------------------------------------------------------------------
dspeln Proc Near
;---------------
;	1) display value in entry line
;
assume	cs:monitor_segment,ds:monitor_segment,es:monitor_segment
public	dspeln

	mov	dx,ldspl		;set up left window argument
	jmp	short regdsp

dspeln		EndP

;--------------------------------------------------------------------
dspmln Proc Near
;---------------
;	1) display value in memory line
;
public	dspmln

	mov	dx,lmvln		;set up left window argument

dspmln		EndP

page
;--------------------------------------------------------------------
regdsp Proc Near
;---------------
;	1) register display routine
;		dh = row number
;		dl = left window column number
;
	call	rhtadj			;adjust if right window
	mov	si,offset dspim		;move
	mov	cx,20			; display

regds0:	lodsb				; to
	call	put_chr			;output the char (note dl=dl+1)
	dec	dx			; line (cancel put_chr's dl+1)
	dec	dx			; and once more to L-shift next digit
	loop	regds0			; ram
	ret

regdsp		EndP

;--------------------------------------------------------------------
dspop Proc Near
;--------------
;	1) display operation flag character
;		al = character
;
public	dspop

	mov	dx,ldsop		;write operation character
	jmp	short dspflg		; to video ram

dspop		EndP

;--------------------------------------------------------------------
dspmc Proc Near
;--------------
;	1) display or blank m flag character
;		al = character
;
public	dspmc

	mov	dx,ldspm		;write "m" or blank to video ram

dspmc		EndP

page
;--------------------------------------------------------------------
dspflg Proc Near
;---------------
;	1) display flag character
;		al = character
;		dh = row number
;		dl = left window column number
;
	call	rhtadj			;adjust if right window
	call	put_chr			;output the char
	ret

dspflg		EndP

;--------------------------------------------------------------------
rhtadj Proc Near
;---------------
;	1) right window address adjustment routine and set up bx
;
	add	dl,winpos		;adjust for right window

rhtad0:	mov	bx,normal		; image
	call	put_att			;setup attributes
	ret

rhtadj		EndP

;--------------------------------------------------------------------
wrwin Proc Near
;--------------
;	1) write fixed window display
;
public	wrwin

	mov	bx,normal		;get normal attributes (note bh will =0)
	call	put_att			;setup attributes

	cmp	winpos,17		;is 40 column (right) screen?
	jl	short wrlw00		;no (winpos=0), put up for left 80/40 col

	call	put_string_imm		;display fixed part of 80 right window
	db	30,56,0,29,38		;iconio message 38 (vertical border)
	db	30,57,11,29,39		;   "      "    39 (horizontal border)
	db	30,77,12,29,40		;   "      "    40 (mv legend)
	db	30,57,13,29,39		;   "      "    39 (horizontal border)
	db	eos
	ret

wrlw00:	call	put_string_imm		;display fixed part of 80/40 left window
	db	30,23,0,29,38		;iconio message 38 (vertical border)
	db	30,0,11,29,39		;   "      "    39 (horizontal border)
	db	30,20,12,29,40		;   "      "    40 (mv legend)
	db	30,0,13,29,39		;   "      "    39 (horizontal border)
	db	eos
	ret

wrwin		EndP

page
;--------------------------------------------------------------------
dsperr Proc Near
;---------------
;	1) display the error message in the entry line
;
public	dsperr
	push	bx			; set up reverse video attribute
	mov	bx,reverse
	call	Put_Att

	cmp	winpos,17		;is 40 column (right) screen?
	jl	short dsper0		;no (winpos=0), put up for left 80/40 col

	call	put_string_imm		;display right 80 col error message
	db	30,57,10,29,41,eos
	pop	bx
	ret

dsper0:	call	put_string_imm		;display left 80/40 col error message
	db	30,0,10,29,41,eos
	pop	bx
	ret

dsperr		EndP

;--------------------------------------------------------------------
dspblk Proc Near
;---------------
;	1) display blanks in the entry line
;
public	dspblk

	mov	al,0			;clear function
	mov	cx,lbargl		;set up left
	mov	dx,lbargr		; line arguments
	jmp	short scrol0

dspblk		EndP

;--------------------------------------------------------------------
Scroll Proc Near; (11_Jul_85)
;----------------------------
; scroll or clear calculator tape
;	al = 1  -->  scroll
;	al = 0  -->  clear
;
public	scroll

	mov	cx,lupl			;set up left
	mov	dx,lbtr			;window arguments

scrol0:	add	cl,winpos		;adjust for right
	add	dl,winpos		;window arguments
	mov	bh,normal		;reverse video attribute

	push	ds
	call	DS_to_Rom_Data		;DS:= Rom Data (for Scroll Routine)
	call	Scroll_Up		;Scroll Up one Line
	pop	ds
	ret				;Return

scroll		EndP

page
;--------------------------------------------------------------------
put_att proc near
;----------------
;	1) store attributes in 'dflags' (segment data) for put_chr to process
;	   bx contains attributes of char to be printed
;
public	put_att

	push	ax			;save ax
	mov	al,0h			;load normal
	cmp	bl,7h			;test for normal?
	je	wrflag			;yes, write flag

	mov	al,2h			;no, load reverse
wrflag:	mov	dflags,al		;store attributes
	pop	ax			;restore ax
	ret

put_att EndP

monitor_segment	EndS
		End
