	PAGE	,132
	TITLE	Z-150 Disk Boot

;**********************************************************************
;	
;                         --------------------
;------------------------- Disk Boot Routines -------------------------
;                         --------------------
;
;	      Copyright (C) 1983, by Zenith Data Systems
;
;**********************************************************************

MONITOR_SEGMENT SEGMENT WORD PUBLIC

	ASSUME	CS:MONITOR_SEGMENT, DS:ROM_DATA, ES:NOTHING

	INCLUDE	../ROM/ROM.LIT
	INCLUDE ../ROM/IO.LIT
	INCLUDE ../ROM/INTR.LIT
	INCLUDE ../KEYBOARD/KEYBOARD.LIT
	INCLUDE	DISK.LIT
	INCLUDE DISK.EXT

	EXTRN	DISK_READ:NEAR, DISK_RESET:NEAR, DISPLAY_DISK_ERROR:NEAR
	EXTRN	MFM_150:NEAR, GET_KEY_STATUS:NEAR, GET_KEY_BUFF:NEAR
	EXTRN	CRLF:NEAR, DATA_SEGMENT:WORD


;**********************************************************************
; BOOT_INTERRUPT:
;
;	Boot_Interrupt is called to actually boot an operating system
; driver from disk, and to transfer control to it.  If errors are
; encountered, it will print out an error message and transfer control 
; to the MFM150 monitor instead.
;
; Note: This routine will not return to the caller - either the boot
; 	code will be executed, or the MFM150 monitor will be run.
;**********************************************************************
BOOT_INTERRUPT PROC FAR
	PUBLIC	BOOT_INTERRUPT
	MOV	DS,DATA_SEGMENT		;Point to the current data segment
	CALL	DISK_BOOT		;Attempt to read boot code from disk
	JNC	BI2			;No error - transfer to boot code
	TEST	AH,AH			;Was the boot aborted by the user?
	JE	BI1			;Yes - exit from the boot routine
	CALL	DISPLAY_DISK_ERROR	;Display error message for this err
BI1:	JMP	MFM_150			;Transfer control to the monitor
BI2:	CALL	CRLF			;Display blank lines following boot
	CALL	CRLF			;...to indicate successful boot
	MOV	AL,111111B		;Now, get code to turn LEDs off
	OUT	DIAG_LEDS,AL		;...all off since all OK
	MOV	DL,BOOT_DRIVE		;Get boot drive as parm to boot code
	MOV	DH,0			;Set head number to 0
	JMP	BOOT_CODE		;Boot successful, transfer to O.S.
BOOT_INTERRUPT ENDP



;**********************************************************************
; DISK_BOOT:
;
;	Disk_Boot reads the boot information from the specified drive
; into memory at 'BOOT_CODE'.  If an error occurs during the read,
; an error flag and code will be returned to the caller.  The disk
; booted is contained in the 'BOOT_DRIVE' global variable.  Also
; note that, unlike the other disk routines, this routine automatically
; performs retries in the event of disk errors.
;
; Output:
;	CY: Error flag.  If an error occurs during the boot, then 
;	    the carry flag will be set.
;	AH: Error code.  If the carry flag is set, then AH will
;	    contain a disk error code as documented for the GET_DISK
;	    STATUS call.  As an additional status, an error code of
;	    00H upon return means that the boot was aborted by the
;	    user entering an ESCAPE or SHIFT-BREAK.
;	    If the carry flag is reset upon return, then the contents
;	    of AH will not be informative.
;**********************************************************************
DISK_BOOT PROC NEAR
	PUBLIC	DISK_BOOT
	PUSHREG	<BX,CX,DX,SI,ES>
	STI				;Permit disk interrupts to occur
	CLD				;Use forward string moves
	MOV	SI,DEFAULT_RETRIES	;Maximum number of retries permitted
	CMP	BOOT_DRIVE,0FFH		;Is any drive selected?
	JE	DB4			;No, return to caller
DB1:	CALL	GET_KEY_STATUS		;Check to see if a key was pressed
	JZ	DB2			;No key pressed - continue reading
	CALL	GET_KEY_BUFF		;Read a key from the keyboard buffer
	CMP	AX,ESC_CODE		;Is this an ESCAPE?
	JE	DB3			;Yes - abort disk read
	CMP	AX,BREAK_CODE		;Is this a CTRL-BREAK?
	JE	DB3			;Yes - abort the disk boot
DB2:	MOV	BX,INTERRUPT_SEGMENT	;Point BX to the disk boot segment
	MOV	ES,BX
	MOV	BX,OFFSET BOOT_CODE	;Point now to the actual boot buffer
	MOV	DL,BOOT_DRIVE		;Set boot drive in DL
	MOV	DH,0			;Set side (head) to 0
	MOV	CX,(0 SHL 8) OR 1	;Read track 0, sector 1
	MOV	AX,(2 SHL 8) OR 1	;Set up to read one sector
	INT	DISK_IO_INTR		;Read the boot sector
	JNC	DB4			;Read worked OK - return
	DEC	SI			;Decrement retry count
	STC				;[Set error flag in case timeout]
	JZ	DB4			;Retried too many times: return error
	CALL	DISK_RESET		;Reset disk controller/drives
	JMP	SHORT DB1		;Loop for another retry
DB3:	MOV	AH,0			;Set return status to user-abort
	STC				;Set error flag, as well
DB4:	POPREG	<ES,SI,DX,CX,BX>
	RET
DISK_BOOT ENDP



MONITOR_SEGMENT ENDS

	END
