/******************************************************************************
 *
 * FILE2TAPE - convert a file to simh's mag tape image.
 *
 * Mainly useful for converting FST or TAR archives to a mag tape image
 *
 * I use a tape record length of 10240 bytes because that is how FST
 * appears to write tapes.
 * 
 * Ken Cornetet - ken@cornetet.org
 *
 * Usage: file2tape InputFile OutputFile
 *
 * This is public domain code. You may use this file for any purpose you choose.
 *
 *
 ******************************************************************************/

#include <stdio.h>
#include <time.h>
#include <fcntl.h>
#include <memory.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>

#ifndef O_BINARY
#define O_BINARY 0
#endif


main( int argc, char **argv )
{
	int i, fdin, fdout;

	char ibuf[10240];

    char reclen[4] = "\x00\x28\x00\x00";
    char mark[4] = "\x00\x00\x00\x00";

	if( (fdin = open(argv[1], O_RDONLY|O_BINARY)) < 0 ) {
		perror(argv[1]);
		exit(1);
	}

	if( (fdout = open(argv[2], O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, 0666)) < 0 ) {
		perror(argv[2]);
		exit(1);
	}


	while( read(fdin, ibuf, 10240) > 0 ) {
        write(fdout, reclen, 4);
        write(fdout, ibuf, 10240);
        write(fdout, reclen, 4);
	}

    write(fdout, mark, 4);
    write(fdout, mark, 4);

	close(fdin);
    close(fdout);
}

