
/* Declarations related to UCSD P-System file systems */


/* Size of each UCSD disk block, 512 or 0x200 bytes */

#define UCSD_BLK_SIZE          512


/* The maximum number of directory entries */

#define UCSD_MAX_DIR_ENTRIES   77


/* Kinds of P-System files */

#define FK_UNTYPED      0
#define FK_XDSK         1
#define FK_CODE         2
#define FK_TEXT         3
#define FK_INFO         4
#define FK_DATA         5
#define FK_GRAF         6
#define FK_FOTO         7
#define FK_SECUDIR      8


/* Date in 16 bits: year 0..128, day 0..31:5, month 0..15:4 */

#define ucsdYEAR(x)        ((x>>9) & 0x7F)
#define ucsdDAY(x)         ((x & 0x01F0) >> 4)
#define ucsdMONTH(x)        (x & 0x0F)


/* The volume ID entry, the first entry in block 2 */

typedef struct {        /* 22 bytes */
    short firstBlk;     /* first block of volume */
    short lastBlk;      /* */
    short fileKind;     /* */
    char  volName[8];   /* volume name 1+7 */
    short eovBlk;       /* last true block of volume */
    short numFiles;     /* num files in dir */
    short loadTime;     /* time of last access */
    short lastBoot;     /* most recent date setting */
} ucsdDirRoot;


/* Each file has one of these */

typedef struct {         /* 26 bytes */
    short firstBlk;      /* first and last block of file */
    short lastBlk;
    short fileKind;      /* FK_xx */
    char  fileName[16];  /* filename 1+15 */
    short lastByte;      /* number of bytes in last block 1..512 */
    short lastAccess;    /* */
} ucsdDirEntry;


/* Char used in P-System text files as a special escape for compressing spaces */

#define DLE 16


/* Prototypes */


/* readvol.c */
USHORT ucsdReadVolInfo( FILE *infp, ucsdDirRoot *root );

/* readinfo.c */
USHORT ucsdReadFileInfo( FILE *infp, ucsdDirEntry *dir );

/* pascal.c */
void unPascalStr( char *str );

/* calcfree.c */
short ucsdCalcFreeSpace( ucsdDirRoot *dirRoot, ucsdDirEntry *dir );

/* printvol.c */
USHORT ucsdPrintVolInfo( ucsdDirRoot *dirRoot, short freespace );

/* typestr.c */
char *ucsdTypeStr( short kind );
char *ucsdMonthStr( short kind );

/* settime.c */
void ucsdSetTimeStamp( char *filename, ucsdDirEntry *eachEntry );

