                                                          
/* rad50asc.c - Convert RAD-50 to ASCII */
/* Copyright 1994 Syndesis Corporation, by John Foust <jfoust@threedee.com> */
/* March 17, 1998 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "rt11decl.h"
#include "rt11vars.h"


/* Convert one 16-bit Radix-50 three-char to ASCII */

void rad50ToAscii( USHORT rad50, char *str )
{
USHORT each;
USHORT val;
USHORT ord;
char ch;


    /* From each RAD-50 value, we store three ASCII chars */
    for (each=0; each<3; each++) {

        val = rad50;

        /* Which of the three chars we're extracting */
        ord = 2 - (each % 3);
        while (ord-- > 0) {
            val /= 40;
        }
        /* Mask out unused bits */
        val %= 40;

        /* Map 0..39 to ASCII */
        if (val==0)                      ch = ' ';          /* space */
        else if (val >= 1 && val <= 26)  ch = val-1+'A';    /* printable alpha A..Z */
        else if (val == 27)              ch = '$';          /* dollar */
        else if (val == 28)              ch = '.';          /* period */
        else if (val == 29)              ch = ' ';          /* unused char, emit a space instead */
        else if (val >= 30 && val <= 39) ch = val-30+'0';   /* digit 0..9 */

        *str = ch;

        str ++;
    }

    /* Yes, we don't zero-terminate */
}

