
/* diskdecl.h - Shared declarations for tools that operate on disk images */


/* Determine the byte order of this machine */

/* Win32 or Linux, Intel order, needs no swapping of PDP-11 16-bit value */
#if defined(_MSC_VER) || defined(__linux__)
 #define INTEL_BYTE_ORDER
 #define SWAB(x)
/* Amiga, SGI, etc. */
#else
 #define MOTOROLA_BYTE_ORDER
 #define SWAB(x) x
#endif


/* Common types */

typedef unsigned short USHORT;

typedef int BOOL;

#define FALSE 0
#define TRUE 1


/* Error values */

#define TE_NOERROR      0
#define TE_BADREAD      1
#define TE_BADWRITE     2


/* dbprintf.c */
void dbPrintf( char *format, ... );

/* swab.c */
void mySwab( char *ptr );
void swabShort( short *shPtr );

/* getshort.c */
USHORT getShort( FILE *infp, short *val );

/* makent.c */
void makeWinNTname( char *str );

/* lower.c */
void strLower( char *str );

/* endian.c */
USHORT determineEndian( FILE *infp );

