/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.105] Created
* 28-Dec-85 | [1.264] Added code to support WM instruction
* 30-Dec-85 | [1.283] Now handle I/O check stop switch
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "stdio.h"
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "alerts.h"
#include "pr.h"
#include "print.h"
#include "alert.h"
#include "poll.h"
#include "ifetch.h"
#include "printers.h"

/*****************************************************************************
				1401 Simulator

			   Write Printer Instruction


			  Write Printer (One Address)
			  ---------------------------
Instruction format

Mnemonic	Op Code	I-address
--------        ------- ---------
W		2	III		

Function: This is the same as the write instruction, except the next 
instruction is taken from the I-address instead of from the next sequential
instruction address.  The program branch occurs after the data has been
written to the printer.

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		333

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			 Write Printer (No Address)
			 --------------------------
Instruction format

Mnemonic	Op Code	
--------        ------- 
W		2	

Function: Data is written to the printer from locations 201..332.

Word Marks:  Word marks are undisturbed

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		Ap		333

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_W
* Result: boolean
*       true if operation succeeded (excluding card reader errors)
*	false if operation failed
* Effect: 
*       Writes data in locations 201-332
****************************************************************************/

boolean inst_W()
    {
     tell_op(op_A);

     switch(I_cycle)
        { /* length dispatch */
	 case 1: /* Normal Write */
	 	if(!print(current_printer))
		   { /* failed */
		    alert(alert_printer);
		    return !IOcheck;
		   } /* failed */
		B_addr = 332;
		break;

        case 2: /* Write word marks */
		if(d_char != 60) /* BCD lozenge or ) */
		   { /* illegal */
		    alert(alert_process);
		    return false;
		   } /* illegal */
		if(!printwm(current_printer))
		   { /* failed */
		    alert(alert_printer);
		    return !IOcheck;
		   } /* failed */
		B_addr = 332;
		break;
	case 4: /* Write-and-branch */

		B_addr = I_addr;
		NI_addr = A_addr;

	 	if(!print(current_printer))
		   { /* failed */
		    alert(alert_printer);
		    return !IOcheck;
		   } /* failed */

		poll();
		break;

        case 5: /* Write word marks and branch */
		B_addr = I_addr;
		NI_addr = A_addr;

		if(d_char != 60) /* BCD lozenge or ) */
		   { /* illegal */
		    alert(alert_process);
		    return false;
		   } /* illegal */

		if(!printwm(current_printer))
		   { /* failed */
		    alert(alert_printer);
		    return !IOcheck;
		   } /* failed */
		poll();
		break;
	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */

     single_cycle_state = single_cycle_complete;
     tell_new_state("W");

     return true;
    }
