/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 28-Dec-85 | Created
*  2-Jan-92 | [1.5] <jmn> converted to C6.0
*****************************************************************************/

#include <stdio.h>
#include <boolean.h>
#include <string.h>
#include <fcntl.h>
#include <io.h>
#include <pr.h>
#include <printers.h>

FILE * input;
FILE * output;

boolean debug;
boolean pr64 = true;
boolean test_pr64 = false;

extern char * stpchr();

char filename[80];

/****************************************************************************
*                                     yes
* Inputs:
*       printobj * pr: The printer object
* Result: boolean
*       true, always
****************************************************************************/

boolean yes(printobj * prn)
    {
     return true;
    }

/****************************************************************************
*                                cmdline_help
* Effect: 
*       Prints out command line help
****************************************************************************/

void cmdline_help()
    {
     fprintf(stderr,"autocoder [options] filename\r\n");
     fprintf(stderr,"     Options are:\r\n");
     fprintf(stderr,"       -debug (-d)  enable verbose debug mode\r\n");
     fprintf(stderr,"       -test64      enables .ts directives in .cfg file\r\n");
    }

/****************************************************************************
*                                  openfile
* Inputs:
*       char * name: Base file name
* Result: boolean
*       true if open succeeded
*	false if open failed
* Effect: 
*       Opens the input file
****************************************************************************/

boolean openfile(char * name)
    {
     char * p;
     char fname[80];
     char basename[80];

     p = strchr(name,'.');

     if(p==NULL)
        { /* no dot */
	 strcpy(basename,name);
	 strcpy(filename,name);
	 strcat(filename,".lst");
	} /* no dot */
     else
        { /* dot */
	 strncpy(basename,name,name-p+1);
	 basename[name-p+1] = '\0';
	 strcpy(filename,name);
	} /* dot */
     
     input = fopen(filename,"r");
     if(input==NULL) 
        { /* no file */
	 fprintf(stderr,"Couldn't open input file %s\r\n",filename);
	 return false;
	} /* no file */

     return true;
    }

/****************************************************************************
*                                   cvtfile
* Effect: 
*       Reads lines from input, writes them to output with characters
*	converted
****************************************************************************/

void cvtfile(void)
    {
     char line[255];
     
     while(!feof(input))
        { /* read data */
	 fgets(line,255,input);
	 if(feof(input)) 
	    break;
	 (*current_printer->write_translated)(line,current_printer);
	} /* read data */
    }


/****************************************************************************
*                                    main
* Inputs:
*       int argc: Count of args
*	char * argv: vector of args
* Result: int
*	0 if success
*	!=0 if error
* Effect: 
*       Filters the input according to the 1401 character set conversion
****************************************************************************/

int main(argc,argv)
    int argc;
    char * argv[];
    {
     int i;

     input = stdin;
     output = stdout;

     setmode(fileno(stdin),O_BINARY);
     setmode(fileno(stdout),O_BINARY);

     /* process the keywords */

     i = 0;

     while ((++i)<argc)
        { /* process args */

/* -debug */

	 if(strcmp(argv[i],"-d") == 0 || strcmp(argv[i],"-debug") == 0)
	    { /* -debug */
	     debug = true;
	     continue;
	    } /* -debug */
     
/* -test64 */
	if(strcmp(argv[i],"-test64") == 0)
	   { /* -test64 */
	    test_pr64 = true;
	    continue;
	   } /* -test64 */

/* -help */
	if ((strcmp(argv[i],"-help") == 0) || (strcmp(argv[i],"?") == 0))
	   { /* -help */
	    cmdline_help();
	    return 0;
	   } /* -help */

/* - */
	if( strcmp(argv[i],"-") == 0) continue;

/* filename */

	if(argv[i][0] != '-')
	   { /* not a switch */
	    
	    if(openfile(argv[i]))
	    	continue;
	    else
	    	return 1;		/* failed */
	   } /* not a switch */
	} /* process args */

     /* We now have an open file; process it */

     current_printer->prn = stdout;
     current_printer->ready = yes;

     (*current_printer->init)(current_printer,test_pr64);

     cvtfile();
     
     fclose(output);
     fclose(input);

     return 0;

    }
