/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Nov-85 | [1.105] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"

/*****************************************************************************
				1401 Simulator

			   NOP Instruction


Instruction format

Mnemonic	Op Code	A-address	B-address
--------        ------- ---------       ---------
NOP		N	AAA		BBB

Function: This code performs no operation.  It can be substituted for the
operation code of any instruction to make that instruction ineffective.
It is commonly used in program modification to cause the machine to skip
over specific instructions.

A-addresses of the form %xx and @xx should also be changed to either to
N's with associated word marks or numeric characters so that indexing
and/or invalid core storage addressing problems cannot occur.

Word Marks:  The program operation resumes at the next operation code
identified by a word mark.

Note: If characters without word marks follow an N operation, these
characters enter the A- and B-field registers, for example:

	^N 1234 ^A xxxx

In this instance, the address registers after the operation would be:

	I-Add		A-Add		B-Add
	NSI		123		4bb

Address Registers After Operation:

I-Add		A-Add		B-Add
NSI		Ap		Bp

Chaining: 

*****************************************************************************/


/****************************************************************************
*                                  inst_NOP
* Result: boolean
*       true, always
* Effect: 
*       Executes NOP instruction, i.e., does nothing
****************************************************************************/

inst_NOP()
    {
     tell_op(op_A|op_B|op_d);

     single_cycle_state = single_cycle_complete;
     tell_new_state("NOP");
     return true;
    }
