/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Dec-85 | [1.249] Created
* 25-Feb-86 | [1.379] include <> => include ""
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "stdio.h"
#include "boolean.h"
#include "btypes.h"
#include "mem1401.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "ifetch.h"
#include "poll.h"
#include "pr.h"
#include "print.h"
#include "printers.h"

/*****************************************************************************
				1401 Simulator

			       Control Carriage


			       Control Carriage
			       ----------------
Instruction format

Mnemonic	Op Code	I-address  d-char
--------        ------- ---------  ------
CCB		F	III          x		

Function: This is the same as the control carriage instruction, except the
next instruction is taken from the I-address instead of from the next
sequential instruction address.  

Word Marks:  Word marks are not affected

Address Registers After Operation: (without indexing special feature)

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		???

NOTE: THIS HAS BEEN REINTERPRETED ACCORDING TO THE INDEXING SPECIAL 
FEATURES ADDENDUM:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		BI		NSI



Chaining: N/A

			       Control Carriage
			       ----------------
Instruction format

Mnemonic	Op Code	  d-char
--------        -------   ------
CC		F	  x

Function: This instruction causes the carriage to move as specified by
the d-character.  A digit causes an immediate skip to a specified
channel in the carriage tape.  An alphabetic character with a 12-zone
causes a skip to the specified channel after the next print operation.
An alphabetic character with an 11-zone causes an immediate space.  A
character with an A-zone causes a space after the next line is printed.  
If the carriage is in motion when a control carriage instruction is given,
the program stops until the carriage comes to rest.  At this point, the
new carriage action is initiated, and then the program advances to the next
instruction in storage.

Word Marks:  Word marks are undisturbed

Note: Care should be taken when punching channesl 9 and 12 of the carriage
control tape that these punches will not be ignored by line spacing (single,
double or triple).  This is necessary becasue the next tape channel sensed
resets the channel 9 and channel 12 indicators.  The next hole punched in the
carriage tape following a 9 or 12 punch should be at least 1+S spaces from the
9 or 12 punch (S equals the number of lines being spaced).

The time required to performa a skip operation to channle 9 or 12 must be
considered, so that the skip operation is completed when the test for the
channel 9 or channel 12 hole is performed.  If a Branch If Carriage Channel 9
(0r 12) instruction is executed before the skip operation to that channel hole
is complete, the program does not branch to the specified subroutine, but goes
to the next sequentional instruction.

When an immediate skip or immediate space instruction is used, an additional
space caused by the automatic carriage space taken after printing results.
When a skip after print or space after print instruction is sued, the
automatic space is not taken.

When the carriage tape is positioned at a channel 1 punch a skip to channel 1
immediate instruction (F1) does not move the paper.

Ŀ
 d    immediate skip to   d skip after print to   
Ĵ
 1    channel 1           A   channel 1           
 2    channel 2           B   channel 2           
 3    channel 3           C   channel 3           
 4    channel 4           D   channel 4           
 5    channel 5           E   channel 5           
 6    channel 6           F   channel 6           
 7    channel 7           G   channel 7           
 8    channel 8           H   channel 8           
 9    channel 9           I   channel 9           
 0    channel 10          ?   channel 10          
 #    channel 11          .   channel 11          
 @    channel 12          (   channel 12          
Ĵ
 d    immediate space     d   space after print   
Ĵ
 J    1 space             /   1 space             
 K    2 spaces            S   2 spaces            
 L    3 spaces            T   3 spaces            


Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		dbb		dbb

Chaining:  The instruction does not chain
	
*****************************************************************************/


/****************************************************************************
*                                   inst_CC
* Result: boolean
*       true if operation succeeded 
*	false if operation failed
* Effect: 
*       Requests channel control from the printer module
****************************************************************************/

boolean inst_CC()
    {
     boolean result;

     tell_op(op_A|op_d);

     switch(I_cycle)
        { /* length dispatch */
	 case 2: /* Normal CC */
		break;

	case 5: /* CC-and-branch */
		B_addr = I_addr;
		NI_addr = A_addr;

		poll();
		break;

	 default: /* illegal length */
	 	illegal_length();
	  	return false;
	} /* length dispatch */


     result = carriage(d_char,current_printer);

     single_cycle_state = single_cycle_complete;
     tell_new_state("CC");

     return result;
    }
