#define NOVIRTUAL
#include "..\printers.c"


/****************************************************************************
*                                  dev_init
* Inputs:
*       FILE * listing: output file
*	boolean test_pr64: true for full 64 char output
* Result: boolean
*       true, always
* Effect: 
*       Initializes the printer system with an existing file descriptor
****************************************************************************/

boolean dev_init(FILE * listing, boolean test_pr64)
    {
     current_printer->prn = listing;
     return true;
    }

/****************************************************************************
*                               write_translated
* Inputs:
*       char * buffer: String to write
* Result: void
*       
* Effect: 
*       Writes to the printer device
****************************************************************************/

void write_translated(char * buffer)
    {
     (*current_printer->write_translated)(buffer,current_printer);
    }

/****************************************************************************
*                                  dev_final
* Result: void
*       
* Effect: 
*       Performs device finalization
****************************************************************************/

void dev_final()
    {
     (*current_printer->final)(current_printer);
    }

/****************************************************************************
*                                  dev_close
* Result: void
*       
* Effect: 
*       CLoses the listing device
****************************************************************************/

void dev_close()
    {
     (*current_printer->close)(current_printer);
    }
