#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * bas3.c
 */
#include <stdio.h>
#include "bas.h"

#define	AND	0
#define OR	1
#define	XOR	2
#define LSHIFT	3
#define RSHIFT	4
#define MOD	5
#define ADD	6
#define SUB	7
#define MUL	8
#define DIV	9
#define POWER	10
#define EQ	11
#define NE	12
#define LT	13
#define LE	14
#define GE	15
#define GT	16

static	char	*otab[] = {
	"&",
	"|",
	"#",
	"<<".
	">>",
	"%",
	"+",
	"-",
	"*",
	"/",
	"^",
	"<=",
	"<>",
	"<",
	">=",
	">",
	"=",
	NULL
};

#define	LEN	0
#define UCASE	1
#define LCASE	2

static	char	*ftab[] = {
	"len(",
	"ucase$",
	"lcase$",
	NULL
};


expr(ep)
struct expr *ep;
{
	register n;

	if ((n=expr1(ep, 0)) != OK)
		err(ecode[n-1]);
}

expr1(ep, p)
register struct expr *ep;
{
	register n, op;
	struct expr e;

	if ((n=expr2(ep)) == OK) {
		while ((op=getop(p)) >= 0) {
			if ((n=expr1(&e, prio[op])) != OK) {
				scrap(ep);
				break;
			}
			if ((n=evaluate(op, ep, &e)) != OK) {
				scrap(ep);
				scrap(&e);
				break;
			}
		}
	}
	return (n);
}

expr2(ep)
register struct expr *ep;
{

	c = get();
	if (c == '(') {
		n = expr1(ep, 0);
		if (n != OK)
			return (n);
		if (get() != ')') {
			scrap(ep);
			return (MRPAR);
		}
		return (OK);
	}
	if (c == '+' || c == '-') {
		n = expr1(ep, HUGE);
		if (n == OK && c == '-') {
			if (ep->e_type > FLT) {
				scrap(ep);
				n = BSOP;
			} else if (ep->e_type == FLT)
				ep->e_flt = -ep->e_flt;
			else
				ep->e_int = -ep->e_int;
		}
		return (n);
	}
	if (c == '"') {
		ep->e_type = REF;
		ep->e_refp = cp;
		while ((c=*cp++) && c!='"')
			;
		if (c == 0)
			return (BADSTR);
		ep->e_refl = cp - ep->e_refp - 1;
		return (OK);
	}
	if (c == '.' || isdigit(c)) 
		return (number(c));

	--cp;
	if ((c=match(ftab)) < ???) {
		expr3(ep, c);
		/* ... */
	}

	/* Get variable */
}

evaluate(op, lp, rp)
{
	lt = lp->e_type;
	rt = rp->e_type;

	if (lt > FLT || rt > FLT)
		return(BSOP);

	if (op == POWER || lt != rt) {
		makefloat(lp);
		makefloat(rp);
	}
	if (lp->e_type == FLT)
		return (fevaluate(op, lp, rp));

	lv = lp->e_int;
	rv = rp->e_int;
	switch (op) {

	case ADD:
		lv += rv;
		break;

	case SUB:
		lv -= rv;
		break;

	case MUL:
		lv *= rv;
		break;

	case DIV:
		if (rv == 0)
			return(DIV0);
		lv /= rv;
		break;

	case AND:
		lv &= rv;
		break;

	case OR:
		lv |= rv;
		break;

	/* Relationals */
	}
	lp->e_int = lv;
	return (OK);
}

getop(p)
{
	register char *sp;
	register t;

	sp = cp;
	if ((t=match(otab))<=MOD && prio[t]>p)
		return (t);
	cp = sp;
	return (-1);
}

scrap(ep)
register struct expr *ep;
{
	if (ep->e_type == STR)
		free(ep->e_strp);
}

getv(ep)
register struct expr *ep;
{

	if (!isalpha(c = get()))
		return (NOVAR);
	id[0] = c;
	id[1] = 0;
	if (isdigit(c = *cp++)) {
		id[1] = c;
		c = *cp++;
	}
	t = FLT;
	if (c == '%') {
		t = INT;
		c = *cp++;
	} else if (c == '$') {
		t = STR;
		c = *cp++;
	}
	n = 0;
	if (c == '(') {
		do {
			if (n >= NDIMS)
				return (TMDIMS);
			if (s = expr1(ep, 0) {
				/* ... */
			}
			if (ep->e_type > FLT)
				/* .... */
			makeint(ep);
			d[n++] = ep->e_int;
		} while ((c = get()) == ',');
		if (c != ')')
			......
	} else
		--cp;

	sp = search(id, t, n, d);

	ep->e_type = sp->s_type;
	o = 0;
	for (i=0; i<n; ++i) {
		if (d[i] > sp->s_dims[i])
			/* out of range */
		if (i != 0)
			o *= sp->s_dims[i-1];
		o += d[i];
	}
	switch (sp->s_type) {

	case INT:
		ep->e_type = INT;
		ep->e_intp = &sp->s_dims[n] + o*sizeof(*ep->e_intp);
		break;

	case FLT:
		ep->e_type = FLT;
		ep->e_fltp = &sp->s_dims[n] + o*sizeof(*ep->e_fltp);
		break;

	case STR:
		ep->e_type = STR;
		ep->e_strp = &sp->s_dims[n] + o*sizeif(*ep->e_strp);
		break;
	}
	return (OK);
}

                                                                                   