#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * This file defines the format of the
 * relocatable binary file. Some of these
 * things will have to change (there is
 * no notion of the `bss' segment and no
 * place to put a symbol table).
 */

/*
 * Item types.
 */
#define	R_HEAD	0		/* Header */
#define	R_AREA	1		/* Area definition */
#define	R_SYM	2		/* Symbol definition */
#define	R_TEXT	3		/* Text */
#define	R_RELOC	4		/* Relocation */

struct	r_head
{
	char	r_type;		/* Item type */
	char	r_flag;		/* Flag byte */
	int	r_narea;	/* # of areas */
	int	r_nglob;	/* # of global symbols */
};

struct	r_area
{
	char	r_type;		/* Item type */
	char	r_flag;		/* Flag byte */
	addr_t	r_size;		/* Size of the area */
	char	r_id[NCPS];	/* Name */
};

struct	r_sym
{
	char	r_type;		/* Item type */
	char	r_flag;		/* Flag byte */
	addr_t	r_addr;		/* Address */
	char	r_id[NCPS];	/* Name */
};

struct	r_txtrel
{
	char	r_type;		/* Item type */
	char	r_nbyte;	/* Number of bytes */
	char	r_data[NDATA];	/* Actual data */
};
                                                                                                                                                                                                                                                                                                                                                                      