#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Modifications Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * yylex for lex tables
 */

#include <stdio.h>
#include <lex.h>


#define	ERROR	256	/* yacc's value */

#define	NBPW	16	/* bits per word */

tst__b(c, tab)
register int	c;
char		tab[];
{
	return(tab[(c >> 3) & 037] & (1 << (c & 07)) );
}

FILE	*lexin		= NULL;
struct	lextab	*_tabp	= {&lextab};

extern char	*llsave[];	/* Right-context buffer			*/
char	llbuf[100];		/* work buffer				*/
char	*llp1	= &llbuf[0];	/* pointer to next avail. in token	*/
char	*llp2	= &llbuf[0];	/* pointer to end of lookahead		*/
char	*llend	= &llbuf[0];	/* pointer to end of token		*/
char	*llebuf = &llbuf[sizeof llbuf];
int	lleof;
int	yylval	= 0;
int	yyline	= 0;

yylex()
{
	register c, st;
	int final, l, llk, i, base;
	register struct lextab *lp;
	char *cp;

	if (lexin == NULL)
		lexin = stdin;
loop:
	llk = 0;
	if (llset())
		return(0);		/* Prevent EOF loop	*/
	st = 0;
	final = -1;
	lp = _tabp;

	do {
		if (lp->lllook && (l = lp->lllook[st])) {
			for (c=0; c<NBPW; c++)
				if (l&(1<<c))
					llsave[c] = llp1;
			llk++;
		}
		if ((i = lp->llfinal[st]) != -1) {
			final = i;
			llend = llp1;
		}
		if ((c = llinp()) < 0)
			break;
		if ((cp = lp->llbrk) && llk==0 && tst__b(c, cp)) {
			llp1--;
			break;
		}
	} while ((st = (*lp->llmove)(lp, c, st)) != -1);


	if (llp2 < llp1)
		llp2 = llp1;
	if (final == -1) {
		llend = llp1;
		if (st == 0 && c < 0)
			return(0);
		if ((cp = lp->llill) && tst__b(c, cp)) {
			lexerror("Illegal character: %c (%03o)", c, c);
			goto loop;
		}
		return(ERROR);
	}
	if (c = (final >> 11) & 037)
		llend = llsave[c-1];
	if ((c = (*lp->llactr)(final&03777)) >= 0)
		return(c);
	goto loop;
}

llinp()
{
	register c;
	register struct lextab *lp;
	register char *cp;

	lp = _tabp;
	cp = lp->llign;				/* Ignore class		*/
	for (;;) {
		/*
		 * Get the next character from the save buffer (if possible)
		 * If the save buffer's empty, then return EOF or the next
		 * input character.  Ignore the character if it's in the
		 * ignore class.
		 */
		c = (llp1 < llp2) ? *llp1 & 0377 : (lleof) ? EOF : lexgetc();
		if (c >= 0) {			/* Got a character?	*/
			if (cp && tst__b(c, cp))
				continue;	/* Ignore it		*/
			if (llp1 >= llebuf) {	/* No, is there room?	*/
				lexerror("Token buffer overflow");
				exit(1);
			}
			*llp1++ = c;		/* Store in token buff	*/
		} else
			lleof = 1;		/* Set EOF signal	*/
		return(c);
	}
}

llset()
/*
 * Return TRUE if EOF and nothing was moved in the look-ahead buffer
 */
{
	register char *lp1, *lp2;

	for (lp1 = llbuf, lp2 = llend; lp2 < llp2;)
		*lp1++ = *lp2++;
	llend = llp1 = llbuf;
	llp2 = lp1;
	return(lleof && lp1 == llbuf);
}
                                                                                                                                                                                  