#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include "asm.h"

/*
 * This routine is called early in the
 * game to set up the hashtable. First all
 * buckets in the table are cleared.
 * Then a pass is made through the builtin
 * symbols, linking them into their hash
 * buckets. Finally the area list and `dda'
 * are set up.
 */
syminit()
{
	register struct sym  *sp;
	register struct area *ap;
	register h;
	struct sym **spp;

	spp = &symhash[0];
	while (spp < &symhash[NHASH])
		*spp++ = NULL;
	sp = &sym[0];
	for (;;) {
		h = hash(sp->s_id);
		sp->s_sp = symhash[h];
		symhash[h] = sp;
		if ((sp->s_flag&S_END) != 0)
			break;
		++sp;
	}
	ap = (struct area *) new(sizeof(struct area));
	ap->a_ap = NULL;
	areap = dda->s_addr = ap;
	ap->a_sp = dda;
	ap->a_flag = A_D|A_PRV|A_CON;
	ap->a_size = 0;
	ap->a_fuzz = 0;
}

/*
 * Lookup the name `id' in the hashtable.
 * If it is not found either return a
 * `NULL' (`f' is false) or a
 * pointer to a newly created hash table
 * entry (`f' is true).
 */
struct sym *
lookup(id, f)
char *id;
{
	register struct sym *sp;
	register h;

	h = hash(id);
	sp = symhash[h];
	while (sp != NULL) {
		if (symeq(id, sp->s_id))
			return (sp);
		sp = sp->s_sp;
	}
	if (f == 0)
		return (NULL);
	sp = (struct sym *) new(sizeof(struct sym));
	sp->s_sp = symhash[h];
	symhash[h] = sp;
	sp->s_type = S_NEW;
	sp->s_flag = 0;
	sp->s_area = NULL;
	sp->s_addr = 0;
	copy(sp->s_id, id, NCPS);
	return (sp);
}

/*
 * Mark all symbols of type `S_NEW'
 * global. Called at the end of pass
 * 0 if `-g'.
 */
symglob()
{
	register struct sym *sp;
	register i;

	for (i=0; i<NHASH; ++i) {
		sp = symhash[i];
		while (sp != NULL) {
			if (sp->s_type == S_NEW)
				sp->s_flag |= S_GBL;
			sp = sp->s_sp;
		}
	}
}

/*
 * Compare two symbol names.
 */
symeq(p1, p2)
register char *p1, *p2;
{
	register n;

	n = NCPS;
	do {
		if (*p1++ != *p2++)
			return (0);
	} while (--n);
	return (1);
}

/*
 * Given a pointer to a symbol name
 * compute and return the hash table
 * bucket.
 * The `sum of all the characters mod
 * table size' algorithm is perhaps
 * not the best.
 */
hash(p)
register char *p;
{
	register h, n;

	h = 0;
	n = NCPS;
	do {
		h += *p++;
	} while (--n);
	return (h&HMASK);
}

/*
 * Allocate a block of space.
 * Leave if there is no space left
 * at all.
 */
char *
new(n)
{
	register char *p;

	if ((p = malloc(n)) == NULL) {
		fprintf(stderr, "Out of space!\n");
		exit(1);
	}
	return (p);
}
                                                                                                                                                                                                                                                                                                                                                                             