#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 *	Non-recursive quick sort -- from "Software Tools" by
 *	Kernighan and Ritchie
 *
 *	Translated to C by Martin Minow.
 *
 */


#ifdef	pdp11
#define DEPTH	16			/* Good for 2**16 elements	*/
#else
#define	DEPTH	32			/* Good for 2**32 elements	*/
#endif

static	int	size;			/* Element size in bytes	*/

struct STACK {
	char	*lower;			/* Lower limit vector		*/
	char	*upper;			/* Upper limit vector		*/
};

qsort(array, nelements, element_size, compare)
char		*array;			/* Sort this array		*/
int		nelements;		/* How many elements		*/
int		element_size;		/* Size in bytes of an element	*/
int		(*compare)();		/* Called to compare stuff	*/
/*
 * Quickly (but non-recursively) sort the array.
 *
 *	compare_function returns -1, 0, +1 according to the relation
 *	between its two arguments (both pointers to array[] elements).
 */
{
	register struct STACK	*sp;	/* Stack pointer		*/
	struct STACK	stack[DEPTH];	/* Recursion emulator stack	*/

	register char	*lp;		/* Lower pointer		*/
	register char	*up;		/* Upper pointer		*/
	char		*cp;		/* Current pointer		*/

	/*
	 * Initialize stack pointer and "globalize" element_size
	 */
	size = element_size;
	sp = &stack;
	sp->lower = array;
	sp->upper = array + (size * (nelements - 1));
	/*
	 * While there's still stuff to do, ...
	 */
	while (sp >= stack) {
		if (sp->lower >= sp->upper)
			sp--;
		else {
			lp = sp->lower - size;
			up = sp->upper;
			cp = up;
			while (lp < up) {
				for (lp = lp + size;
						(*compare)(lp, cp) < 0;
						lp += size);
				for (up = up - size;
						up > lp;
						up -= size) {
					if ((*compare)(up, cp) <= 0)
						break;
				}
				if (lp < up)	/* Out of order pair	*/
					flip(lp, up);
			}
			flip(lp, sp->upper);
			if ((lp - sp->lower) < (sp->upper - lp)) {
				(sp+1)->lower = sp->lower;
				(sp+1)->upper = lp - size;
				sp->lower = lp + size;
			}
			else {
				(sp+1)->lower = lp + size;
				(sp+1)->upper = sp->upper;
				sp->upper = lp - size;
			}
			sp++;
		}
	}
}

static
flip(a, b)
char		*a;
char		*b;
/*
 * Exchange elements a and b
 */
{
	register char	*ap;
	register char	*bp;
	register int	temp;
	int		nbytes;

	ap = a;
	bp = b;
	for (nbytes = size; --nbytes >= 0;) {
		temp = *ap;
		*ap++ = *bp;
		*bp++ = temp;
	}
}

                                                                    