#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * bas4.c
 */
#include <stdio.h>
#include "bas.h"

int	col;
int	eflag;
int	qflag;

match(mtp)
char **mtp;
{
	register char *p1, *p2;
	int c1, c2, n;

	n = 0;
	while(p1 = *mtp++) {
		p2 = cp;
		while (c1 = *p1++) {
			while ((c2 = *p2++)==' ' || c2=='\t')
				;
			if (c1 != c2)
				break;
		}
		if (c1 == 0) {
			cp = p2;
			break;
		}
		++n;
	}
	return (n);
}

chlno(n)
register n;
{
	if (n < MINLNO || n > MAXLNO)
		err("Illegal line number");
}

getln(c)
{
	register n;

	n = getn(c);
	chlno(n);
	return (n);
}

getn(c)
register c;
{
	register n;

	if (c < 0)
		c = get();
	n = 0;
	while (isdigit(c)) {
		n = 10*n + c - '0';
		c = *cp++;
	}
	--cp;
	return (n);
}

err(s)
char *s;
{
	if (slfp != NULL)
		fclose(slfp);
	if (col != 0)
		put('\n');
	if (lp != NULL)
		printf("%d: ", lp->t_lno);
	printf("%s!\n", s);
	if (qflag)
		exit(1);
	++eflag;
	reset();
}

get()
{
	register c;

	while ((c = *cp++)==' ' || c=='\t')
		;
	return (c);
}

put(c)
register c;
{
	putchar(c);
	if (c == '\b') {
		if (col != 0)
			--col;
	} else if (c == '\n')
		col = 0;
	else
		++col;
}

puts(s)
register char *s;
{
	register c;

	while (c = *s++)
		put(c);
}

putn(n)
register n;
{
	register q;

	if (n < 0) {
		put('-');
		n = -n;
	}
	if (q = n/10)
		putn(q);
	put(n%10 + '0');
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    