#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *			T O D A Y
 *
 *
 * Full blown today program
 *
 * The output of this program is a text string describing the current
 * date.
 *
 * Usage for all operating systems:
 *
 *      today                   Prints information about this date.
 *
 *      today -                 Reads date strings from the standard
 *	today x			input, writing information on the
 *                              standard output.
 *
 *      today datestring        Prints information about the indicated
 *                              date.
 *
 * Datestring format:
 *      {+cc}yymmddhhmmss       cc      Century number (preceeded by +)
 *                              yy      Year (2 digits only)
 *                              mm      Month, January = 1
 *                              dd      Day in the month.
 *                              hh      Hour (24-hour format)
 *                              mm      Minutes
 *                              ss      Seconds
 * Note: hours, minutes, and seconds are optional.
 *
 * The program allows non-numeric seperators between each of the
 * fields:  "78.10.10" is acceptable.
 *
 * The algorithms are only valid for the Gregorian calender.
 *
 * Define UNIX for "native" Unix
 */


#define LINEWIDTH       72              /* Width of line                */

#ifdef	UNIX
#define COOKIEPROGRAM   "/usr/martin/bin/cookie"
#define	UNIXVMS
#define NULL	(0)
#else
#include <stdio.h>
#endif

#ifdef	vms
#define	UNIXVMS
#endif

int day_month[] {                       /* Needed for dotexttime()      */
	0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};


int     ccpos;                          /* Current line position        */
char    lastbyte;                       /* Memory for output()          */
char    line[100];                      /* Data line for input function */
char    *valptr;                        /* Needed for number converter  */
char    wordbuffer[LINEWIDTH];          /* Buffer for output function   */
char    *wordptr;                       /* Free byte in wordbuffer      */
int     polish;                         /* Funny mode flag              */

extern  char    *datetxt();             /* Date getter                  */
extern  char    *timetxt();             /* Time of day getter           */
extern  char    *moontxt();             /* Phase of the moon getter     */

main(argc, argv)
int     argc;
char    **argv;
/*
 * Driver for time routines.  Usage:
 *
 *      today                   Prints current time of day in readable form,
 *                              followed by a cookie.
 *
 *      today {+cc}yymmddhhmmss Prints indicated time of day.
 *                              Note, hh, mm, ss may be omitted.
 *                              For example:
 *                                today 401106     = Nov. 6, 1940
 *                                today +19401106  = Nov. 6, 1940
 *                                today 4011061015 = Nov. 6, 1940 10:15 AM
 *
 *      today -                 Data is read from the standard input and
 *      today x                 output as needed.  The format of each
 *                              line is identical to the command format.
 *				("today x" is needed for vms.)
 */

{

	ccpos = 0;                      /* New line now                 */
	wordptr = wordbuffer;           /* Nothing buffered             */
	polish = 0;			/* Normal mode			*/
	if (argc > 1 && (argv[1][0] | 040) == 'p') {
		polish = 1;
		argc--;
		argv++;
	}

	if (argc == 2 && ((argv[1][0] == '-') || (argv[1][0] | 040) == 'x')) {
		while (!getline()) {	/* Read and print times */
			dotexttime(line);
		}
		return;
	}
	else if (argc > 1) {
		if (dotexttime(argv[1]) == 0)
			return;
	}
/*
 * Here if no parameters or an error in the parameter field.
 */
	dotime();			/* Print the time.              */
#ifdef	UNIX
	output("\n");           	/* Space before cookie          */
	execl(COOKIEPROGRAM,"cookie",0);
#endif
}


#ifdef	UNIXVMS
dotime()
/*
 * Print the time of day for Unix or VMS native mode.
 */
{
struct timevec {                        /* Unix ctime returns this      */
	int     seconds;
	int     minutes;
	int     hour;
	int     day;                    /* Range = 1 .. 31              */
	int     month;                  /* Range = 0 .. 11              */
	int     year;                   /* Note -- this is year - 1900  */
	int     weekday;                /* Range = 0 .. 6               */
	int     yearday;                /* Range = 0 .. 365             */
	int     daylight;               /* 1 if daylight savings time   */
};

	int     tvec[2];                /* Buffer for time function     */
	struct  timevec *localtime();   /* Unix time decompile function */
	struct  timevec *p;             /* Local pointer to time of day */
	int     year;
	int     month;
 
	time(tvec);                     /* Get the time of day          */
	p = localtime(tvec);            /* Make it more understandable  */
	year = p->year + 1900;
	month = p->month + 1;
	process(year, month, p->day, p->hour,
			p->minutes, p->seconds, p->daylight);
}
#else
dotime()
/*
 * Print the time of day for RSX, RT11, or their emulated modes
 */
{
	struct TIME {
		int	t_year;		/* Year since 1900		*/
		int	t_month;	/* Range = 1 .. 12		*/
		int	t_day;		/* Range = 1 .. 31		*/
		int	t_hour;		/* Range = 0 .. 23		*/
		int	t_minute;	/* Range = 0 .. 59		*/
		int	t_second;	/* Range = 0 .. 59		*/
		int	t_tick;		/* Range = 0 .. 99 on VMS	*/
		int	t_Hertz;	/* Clock interval, 100 on VMS	*/
	} t;

	rtime(&t);
	process(t.t_year + 1900, t.t_month, t.t_day,
		t.t_hour, t.t_minute, t.t_second, 0);
}
#endif

dotexttime(text)
char    *text;                          /* Time text                    */
/*
 * Create the time values and print them, return 1 on error.
 */

{
	int     epoch;                  /* Which century                */
	int     year;
	int     month;
	int     day;
	int     weekday;
	int     hour;
	int     minute;
	int     second;
	int     leapyear;

	valptr = text;                          /* Setup for getval()   */
	while (*valptr == ' ') valptr++;        /* Leading blanks skip  */
	if (*valptr != '+')
		epoch = 1900;                   /* Default for now      */
	else {
		valptr++;
		if ((epoch = getval(-1, 00, 99)) < 0) goto bad;
		epoch *= 100;                   /* Make it a real epoch */
	}

	if ((year = getval(-1, 00, 99)) < 0) goto bad;
	year += epoch;
	leapyear = ((year%4) == 0) && (((year%400) == 0) || (year%100 != 0));
	if ((month = getval(-1, 1, 12)) < 0) goto bad;
	if ((day = getval(-1, 1,
		(month == 2 && leapyear) ? 29 : day_month[month])) < 0)
			goto bad;
	if ((hour = getval(-2, 0, 23)) == -1) goto bad;
	if ((minute = getval(-2, 0, 59)) == -1) goto bad;
	if ((second = getval(-2, 0, 59)) == -1) goto bad;
	process(year, month, day, hour, minute, second, 0);
	return(0);				/* Normal exit		*/

bad:    output("Bad parameters or date out of range in \"");
	output(text);
	output("\" after scanning \"");
	*valptr = '\0';
	output(text);
	output("\".\n");
	return(1);				/* Error exit		*/
}

static	char    outline[500];		/* Output buffer                */

process(year, month, day, hour, minute, second, daylight)
int     year;                           /* Year		1900 = 1900	*/
int     month;                          /* Month	January = 1	*/
int     day;                            /* Day		1 = 1		*/
int	hour;				/* Hour		0 .. 23		*/
int	minute;				/* Minute	0 .. 59		*/
int	second;				/* Second	0 .. 59		*/
int	daylight;			/* Daylight savings time if 1	*/
/*
 * Output the information.  Note that the parameters are within range.
 */
{

	output("Today is ");
	datetxt(outline, year, month, day);
	output(outline);
	output(".  ");
	timetxt(outline, hour, minute, second,
			(polish) ? 0101010 : daylight);
	output(outline);
	output("The moon is ");
	moontxt(outline, year, month, day);
	output(outline);
	output(".  \n");
}



output(text)
char    *text;                                  /* What to print        */
/*
 * Output routine.  Text is output using putchar() so that lines are
 * not more than LINEWIDTH bytes long.  Current position is in global ccpos.
 */
{
	register char	*in;                    /* Current pos. in scan */
	register char	c;                      /* Current character    */
	register char	*wp;			/* Word pointer		*/

	in = text;
	while (c = *in++) {
		switch (c) {
		case '\n':                      /* Force new line       */
		case ' ':                       /* or a space seen      */
			if ((wordptr-wordbuffer) + ccpos >= LINEWIDTH) {
				putchar('\n');  /* Current word         */
				ccpos = 0;      /* won't fit, dump it.  */
			}
			if (wordptr > wordbuffer) {
				if (ccpos) {	/* Leading space needed */
					putchar(' ');
					ccpos++;
				}
				for (wp = wordbuffer; wp < wordptr;) {
					putchar(*wp++);
				}
				ccpos += (wordptr - wordbuffer);
				wordptr = wordbuffer;	/* Empty buffer	*/
			}
			if (c == ' ')		/* Nothing else if ' '  */
				break;
			putchar('\n');          /* Newline is needed.   */
			ccpos = 0;              /* Really is a new line */
			break;
		default:
			*wordptr++ = c;         /* Save piece of word   */
		}
	}
}


getline()
/*
 * Read text to global line[].  Return 1 on end of file, zero on ok.
 */
{
	register char *t;

	return (gets(line) == NULL);
}

getval(flag, low, high)
int     flag;
int     low;
int     high;
/*
 * Global valptr points to a 2-digit positive decimal integer.
 * Skip over leading non-numbers and return the value.
 * Return flag if text[0] == '\0'. Return -1 if the text is bad,
 * or if the value is out of the low:high range.
 */
{
	register int value;
	register int i;
	register int temp;

	if (*valptr == '\0') return(flag);        /* Default?             */
	while (*valptr && (*valptr < '0' || *valptr > '9')) *valptr++;
				/* The above allows for 78.04.22 format */
	for (value = i = 0; i < 2; i++) {
		temp = *valptr++ - '0';
		if (temp < 0 || temp > 9) return(-1);
		value = (value*10) + temp;
	}
	return((value >= low && value <= high) ? value : -1);
}

                                                                                                                                                                                                                                                                      