#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#
/*
 *			G E T K W K
 *
 * Getkwk scans library (macro) files for "; index" lines, building
 * the input to kwik.  It runs only on the decus compiler.
 * The format of the library files is described in getrno.c.
 *
 * Usage:
 *
 *	getkwk [-w] <input.fil >output.fil
 *
 * The -w flag has the same meaning as the wizard flag in getrno.c
 *
 * To build an index to the library:
 *
 *	getkwk >index.tmp [5,4]*.mac [5,5]*.mac
 *	kwik -t 16 -w 64 <index.tmp >index.out
 *	pip index.rno=indhed.rno,index.out/fa
 *	rno index=index
 *
 *
 */

#include <stdio.h>

#define		NAMESIZE	16	/* -t NAMESIZE in kwik		*/
int		debug;
int		wizard		= 0;	/* -w flag			*/
char		line[133];		/* Input text line		*/
char		namebuf[NAMESIZE];

FILE		*infd;

main(argc, argv)
int		argc;
char		*argv[];
{

	register int		c;
	register int		i;
	register char		*ap;

	for (i = 1; i < argc; i++) {
		if (*(ap = argv[i]) == '-') {
			while ((c = tolower(*++ap)) != 0) {
				switch (c) {
				case 'd':
					debug++;
					break;

				case 'w':
					wizard++;
					break;

				default:
					bug("W", "Unknown switch '%c'\n",
							c);
					break;
				}
			}
		}
		else {
			process(argv[i]);
		}
	}
}

process(name)
char		*name;		/* Wild spec to process			*/
/*
 * Do this wild spec.
 */
{
	register int	count;

	if ((infd = fwild(name, "r")) == NULL) {
		bug("W", "Can't open file \"%s\"\n", name);
		return;
	}
	for (count = 0; fnext(infd) != NULL; count++) {
		dofile();
	}
	if (count == 0)
		bug("W", "No files found for \"%s\"\n", name);
}

dofile()
/*
 * Process the current file (open on infd)
 */
{
	register char	*lp;
	register char	*namep;
	char		*skipuntil();
	char		*skipbl();
	char		*match();

	/*
	 * First, find the .title to get the index name
	 */
	if ((lp = skipuntil(".title")) == NULL)
		return;
	/*
	 * Skip over .title, skip to the entry name, copy it to namebuf[].
	 */
	namep = namebuf;
	while (*lp && *lp > ' ')
		lp++;
	lp = skipbl(lp);
	while (*lp > ' ' && namep < &namebuf[NAMESIZE-1])
		*namep++ = *lp++;
	*namep = 0;
	/*
	 * Now, read the file to ;+, then to "; Index"
	 * If "; Internal" seen and it's not for wizards, quit.
	 */
	if ((lp = skipuntil(";+")) == NULL)
		return;
	while (getline(infd)) {
		if (line[0] != ';' || line[1] == '-')
			return;
		if (!wizard && match(line, "; internal"))
			return;
		if (match(line, "; index")) {
			lp = skipbl(&line[7]);
			printf("%s\t%s\n", namebuf, lp);
		}
	}
}

char *
skipuntil(matcharg)
char		*matcharg;	/* what to look for			*/
/*
 * Read infd until eof or a match with matcharg.
 * Return a pointer to the first byte of matcharg.  Return NULL on eof
 * or upon scanning ";-".
 */
{
	register char	*lp;
	char		*skipbl();
	char		*match();

	while (getline(infd)) {
		if (line[0] == ';' && line[1] == '-')
			return(NULL);
		lp = skipbl(line);
		if (!match(lp, matcharg))
			continue;
		return(lp);
	}
	return(NULL);
}

char *
skipbl(text)
register char	*text;
/*
 * Skip over blanks and tabs, return -> first non-blank or trailing null
 */
{
	register char	c;

	while ((c = *text) && c <= ' ')
		text++;
	return(text);
}

char *
match(text, lookfor)
register char	*text;
register char	*lookfor;
/*
 * If the beginning of text matches lookfor (ignoring case)
 * return TRUE, lookfor must always be in lowercase.
 */
{
	register int	tc;		/* Text character		*/

	while (*lookfor != 0) {
		if ((tc = *text++) != *lookfor && (tc + 040) != *lookfor)
			return(FALSE);
		lookfor++;
	}
	return(TRUE);
}

getline(fd)
FILE		*fd;
/*
 * Read the next line from fd into line[].  Return FALSE at eof
 * getline() strips trailing blanks from the line.
 */
{
	register char	*lp;

	if (fgetss(line, sizeof line, fd) == NULL)
		return(FALSE);
	for (lp = &line[strlen(line)]; lp > line && lp[-1] <= ' ';)
		lp--;
	*lp = 0;
	return(TRUE);
}

bug(severity, s)
char		*severity;
char		*s;
/*
 * Error messages
 */
{
	fprintf(stderr, "%cGETKWK-%s-%r",
		(*severity == 'W') ? '%' : '?', severity, &s);
	if (*severity != 'W')
		error("?GETKWK-F-Can't continue");
}
                                                                                                                                                                                                                                                          