(*		SWS  -- SWITCH PROCESSING PROCEDURES FOR PASCAL


	THIS IS A COLLECTION OF ROUTINES TO PROCESS SWITCHES GIVEN TO A
	PASCAL PROGRAM IN A COMMAND LINE.  IT WILL BUILD A LINKED LIST
	OF ALL THE SWITCHES ENTERED, AND ALLOW A CONTROLLED SEARCH OF
	THAT LIST SO THAT THE PROGRAM CAN TAKE ACTIONS ACCORDING TO THE
	GIVEN SWITCHES.

	THE CALLS ARE:

		SWINI (LEN,STR)
			- INITIALIZES SWS;
				LEN	- TYPE = INTEGER; - # OF CHARS TO BE SCANNED IN STR
				STR	- TYPE = STR80; - STRING TO BE SCANNED

		SWTRY (SIGNIF,SWSTR,FOUND,PARM)
			- "TRYS" TO FIND THE SWITCH "SWSTR".
				SIGNIF	- TYPE = INTEGER; - # OF SIGNIFICANT CHARS IN SWSTR
				SWSTR	- TYPE = STR10; - SWITCH TO BE SEARCHED FOR
				FOUND	- TYPE = BOOLEAN; - REPORTS IF SWITCH WAS FOUND
				PARM	- TYPE = BOOLEAN; - REPORTS IF SWITCH HAD A PARM

		SWNXT (SWSTR,FOUND,PARM)
			- "TRYS" TO FIND THE NEXT "UNTRIED" SWITCH.
				SWSTR	- TYPE = STR10; - SWITCH FOUND
				FOUND	- TYPE = BOOLEAN; - REPORTS IF A SWITCH WAS FOUND
				PARM	- TYPE = BOOLEAN; - REPORTS IF THE SWITCH HAS A PARM

		SWPARM (SIGNIF,SWSTR,OUTLEN,OUTSTR)
			- GETS THE PARM FOR SWSTR
				SIGNIF	- AS ABOVE
				SWSTR	- AS ABOVE
				OUTLEN	- TYPE = INTEGER; - LENGTH OF PARM RETURNED
				OUTSTR	- TYPE = STR20; - RETURNED PARM

		SWDES
			- IF NO NEW VARIABLES HAVE BEEN ALLOC. IN HEAP, DESTORIES THE
			  SPACE ALLOC. FOR THE SWITCH SCAN

											*)

		(*$M-,Z-,C-,D- *)


PROGRAM SWSPAS, SWINI, SWTRY, SWPARM, SWDES;

TYPE	STR80		= PACKED ARRAY [1..80] OF CHAR;
	STR20		= PACKED ARRAY [1..20] OF CHAR;
	STR10		= PACKED ARRAY [1..10] OF CHAR;

	SW_ENTRY	= RECORD
				NEXT_SW			: ^ SW_ENTRY;
				TYPED_LEN		: INTEGER;
				TYPED_SW		: STR10;
				USED			: BOOLEAN;
				PARM_PTR		: ^ PARM_ENTRY
			  END;

	PARM_ENTRY	= RECORD
				PARM_LEN		: INTEGER;
				PARM			: STR20
			  END;



VAR	STRF				: FILE OF CHAR;
	SW_BASE, SW_CUR, SW_NEW		: ^ SW_ENTRY;
	HEAP_MARK, HEAP_END, HEAP_CK	: INTEGER;

PROCEDURE COMPAR (I:INTEGER; A,B:STR10; VAR F:BOOLEAN);

VAR	J				: INTEGER;

BEGIN
	F := TRUE;
	J := 1;
	WHILE (J <= I) AND F DO
		IF A[J] <> B[J] THEN
			F := FALSE
		ELSE
			J := J + 1
END;
PROCEDURE FIND (SIG:INTEGER; SWST:STR10; VAR FOUND:BOOLEAN);

BEGIN
	FOUND := FALSE;
	SW_CUR := SW_BASE;
	WHILE (SW_CUR <> NIL) AND NOT FOUND DO
	BEGIN
		WITH SW_CUR^ DO
		BEGIN
			IF SIG <= TYPED_LEN THEN
				COMPAR (TYPED_LEN,TYPED_SW,SWST,FOUND)
		END;
		IF NOT FOUND THEN
			SW_CUR := SW_CUR^.NEXT_SW
		ELSE
			SW_CUR^.USED := TRUE
	END
END;
PROCEDURE SWINI (LEN:INTEGER;  STR:STR80);

VAR	I				: INTEGER;

BEGIN
	MARK (HEAP_MARK);		(* MARK TOP OF HEAP *)

	SW_BASE := NIL;

	I := 1;

	WHILE I < LEN DO
	BEGIN
		WHILE (I <= LEN) AND (STR[I] <> '/') DO
			I := I + 1;

		IF I < LEN THEN
		BEGIN
			STRSET (STRF,STR,I+1,LEN);

			NEW (SW_NEW);

			WITH SW_NEW^ DO
			BEGIN
				USED := FALSE;
				READ (STRF,
				 TYPED_SW:TYPED_LEN:['/',':',';','!',' ','	',',','=']);
				GETINDEX (STRF,I);
				I := I - 1;
				IF (I < LEN) AND (STR[I] = ':') THEN
				BEGIN
					STRSET (STRF,STR,I+1,LEN);
					NEW (PARM_PTR);
					READ (STRF, PARM_PTR^.PARM:PARM_PTR^.PARM_LEN:['/',';','!',',','=']);
					GETINDEX (STRF,I);
					I := I - 1
				END
				ELSE
					PARM_PTR := NIL;
				NEXT_SW := NIL
			END;

			IF SW_BASE = NIL THEN
				SW_BASE := SW_NEW
			ELSE
			BEGIN
				SW_CUR := SW_BASE;
				WHILE SW_CUR^.NEXT_SW <> NIL DO
					SW_CUR := SW_CUR^.NEXT_SW;
				SW_CUR^.NEXT_SW := SW_NEW
			END
		END
	END;

	MARK (HEAP_END)
END;
PROCEDURE SWTRY (SIG:INTEGER;  SWST:STR10;  VAR FOUND,PARM_FOUND:BOOLEAN);

BEGIN
	FIND (SIG,SWST,FOUND);

	IF FOUND THEN
		IF SW_CUR^.PARM_PTR <> NIL THEN
			PARM_FOUND := TRUE

END;
PROCEDURE SWNXT (VAR SWST:STR10; VAR FOUND,PARM_FOUND:BOOLEAN);

BEGIN
	FOUND := FALSE;		PARM_FOUND := FALSE;
	SW_CUR := SW_BASE;

	WHILE (SW_CUR <> NIL) AND NOT FOUND DO
		WITH SW_CUR^ DO
			IF NOT USED THEN
			BEGIN
				SWST := TYPED_SW;
				USED := TRUE;
				FOUND := TRUE;
				BEGIN
					IF PARM_PTR <> NIL THEN
						PARM_FOUND := TRUE
				END
			END
			ELSE
				SW_CUR := NEXT_SW
END;
PROCEDURE SWPARM (SIG:INTEGER;  SWST:STR10;  VAR PLEN:INTEGER;  VAR PSTR:STR20);

VAR	F				: BOOLEAN;

BEGIN
	FIND (SIG,SWST,F);

	PLEN := 0;

	IF F THEN
	BEGIN
		IF SW_CUR^.PARM_PTR <> NIL THEN
		BEGIN
			PLEN := SW_CUR^.PARM_PTR^.PARM_LEN;
			PSTR := SW_CUR^.PARM_PTR^.PARM
		END
	END
END;
PROCEDURE SWDES;

BEGIN
	MARK (HEAP_CK);

	IF HEAP_CK = HEAP_END THEN
		RELEASE (HEAP_MARK)