#	Copyright (c) 1990 UNIX System Laboratories, Inc.
#	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF
#	UNIX System Laboratories, Inc.
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)localedef:colltbl/colltbl.mk	1.1.3.1"

#	Makefile for colltbl

ROOT =

INSDIR = $(ROOT)/usr/bin

INS = install

INC = $(ROOT)/usr/include

LDFLAGS = -s

CFLAGS = -O -I$(INC)

STRIP = strip

SIZE = size

#top#
# Generated by makefile 1.1

MAKEFILE = colltbl.mk

YFLAGS = -d

MAINS = colltbl

OBJECTS =  collfcns.o colltbl.o diag.o lex.o parse.o

SOURCES =  collfcns.c colltbl.c diag.c lex.c parse.y

ALL:		$(MAINS)

colltbl:	colltbl.o collfcns.o diag.o parse.o lex.o 
	$(CC) $(CFLAGS)  -o colltbl  colltbl.o collfcns.o diag.o parse.o \
	lex.o   $(LDFLAGS) -ly


collfcns.o:	 $(INC)/ctype.h $(INC)/stddef.h \
		 $(INC)/stdio.h $(INC)/stdlib.h \
		 $(INC)/string.h colltbl.h 


colltbl.o:	 $(INC)/stdio.h colltbl.h	


diag.o:		 $(INC)/stdio.h $(INC)/varargs.h colltbl.h 


lex.o:		 $(INC)/ctype.h $(INC)/stdio.h \
		 $(INC)/string.h colltbl.h y.tab.h 


parse.o:	 colltbl.h 

GLOBALINCS = $(INC)/ctype.h $(INC)/stddef.h $(INC)/stdio.h \
	$(INC)/stdlib.h $(INC)/string.h $(INC)/varargs.h 

LOCALINCS = colltbl.h y.tab.h 

clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS) y.tab.h

newmakefile:
	makefile -m -f $(MAKEFILE)  -s INC $(INC)
#bottom#

all : ALL

install: ALL
	$(INS) -f $(INSDIR) colltbl ;\
	$(INS) -f $(ROOT)/usr/lib/locale/C colltbl_C ;\
	$(CH)./colltbl colltbl_C ;\
	$(CH)install -f $(ROOT)/usr/lib/locale/C LC_COLLATE ;\
	$(CH)rm -f LC_COLLATE


size: ALL
	$(SIZE) $(MAINS)

strip: ALL
	$(STRIP) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)
