/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)cmd-inet:usr.sbin/in.tftpd.c	1.10.3.1"

/*
 * +++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 * 		PROPRIETARY NOTICE (Combined)
 * 
 * This source code is unpublished proprietary information
 * constituting, or derived under license from AT&T's UNIX(r) System V.
 * In addition, portions of such source code were derived from Berkeley
 * 4.3 BSD under license from the Regents of the University of
 * California.
 * 
 * 
 * 
 * 		Copyright Notice 
 * 
 * Notice of copyright on this source code product does not indicate 
 * publication.
 * 
 * 	(c) 1986,1987,1988.1989  Sun Microsystems, Inc
 * 	(c) 1983,1984,1985,1986,1987,1988,1989  AT&T.
 * 	          All rights reserved.
 *  
 */


/*
 * Trivial file transfer protocol server.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/time.h>

#include <netinet/in.h>

#include <arpa/tftp.h>

#include <dirent.h>
#include <signal.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <netdb.h>
#include <setjmp.h>
#include <syslog.h>
#include <sys/param.h>
#include <fcntl.h>
#include <pwd.h>

#ifdef SYSV
#define	bzero(s,n)	memset((s), 0, (n))
#endif /* SYSV */

#ifndef UID_NOBODY
#define	UID_NOBODY	60001
#define	GID_NOBODY	60001
#endif /* UID_NOBODY */

#define	TIMEOUT		5
#define	PKTSIZE		SEGSIZE+4
#define	DELAY_SECS	3
#define DALLYSECS 60

extern	int optind, getopt();
extern	char *optarg;
extern	int errno;

struct	sockaddr_in sin = { AF_INET };
int	peer;
int	rexmtval = TIMEOUT;
int	maxtimeout = 5*TIMEOUT;
char	buf[PKTSIZE];
char	ackbuf[PKTSIZE];
struct	sockaddr_in from;
int	fromlen;
pid_t	child;			/* pid of child handling delayed replys */
int	delay_fd [2];		/* pipe for communicating with child */
FILE	*file;
struct	delay_info {
	long	timestamp;		/* time request received */
	int	ecode;			/* error code to return */
	struct	sockaddr_in from;	/* address of client */
};

int	initted = 0;
int	securetftp = 0;
int	debug = 0;
int	disable_pnp = 0;

struct passwd *pwd;	/* for "nobody" entry */

/*
 * Default directory for unqualified names
 * Used by TFTP boot procedures
 */
char	*homedir = "/tftpboot";

#ifndef SYSV
void
childcleanup ()
{
	wait3 ((union wait *) 0, WNOHANG, (struct rusage *) 0);
	(void) signal (SIGCHLD, (void (*)())childcleanup);
}
#endif /* SYSV */

main (argc, argv)
	int argc;
	char **argv;
{
	register struct tftphdr *tp;
	register int n;
	int on = 1;
	int c;

	openlog("tftpd", LOG_PID, LOG_DAEMON);

	while ((c = getopt (argc, argv, "dsp")) != EOF)
		switch (c) {
		case 'd':		/* enable debug */
			debug++;
			continue;
		case 's':		/* secure daemon */
			securetftp = 1;
			continue;
		case 'p':		/* disable name pnp mapping */
			disable_pnp = 1;
			continue;
		case '?':
		default:
usage:
			fprintf (stderr, 
				 "usage:  %s [-spd] [home-directory]\n",
				 argv[0]);
			for ( ; optind < argc; optind++)
				syslog (LOG_ERR, "bad argument %s", 
					argv [optind]);
			exit (1);
		}

	if (optind < argc)
		if (optind == argc - 1 && *argv [optind] == '/')
			homedir = argv [optind];
		else
			goto usage;
	
	if (pipe (delay_fd) < 0) {
		syslog (LOG_ERR, "pipe (main): %m");
		exit (1);
	}

#ifdef SYSV
	(void) signal (SIGCHLD, SIG_IGN); /*no zombies please*/
#else
	(void) signal (SIGCHLD, (void (*)())childcleanup);
#endif /* SYSV */

	if ((child = fork ()) < 0) {
		syslog (LOG_ERR, "fork (main): %m");
		exit (1);
	}

	if (child == 0) {
		struct delay_info dinfo;
		long now;

		/* we don't use the descriptors passed in to the parent */
		(void) close (0);
		(void) close (1);


		if ((pwd = getpwnam("nobody")) == NULL) {
			if ( setgid((gid_t)GID_NOBODY) < 0 ) {
				syslog (LOG_ERR, "setgid(%d): %m", GID_NOBODY);
				exit(1);
			}
			if ( setuid((uid_t)UID_NOBODY) < 0 ) {
				syslog (LOG_ERR, "setuid(%d): %m", UID_NOBODY);
				exit(1);
			}
		} else {
			if ( setgid((gid_t)pwd->pw_gid) < 0 ) {
				syslog (LOG_ERR, "setgid(%d): %m", pwd->pw_gid);
				exit(1);
			}
			if ( setuid((uid_t)pwd->pw_uid) < 0 ) {
				syslog (LOG_ERR, "setuid(%d): %m", pwd->pw_uid);
				exit(1);
			}
		}

		/* close write side of pipe */
		(void) close (delay_fd[1]);

		for (;;) {
			if (read (delay_fd [0], (char *) &dinfo, 
				  sizeof (dinfo)) != sizeof (dinfo)) {
				if (errno == EINTR)
					continue;
				syslog (LOG_ERR, "read from pipe: %m");
				exit (1);
			}

			peer = socket(AF_INET, SOCK_DGRAM, 0);
			if (peer < 0) {
				syslog(LOG_ERR, "socket (delay): %m");
				exit(1);
			}

			bzero ((char *) &sin, sizeof (sin));
			sin.sin_family = AF_INET;
			if (bind(peer, (struct sockaddr *) &sin, 
				 sizeof (sin)) < 0) {
				syslog(LOG_ERR, "bind (delay): %m");
				exit(1);
			      }

			dinfo.from.sin_family = AF_INET;
			if (connect(peer, (struct sockaddr *) &dinfo.from,
				    sizeof(dinfo.from)) < 0) {
				syslog(LOG_ERR, "connect (delay): %m");
				exit(1);
				break;
			}

			/*
			 * only sleep if DELAY_SECS has not elapsed since 
			 * original request was received.  Ensure that `now' 
			 * is not earlier than `dinfo.timestamp'
			 */
			now = time(0);
			if ((u_int)(now - dinfo.timestamp) < DELAY_SECS)
				sleep (DELAY_SECS - (now - dinfo.timestamp));
			nak (dinfo.ecode);
			(void) close (peer);
		} /* for */
		/*NOTREACHED*/
		exit (0);
	} /* child */

	/* close read side of pipe */
	(void) close (delay_fd[0]);


	/*
	 * Top level handling of incomming tftp requests.  Read a request
	 * and pass it off to be handled.  If request is valid, handling
	 * forks off and parent returns to this loop.  If no new requests
	 * are received for DALLYSECS, exit and return to inetd.
	 */

	for (;;) {
		int readfds;
		struct timeval dally;

		readfds = 0x1;
		dally.tv_sec = DALLYSECS;
		dally.tv_usec = 0;

		n = select (sizeof (int), &readfds, (int *) NULL, 
			    (int *) NULL, &dally);
		if (n < 0) {
			if (errno == EINTR)
				continue;
			syslog (LOG_ERR, "select: %m");
		  	(void) kill (child, SIGKILL);
			exit (1);
		}
		if (n == 0) {
		  	(void) kill (child, SIGKILL);
			exit (0);
		}

		fromlen = sizeof (from);
		n = recvfrom(0, buf, sizeof (buf), 0,
			     (struct sockaddr *) &from, &fromlen);
		if (n < 0) {
			if (errno == EINTR)
				continue;
			syslog(LOG_ERR, "recvfrom: %m");
			(void) kill (child, SIGKILL);
			exit(1);
		}

		(void) alarm(0);

		peer = socket(AF_INET, SOCK_DGRAM, 0);
		if (peer < 0) {
			syslog(LOG_ERR, "socket (main): %m");
			(void) kill (child, SIGKILL);
			exit(1);
		}

		bzero ((char *) &sin, sizeof (sin));
		sin.sin_family = AF_INET;
		if (bind(peer, (struct sockaddr *)&sin, sizeof (sin)) < 0) {
			syslog(LOG_ERR, "bind (main): %m");
			(void) kill (child, SIGKILL);
			exit(1);
		}

		from.sin_family = AF_INET;
		if (connect(peer, (struct sockaddr *)&from, sizeof(from)) 
		    < 0) {
			syslog(LOG_ERR, "connect (main): %m");
			(void) kill (child, SIGKILL);
			exit(1);
		}

		tp = (struct tftphdr *)buf;
		tp->th_opcode = ntohs((u_short) tp->th_opcode);
		if (tp->th_opcode == RRQ || tp->th_opcode == WRQ)
			tftp(tp, n);

		(void) close (peer);
		(void) fclose (file);
	}
}

int	validate_access();
int	sendfile(), recvfile();

struct formats {
	char	*f_mode;
	int	(*f_validate)();
	int	(*f_send)();
	int	(*f_recv)();
	int	f_convert;
} formats[] = {
	{ "netascii",	validate_access,	sendfile,	recvfile, 1 },
	{ "octet",	validate_access,	sendfile,	recvfile, 0 },
#ifdef notdef
	{ "mail",	validate_user,		sendmail,	recvmail, 1 },
#endif
	{ 0 }
};


/*
 * Handle initial connection protocol.
 */
tftp(tp, size)
	struct tftphdr *tp;
	int size;
{
	register char *cp;
	int first = 1, ecode;
	register struct formats *pf;
	char *filename, *mode;
	pid_t pid;
	struct delay_info dinfo;

	filename = cp = (char *) &tp->th_stuff;
again:
	while (cp < buf + size) {
		if (*cp == '\0')
			break;
		cp++;
	}
	if (*cp != '\0') {
		nak(EBADOP);
		exit(1);
	}
	if (first) {
		mode = ++cp;
		first = 0;
		goto again;
	}
	for (cp = mode; *cp; cp++)
		if (isupper(*cp))
			*cp = tolower(*cp);
	for (pf = formats; pf->f_mode; pf++)
		if (strcmp(pf->f_mode, mode) == 0)
			break;
	if (pf->f_mode == 0) {
		nak(EBADOP);
		exit(1);
	}
	ecode = (*pf->f_validate)(filename, tp->th_opcode);

	if (ecode) {
		/*
                 * The most likely cause of an error here is that
                 * someone has broadcast an RRQ packet because s/he's
                 * trying to boot and doesn't know who the server is.
                 * Rather then sending an ERROR packet immediately, we
                 * wait a while so that the real server has a better chance
                 * of getting through (in case client has lousy Ethernet
                 * interface).  We write to a child that handles delayed
		 * ERROR packets to avoid delaying service to new
		 * requests.  Of course, we would rather just not answer
		 * RRQ packets that are broadcast, but there's no way
		 * for a user process to determine this.
                 */
		dinfo.timestamp = time(0);
		dinfo.ecode = ecode;
		dinfo.from = from;
		if (write (delay_fd [1], (char *) &dinfo, sizeof (dinfo)) !=
		    sizeof (dinfo)) {
			syslog (LOG_ERR, "delayed write failed.");
			(void) kill (child, SIGKILL);
			exit (1);
		}
		return;
	}

	/* 
	 * fork a new process only after we have determined that we can 
	 * handle this request.
	 */

	pid = fork();
	if (pid < 0) {
		syslog(LOG_ERR, "fork (tftp): %m");
		return;
	}

	if (pid == 0) {
		/* we don't use the descriptors passed in to the parent */
		(void) close (0);
		(void) close (1);
		
		if (tp->th_opcode == WRQ)
			(*pf->f_recv)(pf);
		else
			(*pf->f_send)(pf);
		exit (0);
	}

	return;
}

/*
 *	Maybe map filename into another one.
 *
 *	For PNP, we get TFTP boot requests for filenames like 
 *	<Unknown Hex IP Addr>.<Sun Architecture Name>.   We must
 *	map these to 'pnp.<Sun Architecture Name>'.  Note that
 *	uppercase is mapped to lowercase in the architecture names.
 *
 *	For names <Hex IP Addr> there are two cases.  First,
 *	it may be a buggy prom that omits the architecture code.
 *	So first check if <Hex IP Addr>.<arch> is on the filesystem.
 *	Second, this is how most Sun3s work; assume <arch> is sun3.
 */

char *
pnp_check (filename)
    char *filename;
{
	static char buf [MAXNAMLEN + 1];
	char *arch, *s;
	long ipaddr;
	int len = (filename ? strlen (filename) : 0);
	struct hostent *hp;
	DIR *dir;
	struct dirent *dp;
	struct stat statb;

	if (securetftp || disable_pnp || len < 8 || len > 14)
		return (char *) NULL;

	/* XXX see if this cable allows pnp; if not, return NULL
	 * Requires YP support for determining this!
	 */
	
	ipaddr = htonl (strtol (filename, &arch, 16));
	if (!arch || (len > 8 && *arch != '.'))
		return (char *) NULL;
	if (len == 8)
		arch = "SUN3";
	else
		arch++;

	/* allow <Hex IP Addr>* filename request to to be
	 * satisfied by <Hex IP Addr><Any Suffix> rather
	 * than enforcing this to be Sun3 systems.  Also serves
	 * to make case of suffix a don't-care.
	 */
	if ((dir = opendir ("/tftpboot")) == (DIR *) NULL)
		return (char *) NULL;
	while ((dp = readdir (dir)) != (struct dirent *)NULL) {
		if (strncmp (filename, dp->d_name, 8) == 0) {
			strcpy (buf, dp->d_name);
			closedir (dir);
			return buf;
		}
	}
	closedir (dir);

	/* XXX maybe call YP master for most current data iff
	 * pnp is enabled.
	 */

	hp = gethostbyaddr (&ipaddr, sizeof (ipaddr), AF_INET);

	/* map to PNP boot file name
	 */
	if (!hp) {
		strcpy (buf, "pnp.");
		for (s = &buf [4]; *arch; )
			if (isupper (*arch))
				*s++ = tolower (*arch++);
			else
				*s++ = *arch++;
		return buf;
	} else {
		return (char *) NULL;
	}
}



/*
 * Validate file access.  Since we
 * have no uid or gid, for now require
 * file to exist and be publicly
 * readable/writable.
 * Note also, full path name must be
 * given as we have no login directory.
 */
validate_access(filename, mode)
	char *filename;
	int mode;
{
	struct stat stbuf;
	int	fd;
	char *origfile;
	
	if (!initted) {
		if (securetftp) {
			if (chroot(homedir) < 0) {
				syslog(LOG_ERR, "tftpd: cannot chroot to directory %s: %m\n", homedir);
				return (EACCESS);
			}
			(void) chdir("/");  /* cd to  new root */
		} else {
        		(void) chdir(homedir); /* don't care if this works */
		}
		/*
         	 * Need to perform access check as someone who will only
         	 * be allowed "public" access to the file.  There is no
         	 * such uid/gid reserved so we kludge it with UID_NOBODY/
		 * GID_NOBODY (-2 for BSD -- Can't use -1/-1 'cause that
		 * means "don't change".)
         	 */
		if (pwd == NULL) {
			if ( setgid((gid_t)GID_NOBODY) < 0 ) {
				syslog (LOG_ERR, "setgid(%d): %m", GID_NOBODY);
				exit(1);
			}
			if ( setuid((uid_t)UID_NOBODY) < 0 ) {
				syslog (LOG_ERR, "setuid(%d): %m", UID_NOBODY);
				exit(1);
			}
		} else {
			if ( setgid((gid_t)pwd->pw_gid) < 0 ) {
				syslog (LOG_ERR, "setgid(%d): %m", pwd->pw_gid);
				exit(1);
			}
			if ( setuid((uid_t)pwd->pw_uid) < 0 ) {
				syslog (LOG_ERR, "setuid(%d): %m", pwd->pw_uid);
				exit(1);
			}
		}
		initted = 1;
	}
	
	if (stat(filename, &stbuf) < 0) {
		if (errno != ENOENT)
			return EACCESS;
		origfile = filename;
		if (mode != RRQ
		    || (filename = pnp_check (origfile)) == (char *) NULL
		    || stat (filename, &stbuf) < 0)
			return (errno == ENOENT ? ENOTFOUND : EACCESS);
		syslog (LOG_NOTICE, "%s -> %s\n", origfile, filename);
	}
	
	if (mode == RRQ) {
		if ((stbuf.st_mode&S_IROTH) == 0)
			return (EACCESS);
	} else {
		if ((stbuf.st_mode&S_IWOTH) == 0)
			return (EACCESS);
	}
	if ((stbuf.st_mode & S_IFMT) != S_IFREG)
                return (EACCESS);
	fd = open(filename, mode == RRQ ? O_RDONLY : (O_WRONLY|O_TRUNC));
	if (fd < 0)
		return (errno + 100);
	file = fdopen(fd, (mode == RRQ)? "r":"w");
	if (file == NULL) {
		return errno+100;
	}
	return (0);
}

int	timeout;
jmp_buf	timeoutbuf;

timer()
{
	
	timeout += rexmtval;
	if (timeout >= maxtimeout)
		exit(1);
	longjmp(timeoutbuf, 1);
}

/*
 * Send the requested file.
 */
sendfile(pf)
	struct formats *pf;
{
	struct tftphdr *dp, *r_init();
	struct tftphdr *ap;    /* ack packet */
	int block = 1, size, n;
	
	signal(SIGALRM, (void (*)())timer);
	dp = r_init();
	ap = (struct tftphdr *)ackbuf;
	do {
		size = readit(file, &dp, pf->f_convert);
		if (size < 0) {
			nak(errno + 100);
			goto abort;
		}
		dp->th_opcode = htons((u_short)DATA);
		dp->th_block = htons((u_short)block);
		timeout = 0;
		(void) setjmp(timeoutbuf);
		
send_data:
		if (send(peer, dp, size + 4, 0) != size + 4) {
			if ((errno == ENETUNREACH) ||
			    (errno == EHOSTUNREACH) ||
			    (errno == ECONNREFUSED))
				syslog(LOG_WARNING, "send (data): %m");
			else
				syslog(LOG_ERR, "send (data): %m");
			goto abort;
		}
		read_ahead(file, pf->f_convert);
		for ( ; ; ) {
			alarm(rexmtval);        /* read the ack */
			n = recv(peer, ackbuf, sizeof (ackbuf), 0);
			alarm(0);
			if (n < 0) {
				if (errno == EINTR)
					continue;
				if ((errno == ENETUNREACH) ||
				    (errno == EHOSTUNREACH) ||
				    (errno == ECONNREFUSED))
					syslog(LOG_WARNING, "recv (ack): %m");
				else
					syslog(LOG_ERR, "recv (ack): %m");
				goto abort;
			}
			ap->th_opcode = ntohs((u_short)ap->th_opcode);
			ap->th_block = ntohs((u_short)ap->th_block);
			
			if (ap->th_opcode == ERROR)
				goto abort;
			
			if (ap->th_opcode == ACK) {
				if (ap->th_block == block) {
					break;
				}
				/* Re-synchronize with the other side */
				(void) synchnet(peer);
				if (ap->th_block == (block -1)) {
					goto send_data;
				}
			}
			
		}
		block++;
	} while (size == SEGSIZE);
abort:
	(void) fclose(file);
}

justquit()
{
	exit(0);
}


/*
 * Receive a file.
 */
recvfile(pf)
	struct formats *pf;
{
	struct tftphdr *dp, *w_init();
	struct tftphdr *ap;    /* ack buffer */
	int block = 0, n, size;

	signal(SIGALRM, (void (*)())timer);
	dp = w_init();
	ap = (struct tftphdr *)ackbuf;
	do {
		timeout = 0;
		ap->th_opcode = htons((u_short)ACK);
		ap->th_block = htons((u_short)block);
		block++;
		(void) setjmp(timeoutbuf);
send_ack:
		if (send(peer, ackbuf, 4, 0) != 4) {
			syslog(LOG_ERR, "send (ack): %m\n");
			goto abort;
		}
		write_behind(file, pf->f_convert);
		for ( ; ; ) {
			alarm(rexmtval);
			n = recv(peer, dp, PKTSIZE, 0);
			alarm(0);
			if (n < 0) {            /*really? */
				if (errno == EINTR)
					continue;
				syslog(LOG_ERR, "recv (data): %m");
				goto abort;
			}
			dp->th_opcode = ntohs((u_short)dp->th_opcode);
			dp->th_block = ntohs((u_short)dp->th_block);
			if (dp->th_opcode == ERROR)
				goto abort;
			if (dp->th_opcode == DATA) {
				if (dp->th_block == block) {
					break;   /* normal */
				}
				/* Re-synchronize with the other side */
				(void) synchnet(peer);
				if (dp->th_block == (block-1))
					goto send_ack;          /* rexmit */
			}
		}
		/*  size = write(file, dp->th_data, n - 4); */
		size = writeit(file, &dp, n - 4, pf->f_convert);
		if (size != (n-4)) {                    /* ahem */
			if (size < 0) nak(errno + 100);
			else nak(ENOSPACE);
			goto abort;
		}
	} while (size == SEGSIZE);
	write_behind(file, pf->f_convert);
	(void) fclose(file);            /* close data file */

	ap->th_opcode = htons((u_short)ACK);    /* send the "final" ack */
	ap->th_block = htons((u_short)(block));
	(void) send(peer, ackbuf, 4, 0);

	signal(SIGALRM, (void (*)())justquit);      /* just quit on timeout */
	alarm(rexmtval);
	n = recv(peer, buf, sizeof (buf), 0); /* normally times out and quits */
	alarm(0);
	if (n >= 4 &&                   /* if read some data */
	    dp->th_opcode == DATA &&    /* and got a data block */
	    block == dp->th_block) {	/* then my last ack was lost */
		(void) send(peer, ackbuf, 4, 0);     /* resend final ack */
	}
abort:
	return;
}

struct errmsg {
	int	e_code;
	char	*e_msg;
} errmsgs[] = {
	{ EUNDEF,	"Undefined error code" },
	{ ENOTFOUND,	"File not found" },
	{ EACCESS,	"Access violation" },
	{ ENOSPACE,	"Disk full or allocation exceeded" },
	{ EBADOP,	"Illegal TFTP operation" },
	{ EBADID,	"Unknown transfer ID" },
	{ EEXISTS,	"File already exists" },
	{ ENOUSER,	"No such user" },
	{ -1,		0 }
};

/*
 * Send a nak packet (error message).
 * Error code passed in is one of the
 * standard TFTP codes, or a UNIX errno
 * offset by 100.
 */
nak(error)
	int error;
{
	register struct tftphdr *tp;
	int length;
	register struct errmsg *pe;
	extern char *sys_errlist[];

	tp = (struct tftphdr *)buf;
	tp->th_opcode = htons((u_short)ERROR);
	tp->th_code = htons((u_short)error);
	for (pe = errmsgs; pe->e_code >= 0; pe++)
		if (pe->e_code == error)
			break;
	if (pe->e_code < 0) {
		pe->e_msg = sys_errlist[error - 100];
		tp->th_code = EUNDEF;   /* set 'undef' errorcode */
	}
	strcpy(tp->th_msg, pe->e_msg);
	length = strlen(pe->e_msg);
	tp->th_msg[length] = '\0';
	length += 5;
	if (send(peer, buf, length, 0) != length)
		syslog(LOG_ERR, "tftpd: nak: %m\n");
}
