module bk0010(
mclk,
reset_in,
PS2_Clk, PS2_Data,
button0,
pdb,
astb,
dstb,
pwr,
pwait,
led,
switch,
dot,
ram_addr,
ram_a_data,
ram_a_ce,
ram_a_lb,
ram_a_ub,
ram_we,
ram_oe,
RED,GREEN,BLUE,vs,hs,
digit_anode,
segment_a,
segment_b,
segment_c,
segment_d,
segment_e,
segment_f,
segment_g,
clk_cpu2,
clk_cpu,
mclk25,
cpu_rd,
cpu_wt,
cpu_oe,
_cpu_inst
);

input mclk,button0;
input PS2_Clk, PS2_Data;
inout[7:0] pdb;
input astb;
input dstb;
input pwr;
output pwait;
output clk_cpu,clk_cpu2,mclk25,cpu_rd,cpu_wt,cpu_oe;
output[7:0] led;
output _cpu_inst;
input[7:0] switch;
//	rgBtn	: in std_logic_vector(4 downto 0);
//	btn		: in std_logic;

output dot;
output [17:0] ram_addr;
inout [15:0] ram_a_data;
output ram_a_ce;
output ram_a_lb;
output ram_a_ub;
output ram_we;
output ram_oe;

output[3:0] digit_anode;
output segment_a, segment_b, segment_c, segment_d, segment_e, segment_f,segment_g;


input reset_in;

output RED,GREEN,BLUE,vs,hs;
reg RED,GREEN,BLUE;

reg [3:0] digit_anode;

   wire kbd_data_wr;
   //wire not_video_access;
   wire video_access;
   wire [9:0] x;
   wire [9:0] y;
   wire       hs;
   wire       vs;
   wire       valid;

   wire       R,G,B;
   //reg [15:0] videodata;
   wire        color;
   wire        load;
   //wire        video_rd;

   wire [17:0] usb_addr;
   wire [15:0] usb_a_data;
   
   wire usb_a_lb;
   wire usb_a_ub;
   wire usb_we;
   wire usb_oe;

   wire [12:0] vga_addr;
   reg [15:0] data_to_interface;
  
   wire RST_IN;
   wire LOCKED_OUT;
   wire	CLKDV_OUT;
   wire	CLKIN_IBUFG_OUT;
   wire	CLK0_OUT;

   reg [1:0] usb_clk;
   wire mclk25;
   wire kbd_available;

   //reg vga_need_data;
   wire vga_oe;
   reg [1:0] vga_state;
   reg [1:0] next_vga_state;

   reg [23:0] cntr; // slow counter for heartbeat LED
  // wire [6:0] LED7_out;
   wire [3:0] digit7;
   wire [1:0] digit_select;

   wire [15:0] disp_7seg_data;
   //reg [7:0] count1;
   wire b0_debounced;
   wire stop_run;

   wire [7:0] led_from_usb;

   wire cpu_lb, cpu_ub;

   
   wire [15:0] cpu_adr;
  // wire [15:0] cpu_in;
   wire [15:0] cpu_out;
     wire cpu_wt;
	wire cpu_rd;
	wire cpu_byte;
	wire single_step;
	wire cpu_clock_en;
	wire clk_cpu;
	wire clk_cpu_buff;
	reg [4:0] clk_cpu_count;
	wire cpu_rdy;
	wire cpu_oe;
	wire cpu_we;
	wire read_kbd;
	wire [7:0] roll;

   reg [15:0] latched_ram_data;
   reg [15:0] data_from_cpu;

   reg [2:0] seq;
   reg [1:0] one_shot;

  
   assign led = {cpu_rdy, b0_debounced, kbd_available, led_from_usb[4:0]};
   assign cpu_lb = cpu_byte & cpu_adr[0];  // if byte LOW, lb low. If even addr, low too 
   assign cpu_ub = cpu_byte & ~cpu_adr[0];

   debounce debounce(.pb_debounced(b0_debounced), .pb(button0), .clock_100Hz(cntr[16]));
  
   run_control run_control (.clk(clk_cpu_count[2]),.reset_in(reset_in), 
   					.start(b0_debounced), .stop(stop_run), .active(cpu_rdy ));
				//	.start(button0), .stop(stop_run));

				//	assign cpu_rdy = 1;

 
// vga state machine runs on 50 MHz clock
   always @(posedge CLK0_OUT) begin
    	if(reset_in) 
    		vga_state <= 0;
    	else 
		if(switch[1])
    			vga_state <= next_vga_state;
   end

	assign single_step = switch[6];
	assign cpu_clock_en = switch[7];
//	assign clk_cpu = clk_cpu_count[3] & cpu_clock_en;
	assign clk_cpu = x[3] & cpu_clock_en;
	assign clk_cpu2 = clk_cpu_count[2];

   

  BUFG CLKCPU_BUFG_INST(
    .I (clk_cpu),
    .O (clk_cpu_buff));

   // synthesis attribute clock_signal of clk_cpu is yes; 
   wire [6:0] ascii;
   wire [7:0] kbd_data;
   assign kbd_data = {1'b0, ascii};

   wire CPU_reset;

   wire [15:0] match_val_u;
   wire [15:0] match_mask_u;
   wire match_hit,cpu_rdy_final;

   assign CPU_reset = reset_in | led_from_usb[0]; 
   assign stop_run = (cpu_rd & single_step) | (match_hit & led_from_usb[2]) ;
   assign cpu_rdy_final = cpu_rdy & ~led_from_usb[1];
   
   match bp_match (
    .inp_val(inp_val), 
    .match_val(match_val_u), 
    .mask(match_mask_u), 
    .hit(match_hit)
    );
 

   core core (
    .p_reset(CPU_reset), 
    .m_clock(clk_cpu_buff), 
    .cpu_rdy(cpu_rdy_final), 
    .wt(cpu_wt), 
    .rd(cpu_rd), 
    .in(latched_ram_data), 
    .out(cpu_out), 
    .adr(cpu_adr), 
    .byte(cpu_byte),
    ._cpu_inst(_cpu_inst),
  //  .kbd_data(led_from_usb), 
    .kbd_data(kbd_data), 
    .kbd_available(kbd_available),
    .read_kbd(read_kbd),
    .roll_out(roll)
    );

    assign cpu_oe = ~(cpu_rd & (seq[2] == 0) & (seq[0] == 1) & cpu_rdy ); 
    assign cpu_we = ~(cpu_wt & (seq[1:0]== 2'b01) );


   kbd_intf kbd_intf (
    .mclk25(mclk25), 
    .reset_in(reset_in), 
    .PS2_Clk(PS2_Clk), 
    .PS2_Data(PS2_Data), 
  //  .shift(shift), 
    .ascii(ascii), 
    .kbd_available(kbd_available), 
    .read_kb(read_kbd)
    );


   /*
	always @(posedge mclk25) begin
	 if(kbd_data_wr)
		kbd_available <= 1;
	 else if(read_kbd & (seq[1:0]== 2'b01))
	 	kbd_available <= 0;
	 
     end
   */
	always @(posedge mclk25) begin
		if(~cpu_oe & (seq == 3'b001))
	   	  	latched_ram_data <= ram_a_data;
     end

	always @(posedge mclk25) begin
		if(~usb_oe)
	  		data_to_interface = ram_a_data;
	end

	always @(negedge mclk25) begin
	    if(cpu_wt)
		   data_from_cpu <= cpu_out;
		
	end

   always @(posedge mclk25) begin
      if(reset_in) begin
	 	clk_cpu_count <= 0;
	 	seq <= 0;
		one_shot <= 0;
      end
      else begin
		clk_cpu_count <= clk_cpu_count + 1;
	 	seq <= {seq[1:0],( cpu_rd | cpu_wt) & clk_cpu };
		one_shot <= {one_shot[0], ( cpu_rd | cpu_wt)};
      end
      
   end  
 
  /*  
   always @(negedge mclk25) begin
   	if(~vga_oe)
		videodata =  ram_a_data;
   end
    
 
   always @(negedge CLK0_OUT) begin
   	if(vga_state == 2'b10)
			videodata =  ram_a_data;
   end

   always @(vga_state or next_vga_state or x or mclk25 or usb_we or usb_oe or ram_a_data) begin
	 case (vga_state) 
	 	2'b00: // idle
			if(x[3:0] == 4'b 0001)
				next_vga_state <= 2'b01;
			else 
				next_vga_state <= 2'b00;

		2'b01: // need to fetch a word
			if(( mclk25 == 1'b1) & usb_we & usb_oe) // negedge of mclk25
				next_vga_state <= 2'b10;
			else 
				next_vga_state <= 2'b01;

		2'b10: // active state
			begin 
				next_vga_state <= 2'b00;
				
			end

		default :
			next_vga_state <= 2'b00;

	 endcase
    end
    */

// Instantiate the module
clkdiv2 instance_name (
    .RST_IN(RST_IN), 
    .LOCKED_OUT(LOCKED_OUT), 
    .CLKIN_IN(mclk), 
    .CLKDV_OUT(CLKDV_OUT), 
    .CLKIN_IBUFG_OUT(CLKIN_IBUFG_OUT), 
    .CLK0_OUT(CLK0_OUT)
    );


    wire [7:0]read_cap;
    wire [2:0]cap_rd_sel;
    wire cap_rd;

    wire [3:0] capt_flags;
    wire cap_wr;
    assign cap_wr = ((cpu_rd | cpu_wt) & (seq[1:0] == 2'b01) & cpu_rdy);

    assign capt_flags = { cpu_byte, _cpu_inst, cpu_rd , cpu_wt};

   capture capture (
    .res(reset_in), 
    .clk25(mclk25), 
    .cap_addr(cpu_adr), 
    .cap_dat(ram_a_data),
    .flags(capt_flags), 
    .cap_wr(cap_wr), 
    .read_cap_l(read_cap), 
    .cap_rd(cap_rd), 
    .cap_rd_sel(cap_rd_sel)
    );

     
   
   // Instantiate the module
usbintf usb_intf (
    .mclk(usb_clk[1]), 
    .reset_in(reset_in), 
    .pdb(pdb), 
    .astb(astb), 
    .dstb(dstb), 
    .pwr(pwr), 
    .pwait(pwait), 
    .led(led_from_usb), 
    .switch(read_cap), 	// use this input for captured data
    .ram_addr(usb_addr), 
    .usb_ouT_data(usb_a_data),
    .in_ramdata(data_to_interface), 
    .ram_a_lb(usb_a_lb), 
    .ram_a_ub(usb_a_ub), 
    .ram_we(usb_we), 
    .ram_oe(usb_oe),
//    .kbd_data_wr(kbd_data_wr),
    .cap_rd(cap_rd), 
    .cap_rd_sel(cap_rd_sel),
    .match_val_u(match_val_u),
	.match_mask_u (match_mask_u)
 );

    
   
   sync_gen25 syncgen( .clk(mclk25), .res(reset_in), .CounterX(x), .CounterY(y), 
		       .Valid(valid), .vga_h_sync(hs), .vga_v_sync(vs));


   shifter shifter(.clk25(mclk25),.color(color),.R(R),.G(G),.B(B),
		   .valid(valid),.data(ram_a_data),.x(x),.load(load));
		//   .valid(valid),.data(videodata),.x(x),.load(load));

  hex_7seg hex_7seg(.hex_digit(digit7),
  	.a(segment_a),.b(segment_b),.c(segment_c),.d(segment_d),
	.e(segment_e),.f(segment_f),.g(segment_g));

  assign digit_select = cntr[12:11];

  always @(digit_select or digit_anode ) begin
	case(digit_select) 
        2'b 00:
	   	digit_anode = 4'b 1110;
	   2'b 01:
	   	digit_anode = 4'b 1101;
	   2'b 10:
	   	digit_anode = 4'b 1011;
	   2'b 11:
	   	digit_anode = 4'b 0111;
	endcase
  end

 // assign 	disp_7seg_data = {8'h00, count1  }; //'h1234;
  assign 	disp_7seg_data = switch[5]? latched_ram_data: cpu_adr;

  assign 	digit7 = (digit_select == 2'b 00)? disp_7seg_data[3:0]:
  	(digit_select == 2'b 01)? disp_7seg_data[7:4]:
  	(digit_select == 2'b 10)? disp_7seg_data[11:8]: disp_7seg_data[15:12];
  	

  assign dot  = cntr[23] ;
   
  assign RST_IN = 1'b0;
  assign vga_addr = { y[8:1] - 'o0330 + roll , x[8:4]};
  assign ram_a_ce = 0; // always on
    
  assign ram_addr = ~(cpu_oe & cpu_we) ? {1'b0, cpu_adr[15:1]}: // cpu has top priority
  		~(usb_we & usb_oe)? usb_addr:			// usb if needed 
  		 {5'b00001, vga_addr};
		
		  
  				 
  assign ram_a_data =  ~cpu_we? data_from_cpu: 
  					~usb_we ? usb_a_data : 
					16'b zzzzzzzzzzzzzzzz ;

  assign ram_a_lb = ~( cpu_oe & cpu_we )? cpu_lb:
  				~( usb_oe & usb_we )? usb_a_lb: 0;
  	  
  assign ram_a_ub = ~( cpu_oe & cpu_we )? cpu_ub:
  				~( usb_oe & usb_we )? usb_a_ub: 0;
  
  
  //assign ram_we = not_video_access ? usb_we: 1; // video never writes
  //assign ram_oe = not_video_access ? usb_oe: vga_oe;

  assign ram_oe = usb_oe & vga_oe & cpu_oe; // either one active low
  assign ram_we = usb_we & cpu_we; // video never writes


  assign      color = switch[0];
  // assign      not_video_access = switch[1];
   //assign      not_video_access = ~(vga_state == 2'b10);

   assign      video_access = load & switch[1];  // always read video data at the first half of a cycle 
   
   //assign      videodata= 'h A363;
  // assign      video_rd = load & m_clock;

  assign  mclk25 = CLKDV_OUT;
  //assign vga_oe = ~(vga_state == 2'b10);
  assign vga_oe = ~	video_access;

  always @(posedge mclk25) begin
  	if(reset_in)
		usb_clk <= 0;
	else
		usb_clk <= usb_clk + 1;
  end
   

 wire char_rom_cs, char_rom_rw; 
 wire [10:0] char_rom_addr; 
 wire [7:0] char_rom_rdata; 
 wire [7:0] char_rom_wdata;
 wire show_char_line;
 wire [3:0] char_line;
 wire char_bit;
 wire [6:0] char_code;

 wire [2:0] sel_bit;

 

 assign  char_rom_rw = 1;
 assign  char_rom_cs = 1;
 assign   char_rom_wdata = 0;
 //assign show_char_line =  (y[9:4] == 0); // top line
 assign show_char_line =  ((y[9:4] == 6'b 100001) & ~x[9]); // line after the valid screen
 assign char_line = y[3:0];

 assign  sel_bit = ~x[2:0];
 assign  char_code = x[9:3]+ 'h30;
 assign  char_rom_addr = {char_code, char_line};
 assign  char_bit = char_rom_rdata[sel_bit];

  /*
  char_rom char_rom (
    .clk(mclk25), 
    .rst(reset_in), 
    .cs(char_rom_cs), 
    .rw(char_rom_rw), 
    .addr(char_rom_addr), 
    .rdata(char_rom_rdata), 
    .wdata(char_rom_wdata)
    );
   */


   always @(posedge mclk25) begin
   	if (valid) begin
			RED = R;
			GREEN = G;
			BLUE	=B;
	end  
	else	begin
	  if(show_char_line) begin
			RED = char_bit;
			GREEN = char_bit;
			BLUE	= char_bit;
		end
		else	 begin
			RED = 0;
			GREEN = 0;
			BLUE	=0;
		end
	end
   end

   
  always @(posedge mclk25) begin
    cntr <= cntr + 1'b 1;
  end

  
endmodule
