module core ( p_reset , m_clock ,cpu_rdy, wt , rd , in , out , adr , byte,
 _cpu_inst, kbd_data, kbd_available, read_kbd, roll_out);
  input p_reset, m_clock;
    
  wire [2:0] _Arbiter_cpu_pri;
  wire [7:0] _Arbiter_vector;
  reg [15:0] _cpu_dati;
  wire [15:0] _cpu_dato;
  wire [15:0] _cpu_adrs;
  wire _cpu_irq_in;
  wire _cpu_error;
  wire _cpu_fault;
  wire _cpu_rd;
  wire _cpu_wt;
  wire _cpu_byte;
  wire _cpu_int_ack;
  wire [7:0] _cpu_pswout;
  output _cpu_inst, read_kbd;
  input kbd_available;
  input [7:0] kbd_data;
  output [7:0] roll_out;

  wire rom_space;
  wire ram_space;
  wire reg_space;
  wire bad_reg;
  wire kbd_state_sel;
  wire kbd_data_sel;
  wire roll_sel;
  wire initreg_sel;
  wire usr_sel;


  reg bad_addr;

  
  reg kbd_int_flag; // bit 6 - IRQ en
  reg [15:0] init_reg;
  reg [15:0] roll;
  

  output wt;
  output rd;
  input [15:0] in;
  input       cpu_rdy;
  wire cpu_rdy_internal;
 
  output [15:0] out;
  output [15:0] adr;
  output byte;

  wire [15:0] cpu_dati;
  wire [15:0] kbd_int_vector;
  wire AR2;

  assign AR2 = 0;
  assign kbd_int_vector = AR2? 'o0274: 'o060;
   
  assign      cpu_dati = ( _cpu_int_ack)? kbd_int_vector : _cpu_dati;


pop11 cpu (.p_reset(p_reset), .m_clock(m_clock), .inst(_cpu_inst), 
	 .pswout(_cpu_pswout), .int_ack(_cpu_int_ack), .byte(_cpu_byte), 
	.wt(_cpu_wt), .rd(_cpu_rd), .fault(_cpu_fault), .error(_cpu_error), 
	.rdy(cpu_rdy_internal), .irq_in(_cpu_irq_in), .adrs(_cpu_adrs), 
	.dato(_cpu_dato), .dati(cpu_dati)
);


   assign roll_out = roll[7:0];
   assign cpu_rdy_internal = cpu_rdy & ~bad_addr;
  // assign kbd_available = kbd_flags[1];
   assign _Arbiter_cpu_pri = _cpu_pswout[7:5];
//   assign _cpu_dati = in;

   //assign _cpu_irq_in = 1'b0;
//   assign _cpu_rdy = 1'b1;
//   assign _cpu_error = 1'b0;
   assign _cpu_fault = 1'b0;

   assign adr = _cpu_adrs;
   assign byte = _cpu_byte;
   assign wt = _cpu_wt & ram_space;// & ~m_clock;
   assign rd = _cpu_rd & (ram_space | rom_space) ;// & ~m_clock;
   assign out = (_cpu_byte & _cpu_adrs[0])?{ _cpu_dato[7:0], _cpu_dato[7:0]}:_cpu_dato;



// anything below 0x8000 is ram 
   assign ram_space = ~_cpu_adrs[15];
   assign reg_space = _cpu_adrs[15:7] == 9'b111111111;
   assign rom_space = _cpu_adrs[15] & ~reg_space;

   assign kbd_state_sel = (_cpu_adrs[6:0] == 'o060);
   assign kbd_data_sel = (_cpu_adrs[6:0] == 'o062);
   assign roll_sel = (_cpu_adrs[6:0] == 'o064);
   assign initreg_sel = (_cpu_adrs[6:0] == 'o116);
   assign usr_sel = (_cpu_adrs[6:0] == 'o114);
   assign bad_reg = ~(kbd_state_sel | kbd_data_sel |roll_sel |initreg_sel | usr_sel );

   assign read_kbd = kbd_data_sel;
   assign _cpu_error = bad_addr;

   
   

   always @(posedge p_reset) begin
    //   kbd_int_flag <= 0;
       init_reg  <= 16'b1000000011111000;
      // kbd_data <= 8'b00000000;
      // roll <= 'h ff;
   end

   assign _cpu_irq_in = kbd_available & ~kbd_int_flag &(_Arbiter_cpu_pri == 0);

   always @(negedge m_clock) begin

     if(p_reset) begin
		   kbd_int_flag <= 0;
		   roll = 'o01330;
	end
	else  begin
	if (reg_space) begin
	  if( bad_reg)
		bad_addr = 1;
	  else begin  // good access to reg space
		bad_addr = 0;

		if( _cpu_wt) begin // all reg writes
			if( kbd_state_sel) 
	   			kbd_int_flag <= _cpu_dato[6];
			if(roll_sel)
				roll = _cpu_dato;
		end
		if(_cpu_rd) begin
	   		if(kbd_data_sel ) begin
	     		_cpu_dati = {8'b0000000, kbd_data};
	   		end
	   		else   if(kbd_state_sel  )
	     		_cpu_dati = {8'b0000000, kbd_available, kbd_int_flag,6'b000000};

	   		else   if(initreg_sel  )
	     		_cpu_dati = init_reg;

	   		else if(roll_sel )
		 		_cpu_dati = roll;
		end // rd

	  end // good access to reg space
	 end	 //reg space
	
	 else if (rom_space & _cpu_wt)
	 		bad_addr = 1;
	
 	 else if (  _cpu_rd & ~reg_space) begin
	 	bad_addr = 0;
	 	if( ~_cpu_byte)
			_cpu_dati = in;
		// byte read instructions
		else if(_cpu_adrs[0])
			_cpu_dati = {8'b0000000, in[15:8]} ;
		else
			_cpu_dati = {8'b0000000,in[7:0]} ;
        end
     end
	end


endmodule
