/******************** MODULE INFO  ****************************
*
*  File name   :   pdp11timer.s
*
*  AUTHOR      :   Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp)
*  VERSION     :   1.1                                        
*  DATE        :   Sat Jun 21 2003
*
*  Assembler   :   GNU GAS
*  Project     :   proc  Real-Time Kernel
*  Contents    :   Real-Time Kernel low level functions for timer
*                  Processor dependent: pdp11
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
* Porting for PDP/11 by Naohiko Shimizu, Tokai University, Japan.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Naohiko Shimizu (nshimizu@keyaki.cc.u-tokai.ac.jp) October 09. 2002:
*        Porting for PDP/11
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
//* typedef struct pid {
//*   struct pid *next;	/* next pid on list                  */
//*   char	*stack;	/* stack of process when not running    */
//*   char	*ws;	/* work space ptr                       */
//*   int	wssize;	/* work space size                      */
//*   int	age;	/* awake age                            */
//*   int	sleep;	/* sleeping if != 0                     */
//*   int	priority;	/* priority. 0 is highest               */
//*   struct pid *sema;	/*                                      */
//* } PID;
//*
//*
//*    The only slots used in this file is: PID_STACK, PID_AGE
//*

PID_NEXT     =   0
PID_STACK    =   2
PID_WS       =   4
PID_WSSIZE   =   6
PID_AGE      =   8
PID_SLEEP    =   10
PID_PRIORITY =   12
PID_SEMA     =   14

PS	=	0177776

	.text
	.even


/*------  Global variables  ---------------------------------------------*/
//*
//*  extern PID   *proc_curpid;   /* pointer to current process         */
//*  extern char  proc_nodisp;    /* disallow tick dispatch if not zero */
//*  extern int   proc_runcnt;    /* number of running processes        */
//*

   .globl  _timerintfunc



/* ========  timerintfunc  =======================
*
*   Purpose:      Timer interrupt function to be called
*                 each timer interrupt.
*             NB: This is an inferrupt entry point,
*                 not a normal C function
*
*
*/

_timerintfunc:

     mov      r0,-(sp)
     mov      r1,-(sp)
     mov      r2,-(sp)
     mov      r3,-(sp)
     mov      r4,-(sp)
     mov      r5,-(sp)
     jsr      pc, _timerCheckList
     tst      r0
     beq      tinot
     mov      $1,_forcereschedule
tinot:
     cmp      $-1,_proc_maxage
     beq      tidont
     mov      _proc_curpid,r1
     mov      PID_AGE(r1),r0
     cmp      _proc_maxage,r0
     bcc      tidoit
     add      $1,PID_AGE(r1)
     br       tidont
tidoit:
     mov      $1,_forcereschedule
tidont:
     mov      (sp)+,r5
     mov      (sp)+,r4
     mov      (sp)+,r3
     mov      (sp)+,r2
     mov      (sp)+,r1
     mov      (sp)+,r0

     tst      _forcereschedule
     bne      pcr1
     rti
pcr1:
     tst      _proc_nodisp
     beq      pcr2
     rti

pcr2:
     sub     $2,sp
     mov     2(sp),(sp)
     mov     4(sp),2(sp)
     mov     (sp),4(sp)
     mov     $_procReschedule,(sp)
     rti

