/******************* FILE - HEADING **************************
*
*   File name	:  packet1.c
*/
/*  DATE        :  Tue Jul 27 08:56:44 1999                   */
/*  AUTHOR      :  Jan Erik Nilsen (jen@nilsenelektronikk.no) */
/*  VERSION     :  3.0                                        */
/*
*   Compiler    :  ANSI C
*   Project     :  proc  Real-Time Kernel
*   Contents	:  More packet stuff
*
*
* Copyright (c) nilsen elektronikk as, Norway. (www.nilsenelektronikk.no)
* This software is the property of nilsen elektronikk as, Norway.
*
* The proc RTOS is free software; you can use it, redistribute it
* and/or modify it under the following terms:
* 1. You are not allowed to remove or modify this copyright notice
*    and License paragraphs, even if parts of the software is used.
* 2. The improvements and/or extentions you make SHALL be available
*    for the community under THIS license, source code included.
*    Improvements or extentions, including adaptions to new architectures,
*    SHALL be reported and transmitted to Nilsen Elektronikk AS.
* 3. You must cause the modified files to carry prominent notices stating
*    that you changed the files, what you did and the date of changes.
* 4. You may NOT distribute this software under another license without
*    explisit permission from Nilsen Elektronikk AS, Norway.
* 5. This software is free, and distributed in the hope that it will be
*    useful, but WITHOUT ANY WARRANTY; without even the implied warranty
*    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*    You SHALL NOT use this software unless you accept to carry all
*    risk and cost of defects or limitations.
*
*    ------------  CHANGE RECORD  ----------------
*    Jan Erik Nilsen (jen@nilsenelektronikk.no) July 26. 1999:
*        First free version of this software published.
*
*/
#define  NULL (void *)0
#include "proc.h"
#include "packet.h"




/*===========  packetInPool  =======================
*
*   Purpose:      If the packet is found in the pool,
*                 return(1) else return(0);
*
*   Input:        ptr to Packet
*   Output:       none
*   Return:       Found? 1 else 0
*
*/
int packetInPool(PACKET *pp)
{
  PACKET *px;
  PACKETPOOL *h;

  if (pp == NULL) return(0);
  h = pp->ppool;

  BEGIN_CRITICAL_REGION();
  for (px = h->packetstart; px && px != pp; px = px->next);
  END_CRITICAL_REGION();
  return((px == pp)? 1 : 0);
}




/*===========  packetsUsed  =========================
*
*   Purpose:      Returns number of packets in use
*
*/
int packetsUsed(PACKETPOOL *h)
{
  int i;
#ifdef REINT
  int sr;
#endif
  disable_interrupt();
  i = h->packetleft.value;
  enable_interrupt();
  return(h->packetnum - i);
}




/*===========  packetsLeft  =========================
*
*   Purpose:      Returns number of packets left
*
*/
int packetsLeft(PACKETPOOL *h)
{
  int i;
#ifdef REINT
  int sr;
#endif
  disable_interrupt();
  i = h->packetleft.value;
  enable_interrupt();
  return(i);
}




/*===========  packetsUsedMax  =========================
*
*   Purpose:      Returns the maximum number of packets in use
*
*/
int packetsUsedMax(PACKETPOOL *h)
{
  int i;
#ifdef REINT
  int sr;
#endif
  disable_interrupt();
  i = h->packetusedmax;
  enable_interrupt();
  return(i);
}
