/*
 * Decompiled with CFR 0.152.
 */
package bk2010.preferences.types;

import bk2010.preferences.PathStrings;
import bk2010.preferences.storage.ConfigFile;
import bk2010.preferences.storage.Setting;
import bk2010.preferences.types.OnOff;
import java.io.File;

public class Tape {
    public final boolean isOutput;
    public OnOff useTape = new OnOff("Use tape", false);
    public OnOff motorControl = new OnOff("Enable motor control", true);
    public File tapeFile;

    public Tape(String defaultFN, boolean toWrite) {
        this.isOutput = toWrite;
        this.tapeFile = new File(String.valueOf(PathStrings.tapeImagesPath) + defaultFN);
    }

    public Tape(File defaultFile, boolean toWrite) {
        this.isOutput = toWrite;
        this.tapeFile = defaultFile;
    }

    public void saveTo(ConfigFile cf, String prefix) {
        String imageName = String.valueOf(prefix) + "Wave";
        Setting s = cf.getSetting(imageName);
        s = s == null ? new Setting(imageName, this.tapeFile.getPath(), "") : new Setting(s.name, this.tapeFile.getPath(), s.comments);
        cf.setSetting(s);
        this.useTape.saveTo(cf, prefix);
        this.motorControl.saveTo(cf, prefix);
    }

    public void readFrom(ConfigFile cf, String prefix) {
        this.useTape.readFrom(cf, prefix);
        this.motorControl.readFrom(cf, prefix);
        String imageName = String.valueOf(prefix) + "Wave";
        Setting s = cf.getSetting(imageName);
        if (s == null || s.value.isEmpty()) {
            return;
        }
        this.tapeFile = new File(s.value);
    }
}

