/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.ShutdownMonitor;
import bk2010.Shutdownable;
import bk2010.hardware.Timed;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class FloppyDisk
implements Timed,
Shutdownable {
    protected static final int TF_RPS = 5;
    protected static final int TF_TRACKLENGTH = 3125;
    protected static final int TF_INDEXPOS = 3110;
    protected static final int TF_AMLENGTH = 8;
    protected static final int TF_1STIDAM = 21;
    protected static final int TF_1STID = 29;
    protected static final int TF_1STDATAAM = 43;
    protected static final int TF_1STDATA = 51;
    protected static final int TF_SECTORLENGTH = 304;
    protected static final int TS_DATAMASK = 65535;
    protected static final int TS_MARKER = 65536;
    protected static final int TS_CRC = 131072;
    protected final long cyclesPerWord;
    protected long subWordCycles;
    protected File imageFile;
    protected RandomAccessFile imageAccess;
    protected long imageSize;
    protected int[] rawTrack = new int[6250];
    protected byte[] imageTrack = new byte[10240];
    protected boolean isMounted;
    protected boolean readOnly;
    protected int track;
    protected int trackPos;
    protected boolean trackDirty;
    protected boolean wordChanged;
    protected boolean isWriting;
    protected boolean writingMarker;
    protected boolean gotWrite;
    protected int writeData;
    protected int lastHead;
    protected boolean verbose = false;

    public FloppyDisk(long clockFrequency) {
        long tmp = clockFrequency / 15625L;
        this.cyclesPerWord = tmp + (tmp >> 4);
    }

    protected void initCRC() {
    }

    protected void updateCRC(int data) {
    }

    protected int getCRC() {
        return 196607;
    }

    protected int writeAM(int offset, int type) {
        int i = 0;
        while (i < 6) {
            this.rawTrack[offset++] = 0;
            ++i;
        }
        this.rawTrack[offset++] = 106913;
        this.rawTrack[offset++] = 0x1A100 | type & 0xFF;
        return offset;
    }

    protected void convertImageTrackToRaw() {
        Arrays.fill(this.rawTrack, 20046);
        int sector = 0;
        while (sector < 10) {
            int head = 0;
            while (head < 2) {
                int ofs = 21 + sector * 304 + head * 3125;
                ofs = this.writeAM(ofs, 254);
                this.initCRC();
                int tmp = head + (this.track << 8);
                this.rawTrack[ofs++] = tmp;
                this.updateCRC(tmp);
                tmp = sector + 1 << 8 | 2;
                this.rawTrack[ofs++] = tmp;
                this.updateCRC(tmp);
                this.rawTrack[ofs++] = this.getCRC();
                int dataofs = (sector + head * 10) * 512;
                ofs = 43 + sector * 304 + head * 3125;
                ofs = this.writeAM(ofs, 251);
                this.initCRC();
                int i = 0;
                while (i < 256) {
                    tmp = (this.imageTrack[dataofs++] & 0xFF) << 8;
                    this.rawTrack[ofs++] = tmp |= this.imageTrack[dataofs++] & 0xFF;
                    this.updateCRC(tmp);
                    ++i;
                }
                this.rawTrack[ofs++] = this.getCRC();
                ++head;
            }
            ++sector;
        }
    }

    protected void convertRawTrackToImage() {
        int sector = 0;
        int word = 0;
        int state = 0;
        boolean reported = false;
        if (this.verbose) {
            System.out.println();
        }
        if (this.verbose) {
            System.out.println("\nFDD: Analyzing raw track " + this.track);
        }
        int head = 0;
        while (head < 2) {
            if (this.verbose) {
                System.out.println("Head " + head);
            }
            state = 0;
            int ofs = 0;
            while (ofs < 3125) {
                int data = this.rawTrack[ofs + head * 3125];
                block0 : switch (state) {
                    case 0: {
                        if ((data & 0x10000) == 0 || (data & 0xFFFF) != 41470) break;
                        state = 1;
                        word = 0;
                        if (!this.verbose) break;
                        System.out.println("Found sector address marker");
                        break;
                    }
                    case 1: {
                        switch (++word) {
                            case 1: {
                                if ((data & 0xFFFF) == (this.track << 8 | head)) break block0;
                                if (this.verbose) {
                                    System.out.println("Invalid cylinder/head");
                                } else if (!reported) {
                                    reported = true;
                                    System.out.println("\nBroken write at track " + this.track);
                                }
                                state = 0;
                                break;
                            }
                            case 2: {
                                if ((data & 0xFF) != 2) {
                                    if (this.verbose) {
                                        System.out.println("Invalid sector size");
                                    } else if (!reported) {
                                        reported = true;
                                        System.out.println("\nBroken write at track " + this.track);
                                    }
                                    state = 0;
                                    break;
                                }
                                sector = (data & 0xFFFF) >> 8;
                                if (sector >= 1 && sector <= 10) break block0;
                                if (this.verbose) {
                                    System.out.println("Invalid sector number");
                                } else if (!reported) {
                                    reported = true;
                                    System.out.println("\nBroken write at track " + this.track);
                                }
                                state = 0;
                                break;
                            }
                            case 3: {
                                if ((data & 0x20000) != 0) {
                                    if (this.verbose) {
                                        System.out.println("Found sector " + sector);
                                    }
                                    state = 2;
                                    break;
                                }
                            }
                            default: {
                                state = 0;
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((data & 0x10000) == 0) break;
                        if ((data &= 0xFFFF) == 41470) {
                            state = 1;
                            word = 0;
                            if (!this.verbose) break;
                            System.out.println("Found sector address marker");
                            break;
                        }
                        if (data != 41467 && data != 41464) break;
                        state = 3;
                        word = 0;
                        if (!this.verbose) break;
                        System.out.println("Found sector data marker");
                        break;
                    }
                    case 3: {
                        if (word++ < 256) break;
                        if ((data & 0x20000) == 0) {
                            state = 0;
                            if (!this.verbose) break;
                            System.out.println("No CRC");
                            break;
                        }
                        int imageOfs = 512 * (sector - 1 + head * 10);
                        int rawOfs = ofs - 256 + head * 3125;
                        int i = 0;
                        while (i < 256) {
                            int tmp = this.rawTrack[rawOfs++] & 0xFFFF;
                            this.imageTrack[imageOfs++] = (byte)(tmp >> 8);
                            this.imageTrack[imageOfs++] = (byte)tmp;
                            ++i;
                        }
                        state = 0;
                        if (!this.verbose) break;
                        System.out.println("Sector converted");
                        break;
                    }
                    default: {
                        state = 0;
                    }
                }
                ++ofs;
            }
            ++head;
        }
    }

    protected void saveTrack() {
        if (this.isMounted && !this.readOnly && this.trackDirty) {
            this.convertRawTrackToImage();
            long ofs = this.track * 512 * 10 * 2;
            boolean ext = ofs + 10240L > this.imageSize;
            try {
                this.imageAccess.seek(ofs);
                this.imageAccess.write(this.imageTrack);
                if (ext) {
                    this.imageSize = this.imageAccess.length();
                }
            }
            catch (IOException e) {
                System.out.println("\nCannot write to disk image");
            }
        }
        this.trackDirty = false;
    }

    protected void loadTrack() {
        long ofs;
        long len;
        Arrays.fill(this.imageTrack, (byte)0);
        if (this.isMounted && (len = Math.min(10240L, this.imageSize - (ofs = (long)(this.track * 512 * 10 * 2)))) > 0L) {
            try {
                this.imageAccess.seek(ofs);
                this.imageAccess.read(this.imageTrack, 0, (int)len);
            }
            catch (IOException e) {
                System.out.println("\nError reading disk image file");
            }
        }
        this.convertImageTrackToRaw();
        this.trackDirty = false;
        if (this.verbose) {
            System.out.printf("\nFDD: selected track %d\n", this.track);
        }
    }

    public void unmountImage() {
        if (this.isMounted) {
            this.saveTrack();
            try {
                this.imageAccess.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.imageAccess = null;
        this.imageFile = null;
        this.imageSize = 0L;
        this.isMounted = false;
        ShutdownMonitor.remove(this);
    }

    public boolean mountImage(File file, boolean readOnly) {
        this.unmountImage();
        try {
            this.imageFile = file;
            if (readOnly || !this.imageFile.canWrite()) {
                this.readOnly = true;
                this.imageAccess = new RandomAccessFile(file, "r");
            } else {
                this.readOnly = false;
                this.imageAccess = new RandomAccessFile(file, "rw");
            }
            this.imageSize = this.imageAccess.length();
            System.out.printf("\nFDD: Mounted image %s\n", file.getCanonicalFile());
            this.isMounted = true;
            this.loadTrack();
        }
        catch (IOException e) {
            this.imageAccess = null;
            this.imageFile = null;
            this.imageSize = 0L;
            this.isMounted = false;
            return false;
        }
        if (this.isMounted) {
            ShutdownMonitor.add(this);
        }
        return this.isMounted;
    }

    public void stepPlus() {
        if (this.track < 82) {
            this.saveTrack();
            ++this.track;
            this.loadTrack();
        }
    }

    public void stepMinus() {
        if (this.track > 0) {
            this.saveTrack();
            --this.track;
            this.loadTrack();
        }
    }

    public int getStatus(int head) {
        int tmp = 0;
        if (this.readOnly) {
            tmp |= 4;
        }
        tmp |= this.track == 0 ? 1 : 0;
        if (this.isMounted && this.trackPos >= 3110) {
            tmp |= 0x8000;
        }
        if (this.isWriting) {
            if (!this.gotWrite) {
                tmp |= 0x80;
            }
            if (this.wordChanged && !this.gotWrite) {
                tmp |= 0x4000;
            }
        } else {
            if (this.wordChanged) {
                tmp |= 0x80;
            }
            if ((this.rawTrack[this.trackPos + head * 3125] & 0x20000) != 0) {
                tmp |= 0x4000;
            }
        }
        if (this.verbose) {
            System.out.printf("\nFDD: reading status word %08o at track position %d\n", tmp, this.trackPos);
        }
        return tmp;
    }

    public int getData(int head) {
        this.wordChanged = false;
        if (!this.isMounted) {
            return 0;
        }
        if (this.verbose) {
            System.out.printf("\nFDD: reading data word %05x at track position %d\n", this.rawTrack[this.trackPos + head * 3125], this.trackPos);
        }
        return this.rawTrack[this.trackPos + head * 3125];
    }

    public boolean isMarker(int head) {
        if (!this.isMounted) {
            return false;
        }
        if (this.verbose) {
            System.out.printf("\nFDD: Scanning for marker at track position %d\n", this.trackPos);
        }
        return (this.rawTrack[this.trackPos + head * 3125] & 0x10000) != 0;
    }

    public void setMarker(boolean isMarker) {
        if (this.writingMarker && !isMarker) {
            this.initCRC();
        }
        this.writingMarker = isMarker;
        if (this.verbose) {
            System.out.println("\nFDD: writing marker mode set to " + isMarker);
        }
    }

    public void deferredWrite(int head, int data) {
        this.isWriting = true;
        this.gotWrite = true;
        this.writeData = ((data &= 0xFFFF) & 0xFF) << 8 | data >> 8 & 0xFF;
        this.updateCRC(data);
        this.wordChanged = false;
        this.lastHead = head;
        this.trackDirty = true;
        if (this.verbose) {
            System.out.printf("\nFDD: writing data word %05x\n", data);
        }
    }

    protected void updateWriteState() {
        if (this.gotWrite) {
            if (!this.readOnly) {
                if (this.verbose) {
                    System.out.printf("\nFDD: physically writing data word %05x at track position %d\n", this.writeData, this.trackPos);
                }
                this.rawTrack[this.trackPos + this.lastHead * 3125] = this.writeData | (this.writingMarker ? 65536 : 0);
            }
            this.gotWrite = false;
            this.wordChanged = false;
            return;
        }
        if (!this.wordChanged) {
            if (!this.readOnly) {
                if (this.verbose) {
                    System.out.printf("\nFDD: physically writing CRC at track position %d\n", this.trackPos);
                }
                this.rawTrack[this.trackPos + this.lastHead * 3125] = this.getCRC() | (this.writingMarker ? 65536 : 0);
            }
            this.wordChanged = true;
        } else {
            this.isWriting = false;
        }
    }

    @Override
    public void cycles(long howMany) {
        this.subWordCycles += howMany;
        if (this.subWordCycles < this.cyclesPerWord) {
            return;
        }
        this.subWordCycles -= this.cyclesPerWord;
        ++this.trackPos;
        if (this.trackPos >= 3125) {
            this.trackPos = 0;
        }
        if (this.isWriting) {
            this.updateWriteState();
        } else {
            this.wordChanged = true;
        }
        if (this.subWordCycles < this.cyclesPerWord) {
            return;
        }
        ++this.trackPos;
        if (this.trackPos >= 3125) {
            this.trackPos = 0;
        }
        if (this.isWriting) {
            this.updateWriteState();
        }
        this.trackPos = (int)(((long)this.trackPos + this.subWordCycles / this.cyclesPerWord - 1L) % 3125L);
        this.subWordCycles %= this.cyclesPerWord;
    }

    public void flush() {
        if (this.isMounted && !this.readOnly && this.trackDirty) {
            this.saveTrack();
        }
    }

    protected void finalize() throws Throwable {
        this.unmountImage();
    }

    @Override
    public void shutdown() {
        this.unmountImage();
    }
}

