/*
 * Decompiled with CFR 0.152.
 */
package bk2010.io;

import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.preferences.PathStrings;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FakeTape {
    public static String extractFilename(QBusProxy machine, short address) {
        QBusReadDTO dto = new QBusReadDTO();
        StringBuffer name = new StringBuffer(21);
        int i = 0;
        while (i < 16) {
            if (!machine.readByte((short)(address + i), dto)) {
                return null;
            }
            int b = dto.getInt();
            if (b == 0) break;
            if ((b &= 0x7F) < 32 || b == 63 || b == 42 || b == 34 || b == 58 || b == 47 || b == 92 || b == 39 || b == 44 || b == 59) {
                b = 95;
            } else if (b >= 65 && b <= 90) {
                b += 32;
            }
            name.append((char)b);
            ++i;
        }
        return name.toString().trim();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void fakeTape(QBusProxy machine, short[] regs, boolean is11M) {
        short params = is11M ? regs[0] : regs[1];
        QBusReadDTO dto = new QBusReadDTO();
        System.out.printf("\nTape access with parameter block at %06o\n", params & 0xFFFF);
        machine.writeByte((short)(is11M ? 42 : params + 1), (byte)4);
        if (!machine.readByte(params, dto)) {
            return;
        }
        int operation = dto.getInt();
        if (operation == (is11M ? 1 : 3)) {
            String fnameBase = FakeTape.extractFilename(machine, (short)(params + 6));
            String fname = String.valueOf(PathStrings.binFilesPath) + fnameBase + ".bin";
            if (!machine.readWord((short)(params + 2), dto)) {
                return;
            }
            short addr = dto.value;
            System.out.printf("Reading file %s at address %08o\n", fname, addr & 0xFFFF);
            try {
                block26: {
                    FileInputStream ff;
                    try {
                        ff = new FileInputStream(fname);
                    }
                    catch (FileNotFoundException e) {
                        fname = String.valueOf(PathStrings.binFilesPath) + fnameBase.toUpperCase() + ".BIN";
                        ff = new FileInputStream(fname);
                    }
                    short size = 0;
                    if (addr == 0) {
                        addr = (short)(ff.read() | ff.read() << 8);
                    } else {
                        ff.read();
                        ff.read();
                    }
                    size = (short)(ff.read() | ff.read() << 8);
                    int i = 0;
                    while (true) {
                        if (i >= (size & 0xFFFF)) {
                            if (ff.read() != -1) {
                                System.out.println("WARNING: file is longer than it's header says; it may be corrupted");
                            }
                            ff.close();
                            if (!is11M) break;
                            machine.writeWord((short)(params + 24), addr);
                            machine.writeWord((short)(params + 26), size);
                            break block26;
                        }
                        machine.writeByte((short)(addr + i), (byte)ff.read());
                        ++i;
                    }
                    machine.writeWord((short)(params + 22), addr);
                    machine.writeWord((short)(params + 24), size);
                    machine.writeWord((short)180, addr);
                    machine.writeWord((short)182, size);
                }
                boolean fill = false;
                int i = 0;
                while (true) {
                    if (i >= 16) {
                        machine.writeByte((short)(params + 1), (byte)0);
                    }
                    if (!machine.readByte((short)(params + 6 + i), dto)) {
                        return;
                    }
                    byte b = (byte)dto.value;
                    if (fill || b == 0) {
                        fill = true;
                        b = 32;
                    }
                    machine.writeByte((short)(params + (is11M ? 28 : 26) + i), b);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found");
            }
            catch (IOException e) {
                System.out.println("Unexpected error while reading the file");
            }
        } else if (operation == (is11M ? 0 : 2)) {
            if (!machine.readWord((short)(params + 2), dto)) {
                return;
            }
            short addr = dto.value;
            if (!machine.readWord((short)(params + 4), dto)) {
                return;
            }
            short size = dto.value;
            String fname = String.valueOf(PathStrings.binFilesPath) + FakeTape.extractFilename(machine, (short)(params + 6)) + ".bin";
            System.out.printf("\nSaving file %s from address %08o with length %08o\n", fname, addr, size);
            try {
                FileOutputStream ff = new FileOutputStream(fname);
                ff.write(addr & 0xFF);
                ff.write(addr >> 8 & 0xFF);
                ff.write(size & 0xFF);
                ff.write(size >> 8 & 0xFF);
                while (true) {
                    short s = size;
                    size = (short)(s - 1);
                    if (s <= 0) {
                        ff.close();
                        machine.writeByte((short)(params + 1), (byte)0);
                        break;
                    }
                    short s2 = addr;
                    addr = (short)(s2 + 1);
                    machine.readByte(s2, dto);
                    ff.write(dto.getInt());
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Unable to open file for writing");
            }
            catch (IOException e) {
                System.out.println("Unexpected error while writing the file");
            }
        }
        machine.readWord(regs[6], dto);
        regs[7] = dto.value;
        regs[6] = (short)(regs[6] + 2);
    }
}

