! file:		descrip.mms
!
! Abstract:
!	This mms is the driver for the Common Console build.
!
! It presumes that the file CP_COMMON_LOGIN.COM has been executed, which sets
! up the appropriate logicals.
!
! History:
!	At end of file
!

cfg = cp$cfg:
exe = cp$exe:
inc = cp$inc:
lis = cp$lis:
obj = cp$obj:
src = cp$src:

first_target :
	@ write sys$output "You have to explicitly specify a target"


# Pick up the definitions for $(platform), $(arch), and optionally $(config).
# Options also have macros defined, if they are nonzero.

.include	$(cfg)macros.mms


# Standard cross-compiler and tool setup.

.include	$(src)setup.mms


# Pull in the GEMCC file dependencies generated by NEWBUILD.COM.

.include	$(cfg)depend.mms


# Pull in the object file dependencies generated by NEWBUILD.COM.

.include	$(cfg)objects.mms


# Each platform has its own build description file, and optionally separate
# configuration description files.  This reduces the hit rate on the common
# build files when a platform is coming online.

.include	$(src)platform_$(platform).mms
.IFDEF custom_config
.include	$(cfg)config_$(config).mms
.ENDIF


! History:
!----------------------------------------------------------------
!  18-Jul-1993	 phs	Split this file up into PLATFORM_<platform>.MMS for
!			each existing platform, plus PLATFORM_SUPPORT.MMS for
!			rules which are shared between platforms.  This should
!			isolate platform developers a little better, without
!			losing the ability to update common rules in a single
!			place.
!  08-Jul-1993	 mdr	Added Medulla target.
!  10-Jul-1993	 phs	Continue to tighten up constraints on .mar.lis, improve
!			handling of .c.lis vs. .c.obj dependencies (don't
!			compile everything twice).
!  08-Jul-1993	 phs	Add ability to build plus_list_optimized versions of
!			Jensen, Morgan, Sable, and LCads images.  Only tested
!			Jensen so far...
!  08-Jul-1993	 phs	Point to CP$REF to pick up SCANSYM.EXE.  This is to
!			make it clearer that SCANSYM.EXE is at the moment an
!			orphaned tool.  Once the nightly is built, we need to
!			go back and find out where SCANSYM.EXE came from, and
!			either build it from sources or handle it like other
!			tools (once we know how to handle them)...
!  07-Jul-1993	 phs	Add default rule for .c -> .lis, and rearrange the
!			suffix list so that the .c.lis and .lis.slis rules
!			can fire.
!
!  03-Jul-1993   phs	Add support for optimized COBRA build using the $(OPT)
!			macro.
!
!  03-Jul-1993	phs	Put back the dependencies which override the /vms
!			qualifier on the sdl/mar of cobra_regs and pr1701def.
!
!  07-Jul-1993	phs	Remove explicit command line flags that accompany the
!			floating format specifier on the fpscreen compiles.
!  04-Mar-1993  jad     add SABLE target
!
!  15-Jan-1993  pel     add MORGAN target
!
!  04-May-1992  db      add io_diag.c, scsi jumper/toy test
!
!  27-Apr-1992  db	add psc.c, PSC command
!
!  14-Apr-1992	pel	remove diag_template module
!
!  09-Apr-1992	db	add ee_log.c, iic bus eerom build/display cmd's
!
!  06-Mar-1992	pel	Add line.c, new shell command
!
!  30-Jan-1992	ajb	Broke apart shell_commands
!
!  30-Jan-1992  kp	Add COBRA_FEPROM_CHECKSUM.
!
!  19-Dec-1990  pel	Add swap_driver module.
!
!  11-Dec-1991	phk	replace blast by fbe_blast for FBE targets
!
!  10-Dec-1991	hcb	add ez_cobra and ez_pele
!
!  06-Dec-1991	phk	Simplify the FBE targets built
!                       Move kernel_vax from vax_objects to the 
!                       'vax_target'_objects
!
!  06-Dec-1991	db	Add Cobra IIC bus Drivers
!
!  26-Nov-1991	phk	Modify fbe.rom built
!
!  20-Nov-1991	pel	Add fbus_driver to cobra & pele targets
!
!  17-Nov-1991  phk     modify FBE xilinx code generation
!
!  19-Nov-1991	jad	Add cache coherency files.
!
!  08-Aug-1991	jad	Build for cb_proto.
!
!  19-Nov-1991  hcb     added cmm files to cobra build
!
!  17-Nov-1991  phk     move entry.obj,hwrpb_driver.obj & hwrpbtt_driver
!                       from common_objects to each target_objects 
!                       add fbe_sys & fbe_rom targets
!
!  14-Nov-1991  phk	modify fbe_xilinx awk command
!                       add blast to fbe target
!
!  08-Nov-1991  jeg	add blast to cb_proto, cobra and pele builds
!
!  24-Oct-1991	pel	Add lbus_driver & diag_lbus to cb_proto target
!
!  24-Oct-1991	hcb 	add eval and debug1 cb_proto build
!
!  16-Oct-1991	hcb 	add examine_driver to cb_proto build
!
!  15-Oct-1991	kp 	Replaced cosmic_user:[mdmmaint] with wrk:[mopload].
!
!  10-Oct-1991	phk	Replace el object by el_driver object
!                       Add tee_driver to the optionnal object list
!
!  09-Oct-1991	hcb	Platform split of memconfig
!
!  03-Oct-1991	pel	Add diag_tests to all builds.
!
!  03-Oct-1991	hcb	Add pio_driver to Cobra build
!
!  30-Sep-1991	pel	replace io_init w/ lbus_driver & diag_lbus
!
!  17-Sep-1991	pel	split specific_objects/.opt to midrange_objects/.opt so
!			laser_debug, mbx_driver aren't included in PELE target
!			Remove hcb; replace paul,ajb w/ debug1,debug2
!
!  17-Sep-1991	ajb	broke out timer from kernel.c
!
!  12-Sep-1991	phk	Add platform.mar to vaxscb compilation
!
!  11-Sep-1991	pel	Add io_init to pele & cobra object lists
!
!  11-Sep-1991	pel	Add mtpr_mfpr_call object to adu build.
!
!  10-Sep-1991	jad	Added memtest to cb_proto build.
!
!  22-Aug-1991	jds	Added XNA driver to calypso & laser builds.
!
!  20-Aug-1991	pel	add pele.obj. use it in place of cobra.obj for fbe
!			and pele targets.
!  
!  16-aug-1991  phk     add specific compilation action for 
!                       kernel.c, dma_driver.c & csr_driver.c:
!                       For Vax targets, these routines use 'pragma inline'
!                       directives which are effective only if the 
!			compilation is done with /optimize=(inline).
!                       mms_macros.mms defines 2 macros 'copt' & 'copt_iln'
!                       witch are similar for Alpha targets but specify
!                       inline or noinline option for Vax targets.
!                       noinline is the default option, inline is used for
!                       both kernel , dma_driver & csr_driver
!
!  08-Aug-1991	pel	add cobra_util mod (mailbox routines) for cobra build
!  
!   7-Aug-1991  cto	Add in xct_exer.
!  
!  07-Aug-1991	jrk	fix kernel_alpha (add platform.mar)
!
!  02-Aug-1991	ajb	added TR command for fbe
!
!  15-jul-1991  phk     add fbe xilinx module
!
!  11-jul-1991  phk     add fbe_rom target
!
!   1-Jul-1991  jrk	revise alpha instruction decode
!
!  27-Jun-1991	jad	Added ni_dvt.
!
!  26-Jun-1991  phk	add cb_proto target.
!
!  25-Jun-1991	jds	Added xmi_util module to calypso & laser builds.
!			Added puu_driver to laser builds.
!
!  11-Jun-1991  phk	add specific_objects list.
!                       move some objects from the common_objects list to 
!                       the specific_object list
!
!   7-Jun-1991	jds	Made xdelta.obj a permanent calypso object.
!
!   6-Jun-1991	jds	Added xcalypso target (calypso + xdelta).
!
!  03-Jun-1991  jrk	add gbus_driver to pele
!
!  31-May-1991  jrk	gbus_driver from optional to laser
!			more from optional to common
!
!  29-May-1991	jds	Added hwrpb_def.mar to alpha_fw.mlb.
!
!  23-May-1991	jds	Added callbacks_vax.mar.
!
!  16-May-1991  kp	Remove optional objects from common objects, to 
!			reduce Ruby image.  For now create OPTIONAL_OBJECTS
!			Which can be included with all loadable images
!			rather than try to disperse among other targets.
!
!  16-May-1991  jrk	major revamp
!
!  14-May-1991  jad	Add virtual
!              
!  9-May-1991   ajb	Archive old shell
!
!  9-May-1991   hcb     Add memtest_vax.mar
!
!  7-May-1991   phk     Add .include <target>_scripts.list
!
!  6-May-1991   djm     Moved zcommand and xct_driver to specific targets
!
!  2-May-1991   phk	Move the <target>_scripts lists from descrip.mms to 
!                       <target>_scripts.list files to fix a command 
!                       overrun when building target_scripts.c
!
!  1-May-1991   djm	Add in xct_driver
!
! 25-Apr-1991   cto	Add in diag_template
!
! 24-Apr-1991   phk	Add fbe csr driver
!
! 23-Apr-1991   hcb	Add build for memtest
!
! 12-Apr-1991   mc	Changed cobra_srom link addr and moved some
!			objects from srom_common to ruby_srom.
!
! 10-Apr-1991	twp	Removed mac_init from common_srom_objects
!
! 09-Apr-1991	mad	Added in more ruby_srom tests, updated
!			ruby_srom macro procedure, and added in 
!			srom_pal code.
!
! 08-Apr-1991	jad	Split out remote console functionality.
!
! 02-Apr-1991	kl	Add MBX_Driver
!
! 22-Mar-1991	jad	Remove ea_diags      
!
! 21-Mar-1991	pel	rename diag_exer to exer and metric to math
!
! 18-Mar-1991	ajb	Add ccay
!
! 14-Mar-1991	jds	Added aprdef.mar to kernel_alpha.mar build.
!
! 13-Mar-1991	jad	Added net command.
!
! 11-Mar-1991	phk	Added FBE target
!
! 11-Mar-1991	db	Added IIC bus Driver modules
!
! 07-Mar-1991	jds	Added alphamm module.
!                                            
! 05-Mar-1991	pel	breakout exer from shell_commands; put into diag_exer
!
! 04-Mar-1991	dtm	Add PAL target
!
! 01-Mar-1991	kl	Make HWRPB communications driver a TT port driver
!
! 27-Feb-1991	ajb	break out some drivers from filesys.c
!
! 19-Feb-1991	dtm	Add callbacks_alpha
!
! 13-Feb-1991	jds	Added VAXMM modules.
!
! 12-Feb-1991	dtm	add ruby/neon builds and associated dependencies
!			other fixups
!
! 25-Jan-1991   mc	add ruby_srom target
!
! 24-Jan-1991	ajb	Remove vestigal reference to nargs
!
! 24-Jan-1991	jad	add ea drivers for adu build
!
! 14-Jan-1991	mrc	add diag_support and diag_template
!
! 07-Jan-1991	cfc	for grammar.c build, remove extraction of tokens
!			from parse_def.sdl.  Some tokens require affinities
!			such as %left, hence must be explicitly defined in
!			grammar.y.  Grammar.y now contains these tokens.
!			If a token is added, it must be added to parse_def.sdl
!			as well.
!
! 03-Jan-1991	kl	add hwrpb_comm_driver
!
! 19-Dec-1990	ajb	tt port/class separation
!
! 17-Dec-1990	pel	Add metric.c
!
! 05-Dec-1990	jds	Removed exdep_util.mar.
!
! 30-Nov-1990	jds	Updated functional spec build.
!
! 16-Nov-1990	jad	mop_def.sdl and sgec_def.sdl are gone replace them.
!
! 16-Nov-1990	jad	Add ea driver.
!
! 15-Nov-1990	dtm	Add call_back.c to build
!
! 13-Nov-1990	ajb	Add adu target
!
! 06-Nov-1990	ajb	Compile noopt for eval to work around compiler bug
!
! 02-Nov-1990	kl	rename laser flag to no_decshell
!
! 02-Nov-1990	dtm	Add memconfig.
!
! 31-Oct-1990	sfs	Add Mannequin support.
!
! 30-Oct-1990	ajb	Accomodate 6 targets 
!
! 18-Oct-1990	ajb	add getverson in .last
!
! 15-Oct-1990  dtm	Add ev_action, hwrpb, machdep.h, ev_def.h.
!			Remove toklist from common objects.
!
! 05-Oct-1990  cfc	Add crack validation module.
!
! 05-Oct-1990  kl	Add sort module.
!
! 05-Oct-1990  kl	Missing logical
!
! 03-Oct-1990  ajb	Add message facility
!
! 02-Oct-1990  kl	Multiple compilation flags must be in parentheses
!
! 25-Sep-1990		Add expression evaluator
!
! 24-Sep-1990 jad	Add ni_env.h
!
! 20-Sep-1990 dtm	Remove references to EV_DEF (incorporated into
!			KERNEL_DEF).
!
! Sep 18 1990 cfc	New "change" commands for lexical.c and grammar.c
!			to enable parser to pass  PARSE and PNODE locally.
!			First, LEX, YACC generate lexical.c and grammar.c
!			Then the change commands modify the c output such
!			that internal calls to yacc, lex routines now pass
!			pointers to PARSE and PNODE rather than globally as
!			before.  This fixed scripting in the background, 
!			which was trashing global parse structures.
!
! Sep 13 1990 jds	Added examine/deposit modules.
!
! 10-Sep-1990 jad	Add tt_def.h
!
! 06-Sep-1990 jad	Add MOP counters
!
! 27-Aug-1990 jad	Add random
!
! 23-Aug-1990 ajb	Add nars
!
! 16-Aug-1990 dtm 	Add setshow.c, ev_driver.c.  Create common_object list.
!
! 16-Aug-1990 kl	Add laser compilation flag
!
! 10-Aug-1990		Add NI datalink
!
! 07-Aug-1990		Add ansi.c
!
! 01-Aug-90 jad		Add Mop conditional for ni_dvt
!
! 25-Jul-90 jad		Add Mop definitions
!
! 23-Jul-90 cfc		Move LASER link to cobra.opt (MMS command overrun).
!			Moved cobra.obj, laser.obj from opt file to descrip
!			file to have one consistent opt file.
!
! 20-Jul-90 jad		Add the NI files.
!
! 17-Jul-90 kl,dm       Multiprocessor upgrade (first pass)
!
! 06-27-90  C Crabb	Added LASER flag for conditional build.
!
! 04-Jul-1990	ajb	removed dependance on AWK for bumping sequence number
!
! 04-Aug-1990	kp	fix the spec build targets.
