G	nbytes;
	
	if(npages >= icb->i_npages)
	   return FAILURE;
	icb->i_phyhigh -= (nbytes = PTOB(npages));
	icb->i_npages  -= npages;
	if(icb->i_nbytes > nbytes)
	   icb->i_nbytes = nbytes;
	osicb.i_un.i_totmem -= nbytes;
}


/*
** Grow an existing image.
**
** Returns SUCCESS if...
** Case 1:  current icb has enough memory leftover.
** Case 2:  current icb has enough free following memory.
*/
LONG grow_image(icb,nbytes)
ICB *icb;
LONG nbytes;
{
	AUTO LONG	room_left;
	AUTO LONG	npages;
	
	if(nbytes <= (room_left = ( PTOB(icb->i_npages) - icb->i_nbytes )))
	   icb->i_nbytes += nbytes; /* increment 'logical eof' */
	else
	if((npages = BTOP(nbytes)) <= icb->i_nfree)
	{
	   icb->i_nbytes += nbytes; /* increment 'logical eof'       */
	   icb->i_npages += npages; /* increment physical page count */
	   icb->i_nfree  -= npages; /* decrement following page count*/
	   icb->i_phyhigh += PTOB(npages);
	}
	else
	   return FAILURE;
	return SUCCESS;
}



/*
** Compact existing memory images.
*/
VOID comp_images()
{
}



  /*
** Kernel resource management functions.
*/

#include <portab.h>
#include <kernel.h>

EXTERN RESHDR tcbhdr,icbhdr,srbhdr,ecbhdr,pcbhdr;

VOID res_init();
RESLINK *res_alloc();
VOID res_free();
TCB *gettcb();
ICB *geticb();
PCB *getpcb();
ECB *getecb();
SRB *getsrb();
VOID tcbfree(),icbfree(),pcbfree(),ecbfree(),srbfree();


VOID res_init(hdr,hdrnum,resources,n,size)
RESHDR *hdr;
WORD hdrnum;
BYTE *resources;
WORD n,size;
{
	WORD i;
	RESLINK *r,*next_resource;
	
	/*
	** Initialize the resource header.
	*/
	hdr->res_next = (RESHDR *)0;
	hdr->res_link = (RESLINK *)resources;
	hdr->res_num = n;
	hdr->res_size = size;
	hdr->res_nfree = n;
	/*
	** Link resources together.
	*/
	i = 1;
	r = hdr->res_link;
	while(i < n)
	{
	   next_resource = (RESLINK *)((BYTE *)(r)+size);
	   r->res_link = next_resource; /* point to next res	 */
	   r->res_hdrnum = hdrnum;	/* remember which header */
	   r = next_resource;		/* move to next resource */
	   i++;				/* increment count	 */
	}
	r->res_link = (RESLINK *)0; /* mark the end of the list */
}



RESLINK *res_alloc(hdr)
RESHDR *hdr;
{
	RESLINK *r;
	
	if(!hdr->res_nfree)
	   return(RESLINK *)0;
	hdr->res_nfree--;
	r = hdr->res_link;
	hdr->res_link 