/*
 * 	RCV SOCKET TCP 
 */

#define	UNIX	0
#define	OS2	1

#include	<stdio.h>
#include <errno.h>
#include	<ctype.h>
#include	<signal.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include <sock_err.h>

#if	OS2
#include	<sockdefs.h>
#endif

typedef	unsigned char	uchar_t;

#if	UNIX
#define	MAX_SOCKETS	32

typedef	unsigned long	Fd_set;
#define	FD_ZERO(l)	(*(l) = 0L)
#define	FD_SET(s, l)	(*(l) |= (1L << s))
#define	FD_CLR(s, l)	(*(l) &= ~(1L << s))
#define	FD_ISSET(s, l)	(*(l) & (1L << s))
#define	RM_OFFSET(s)	(s)
#define	ADD_OFFSET(s)	(s)

#define	socket_perror(a)	perror(a)
#define	socket_read(a, b, c)	read(a, b, c)
#define	socket_write(a, b, c)	write(a, b, c)
#define	socket_close(a)		close(a)
#endif

#if	OS2
typedef	fd_set		Fd_set;
#endif

Fd_set		cons;
int		conn_request_skt;
char		buf[128];
char		rbuf[MAX_SOCKETS][128];
int		ndx[MAX_SOCKETS];
extern   int   	errno;

main(argc, argv)
int  argc;
char      *argv[];
{
	int			s, ns, i;
	int			rc;
	int			addrlen;
	struct sockaddr		addr;
	struct sockaddr_in	sa_in, c_addr;
	int			port;
	struct	hostent		*he;
	int			shut_down_rcvr();

	signal(SIGINT, shut_down_rcvr);
	printf("\033[2J");
	getline(buf, "Enter port : ");
	port = atoi(buf);

	FD_ZERO(&cons);
	printMask(0, "After FD_ZERO(cons) ", &cons);
	s = socket(AF_INET, SOCK_STREAM, 6);
	printf("s=%d\n", s);
	if (s == -1)
	{
		printf("socket() failed, errno=%d\n", errno);
		perror("");
		exit(1);
	}
	sa_in.sin_family      = AF_INET;
	sa_in.sin_port        = htons(port);
	sa_in.sin_addr.s_addr = INADDR_ANY;

	errno = 0;
	rc = bind(s, (struct sockaddr *) &sa_in, sizeof(sa_in));

	if (rc == -1)
	{
		printf("bind() failed, errno=%d\n", errno);
		perror("");
      close_socket(s);
		exit(1);
	}
	rc = listen(s, 2);
	conn_request_skt = RM_OFFSET(s);
	FD_SET(conn_request_skt, &cons);
	if (rc == -1)
	{
		printf("listen() failed, errno=%d\n", errno);
		perror("");
      close_socket(s);
		exit(1);
	}
	printf("\033[2J");
	for (;;)
	{
		Fd_set		ready;

		memcpy((char *) &ready, (char *) &cons, sizeof(Fd_set));
		printMask(1, "Before select ", &ready);
		rc = select(MAX_SOCKETS,
			  &ready,
			  (Fd_set *) 0,
			  (Fd_set *) 0,
			  (struct timeval *) 0);
		printf("\033[19;1f\033[2Krc=%d\n", rc);
		if (rc == -1)
		{
			printf("\033[18;1f\033[2K");
			printf("select() failed, errno=%d\n", errno);
			perror("");
			hit_return();
			continue;
		}
		printMask(2, "After select ", &ready);
		if (FD_ISSET(conn_request_skt, &ready))
		{
			int	ns;

			addrlen = sizeof(struct sockaddr_in);
			ns = accept(s, (struct sockaddr *) &c_addr, &addrlen);
			printf("\033[23;1f");
			showAddr("After accept", &c_addr);
			FD_SET(ns, &cons);
			printf("\033[%d;1f\033[2K%02d<new-connection>",
				RM_OFFSET(ns), RM_OFFSET(ns));
		}
		else
		{
			int	skt, os2skt;
			int	n;

			skt = getNextAvailSkt(&ready);
			if (skt == -1)
				continue;
			if (skt == RM_OFFSET(s))
			{
				printf("NextAvailSocket == acceptFd\n");
				continue;
			}
			os2skt = ADD_OFFSET(skt);
         if((n=recv(os2skt, rbuf[skt], 127, 0)) != -1)
			{
				rbuf[skt][n] = '\0';
				printf("\033[%d;1f\033[2K", skt % 21);
				printf("%02d[%s]\n", skt, rbuf[skt]);
			}
			if (n < 1 || strcmp(rbuf[skt], "quit") == 0)
			{
				FD_CLR(skt, &cons);
            close_socket(ADD_OFFSET(skt));
				printf("\033[%d;1f\033[2K%02d<closed>",
					skt, skt);
			}
			else if (strcmp(rbuf[skt], "stop") == 0)
				shut_down_rcvr();
		}
	}
}

showAddr(str, a)
char    *str;
struct	sockaddr_in	*a;
{
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b1);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b2);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b3);
	printf("%03d!", (uchar_t) a->sin_addr.S_un.S_un_b.s_b4);
	printf("%u \n", (unsigned short) a->sin_port);
}

shut_down_rcvr()
{
	int	s;

	printf("\033[2J");
	printf("Closing sockets [ ");
	while ((s = getNextAvailSkt(&cons)) != -1)
	{
		printf("%d ", s);
      close_socket(ADD_OFFSET(s));
		FD_CLR(s, &cons);
	}
	printf("], ");
	hit_return();
	exit(0);
}

hit_return()
{
	char	tbuf[32];

	getline(tbuf, "hit return : ");
}

printMask(flag, str, m)
int	flag;
char	*str;
Fd_set   *m;
{
	int   	i;
	char	tbuf[32];

	if (flag < 1)
		return;
	printf("\033[%d;1f\033[2K", 20+flag);
	printf("%-17s : mask[", str);
	for (i = 0; i < MAX_SOCKETS; i++)
	{
		if (i % 8 == 0)
			putchar(' ');
		if (FD_ISSET(i, m))
			putchar('1');
		else
			putchar('0');
	}
	printf(" ]  ");
}

getNextAvailSkt(ready)
Fd_set         *ready;
{
	static	int	rs = 0;
	int		i;

	rs %= MAX_SOCKETS;
	for (i = rs; i < MAX_SOCKETS; i++)
		if (FD_ISSET(i, ready))
		{
			rs = i+1;
			return(i);
		}
	for (i = 0; i < rs; i++)
		if (FD_ISSET(i, ready))
		{
			rs = i+1;
			return(i);
		}
	return(-1);
}

getline(line, prompt)
char   *line;
char         *prompt;
{
	char	ch;

	printf("%s", prompt);
	while ((ch = getchar()) != '\n' && ch != EOF)
		*line++ = ch;
	*line = '\0';
	if (ch == EOF)
		return(EOF);
}

