/*
 *	SEND SOCKET UDP
 */

#define	UNIX	0
#define	OS2	1

#include	<stdio.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>
#include <sock_err.h>

#if	OS2
#include	<sockdefs.h>
#endif

#if	UNIX
#define	MAX_SOCKETS	32

typedef	unsigned long	Fd_set;
#define	FD_ZERO(l)	(*(l) = 0L)
#define	FD_SET(s, l)	(*(l) |= (1L << s))
#define	FD_CLR(s, l)	(*(l) &= ~(1L << s))
#define	FD_ISSET(s, l)	(*(l) & (1L << s))
#define	RM_OFFSET(s)	(s)
#define	ADD_OFFSET(s)	(s)

#define	socket_perror(a)	perror(a)
#define	socket_read(a, b, c)	read(a, b, c)
#define	socket_write(a, b, c)	write(a, b, c)
#define	socket_close(a)		close(a)
#endif

#if	OS2
typedef	fd_set		Fd_set;
#endif

extern	int		errno;
typedef unsigned char	uchar_t;

char			buf[512];

main(argc, argv)
int  argc;
char      *argv[];
{
	int			s;
	int			rc;
	struct sockaddr_in	sa_in;
	int			tolen = sizeof(struct sockaddr_in);
	struct sockaddr		*to = (struct sockaddr *) &sa_in;
	short			port;
	struct	hostent		*he;

	getline(buf, "Host name : ");
	if ((he = gethostbyname(buf)) == NULL)
	{
		printf("Can't get '%s' address.\n");
		exit(1);
	}
	memcpy((char *) &sa_in.sin_addr.s_addr, he->h_addr, he->h_length);
	getline(buf, "Port : ");
	port = atoi(buf);
	sa_in.sin_port   = htons(port);
	sa_in.sin_family = AF_INET;
	showAddr("will send datagrams to", &sa_in);

	errno = 0;
	s = socket(AF_INET, SOCK_DGRAM, 17);
	printf("s=%d\n", s);
	if (s == -1)
	{
		printf("socket() failed, errno=%d\n", errno);
		exit(1);
	}
	for (;;)
	{
		getline(buf, "msg : ");
		if (buf[0] == 'q')
			break;

		errno = 0;
		if (sendto(s, buf, strlen(buf), 0, to, tolen) == -1)
		{
			showAddr("can't send to", (struct sockaddr_in *) to);
			printf("sendto, errno=%d\n", errno);
			break;
		}
		printf("sendto, errno=%d\n", errno);
	}
   close_socket(s);
}

showAddr(str, a)
char    *str;
struct	sockaddr_in	*a;
{
	printf("(%s) ", str);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b1);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b2);
	printf("%03d.", (uchar_t) a->sin_addr.S_un.S_un_b.s_b3);
	printf("%03d!", (uchar_t) a->sin_addr.S_un.S_un_b.s_b4);
	printf("%u \n", (unsigned short) a->sin_port);
}

getline(line, prompt)
char   *line;
char         *prompt;
{
	char	ch;

	printf("%s", prompt);
	while ((ch = getchar()) != '\n' && ch != EOF)
		*line++ = ch;
	*line = '\0';
	if (ch == EOF)
		return(EOF);
}

