/* branch.c - Branch Instructions */


#include "defines.h"


/* brx() - Simple Branch Instructions. */

void
brx(clear, set)
    unsigned clear;
    unsigned set;
{
    uint16_t offset;

    if (((psw & set) == set) && ((psw & clear) == 0)) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* br() - Branch Always. */

void
br()
{
    uint16_t offset;

    offset = LOW8(ir);
    if (offset & SIGN_B)
	offset += 0177400;
    regs[PC] += (offset * 2);
}


/* blos() - Branch Lower or Same Instruction. */

void
blos()
{
    uint16_t offset;

    if ((psw & CC_C) || (psw & CC_Z)) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* bge() - Branch Greater Than or Equal Instruction. */

void
bge()
{
    uint16_t offset;
    unsigned nbit;
    unsigned vbit;

    nbit = (psw & CC_N) ? 1 : 0;
    vbit = (psw & CC_V) ? 1 : 0;

    if ((nbit ^ vbit) == 0) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* blt() - Branch Less Than Instruction. */

void
blt()
{
    uint16_t offset;
    unsigned nbit;
    unsigned vbit;

    nbit = (psw & CC_N) ? 1 : 0;
    vbit = (psw & CC_V) ? 1 : 0;

    if ((nbit ^ vbit) == 1) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* ble() - Branch Less Than Or Equal Instruction. */

void
ble()
{
    uint16_t offset;
    unsigned nbit;
    unsigned vbit;

    nbit = (psw & CC_N) ? 1 : 0;
    vbit = (psw & CC_V) ? 1 : 0;

    if (((nbit ^ vbit) == 1) || (psw & CC_Z)) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* bgt() - Branch Greater Than Instruction. */

void
bgt()
{
    uint16_t offset;
    unsigned nbit;
    unsigned vbit;

    nbit = (psw & CC_N) ? 1 : 0;
    vbit = (psw & CC_V) ? 1 : 0;

    if (((nbit ^ vbit) == 0) && ((psw & CC_Z) == 0)) {
	offset = LOW8(ir);
	if (offset & SIGN_B)
	    offset += 0177400;
	regs[PC] += (offset * 2);
    }
}


/* jmp() - Jump Instruction. */

void
jmp()
{
    load_ea(&(regs[PC]));
}



/* jsr() - Jump To Subroutine Instruction. */

void
jsr()
{
    uint16_t data;

    load_ea(&data);
    push(regs[SRC_REG]);
    regs[SRC_REG] = regs[PC];
    regs[PC] = data;
}


/* rts() - Return From Subroutine Instruction. */

void
rts()
{
    uint16_t data;

    regs[PC] = regs[DST_REG];
    pop(&data);
    regs[DST_REG] = data;
}
