/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <errno.h>
# include <fcntl.h>
# include <unistd.h>
# include <string.h>

# include "../system.h"
# include "../compat.h"

# include "tty.h"


int		cs7;
char		*fname;



volatile void
Exit(int ex)
{
	unlink(fname);
	exit(ex);
}

/*
 * fd 0 is socket to parent
 */
int
main(int argc, char *argv[])
{
	int	opt;
	int	fd;

	while((opt = getopt(argc, argv, "7")) != EOF)
		switch(opt) {

		case '7':
			cs7 = 1;
			break;
		}
	argc -= optind;
	argv += optind;

	tty_init();

	if(mkfifo(fname = argv[0], 0666))
		return 80;
	if((fd = open(fname, 2)) < 0)
		return 81;
	if(setsid() < 0)
		return 82;

	tty_loop(fd);

	Exit(0);
}

void
process_output()
{
	if(cs7)
		makecs7();
}

void
process_input()
{
}
