/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * fast block move, addresses are aligned on 16bit boundaries
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)

/************************************************************
 *
 * processor emulation
 */

/*
 * Test word/byte and set N and Z
 */
# define TestW(V)	asm("	sll	%2,16,%%g1			;\
				tst	%%g1				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1"			\
			: "=g"(proc.z), "=g"(proc.n)			\
			: "r"((short)V) : "g1", "cc")

# define TestB(V)	asm("	sll	%2,24,%%g1			;\
				tst	%%g1				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1"			\
			: "=g"(proc.z), "=g"(proc.n)			\
			: "r"(V) : "g1", "cc")

/*
 * compare words/bytes and set NZCV
 */
# define CmpW(D,S)	asm("	sll	%4,16,%4			;\
				sll	%5,16,%5			;\
				cmp	%5,%4				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v) \
			: "r"((short)D), "r"((short)S) : "g1", "cc" )

# define CmpB(D,S)	asm("	sll	%4,24,%4			;\
				sll	%5,24,%5			;\
				cmp	%5,%4				;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v) \
			: "r"((short)D), "r"((short)S) : "g1", "cc" )

/*
 * sub/add words/bytes and set NZCV
 */
# define SubWC(D,S)	asm("	sll	%6,16,%6			;\
				sll	%5,16,%5			;\
				subcc	%5,%6,%4			;\
				sra	%4,16,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define AddWC(D,S)	asm("	sll	%6,16,%6			;\
				sll	%5,16,%5			;\
				addcc	%6,%5,%4			;\
				sra	%4,16,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define SubBC(D,S)	asm("	sll	%6,24,%6			;\
				sll	%5,24,%5			;\
				subcc	%5,%6,%4			;\
				sra	%4,24,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

# define AddBC(D,S)	asm("	sll	%6,24,%6			;\
				sll	%5,24,%5			;\
				addcc	%6,%5,%4			;\
				sra	%4,24,%4			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				addx	%%g0,0,%%g1			;\
				stb	%%g1,%2				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%3"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.c), "=g"(proc.v), "=r"(D) \
			: "4"((short)D), "r"((short)S) : "g1", "cc" )

/*
 * sub/add words/bytes and set NZV
 */
# define SubW(D,S)	asm("	sll	%5,16,%5			;\
				sll	%4,16,%4			;\
				subcc	%4,%5,%3			;\
				sra	%3,16,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define AddW(D,S)	asm("	sll	%5,16,%5			;\
				sll	%4,16,%4			;\
				addcc	%5,%4,%3			;\
				sra	%3,16,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define SubB(D,S)	asm("	sll	%5,24,%5			;\
				sll	%4,24,%4			;\
				subcc	%4,%5,%3			;\
				sra	%3,24,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )

# define AddB(D,S)	asm("	sll	%5,24,%5			;\
				sll	%4,24,%4			;\
				addcc	%5,%4,%3			;\
				sra	%3,24,%3			;\
				be,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%0				;\
				bneg,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%1				;\
				bvs,a	1f				;\
				mov	1,%%g1				;\
				mov	0,%%g1				;\
			1:						;\
				stb	%%g1,%2"			\
			: "=g"(proc.z), "=g"(proc.n), "=g"(proc.v), "=r"(D) \
			: "3"((short)D), "r"((short)S) : "g1", "cc" )


# define SwabB(D)	(D)=((((D)<<8)&0xff00)|(((D)>>8)&0xff))

# define SCHAR(S)	((sshort)(schar)(S))

# define Div(v1,v2,v,d)	(v1 = v/d, v2 = v%d)
