/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: error.c,v 1.5 1998/03/17 15:33:04 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"
# include "private.h"

static int errorcnt;

/*
 * Display an error message.
 */
void
error(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	begemot_common_err("error", "\n", fmt, ap);
	va_end(ap);

	errorcnt++;
}
void
verror(const char *fmt, va_list ap)
{
	begemot_common_err("error", "\n", fmt, ap);

	errorcnt++;
}

int
geterrorcnt()
{
	return errorcnt;
}
